/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.registry;

import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.item.tab.TabBuilder;
import net.darkhax.bookshelf.api.registry.CommandArgumentEntry;
import net.darkhax.bookshelf.api.registry.IContentLoader;
import net.darkhax.bookshelf.api.registry.IRegistryEntries;
import net.darkhax.bookshelf.api.registry.RegistryDataProvider;
import net.darkhax.bookshelf.impl.util.ForgeEventHelper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;

public class ContentLoaderForge
implements IContentLoader {
    @Override
    public void loadContent(RegistryDataProvider content) {
        this.consumeRegistry(content.blocks, Registries.f_256747_);
        this.consumeRegistry(content.fluids, Registries.f_256808_);
        this.consumeRegistry(content.items, Registries.f_256913_);
        this.consumeRegistry(content.bannerPatterns, Registries.f_256969_);
        this.consumeRegistry(content.mobEffects, Registries.f_256929_);
        this.consumeRegistry(content.sounds, Registries.f_256840_);
        this.consumeRegistry(content.potions, Registries.f_256973_);
        this.consumeRegistry(content.enchantments, Registries.f_256762_);
        this.consumeRegistry(content.entities, Registries.f_256939_);
        this.consumeRegistry(content.blockEntities, Registries.f_256922_);
        this.consumeRegistry(content.particleTypes, Registries.f_256890_);
        this.consumeRegistry(content.menus, Registries.f_256798_);
        this.consumeRegistry(content.recipeSerializers, Registries.f_256764_);
        this.consumeRegistry(content.paintings, Registries.f_256836_);
        this.consumeRegistry(content.attributes, Registries.f_256728_);
        this.consumeRegistry(content.stats, Registries.f_256849_);
        this.consumeRegistry(content.villagerProfessions, Registries.f_256749_);
        this.consumeRegistry(content.recipeTypes, Registries.f_256954_);
        this.consumeArgumentTypes(content.commandArguments);
        this.consumeWithForgeEvent(content.commands, RegisterCommandsEvent.class, (event, id, builder) -> builder.build((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection()));
        ForgeEventHelper.addContextListener(VillagerTradesEvent.class, content.trades.getVillagerTrades(), this::registerVillagerTrades);
        ForgeEventHelper.addContextListener(WandererTradesEvent.class, content.trades.getCommonWanderingTrades(), content.trades.getRareWanderingTrades(), this::registerWanderingTrades);
        this.consumeWithForgeEvent(content.dataListeners, AddReloadListenerEvent.class, (event, id, arg) -> event.addListener(arg));
        this.consumeWithModEvent(content.creativeTabs, CreativeModeTabEvent.Register.class, (event, id, arg) -> event.registerCreativeModeTab(id, builder -> arg.accept(new TabBuilder(builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.%s.%s".formatted(id.m_135827_(), id.m_135815_())))))));
        if (Services.PLATFORM.isPhysicalClient()) {
            this.loadClient(content);
        }
    }

    private void loadClient(RegistryDataProvider content) {
        this.consumeWithModEvent(content.resourceListeners, RegisterClientReloadListenersEvent.class, (event, id, arg) -> event.registerReloadListener(arg));
    }

    private void registerVillagerTrades(VillagerTradesEvent event, Map<VillagerProfession, Multimap<Integer, VillagerTrades.ItemListing>> trades) {
        Multimap<Integer, VillagerTrades.ItemListing> newTrades = trades.get(event.getType());
        if (newTrades != null) {
            Int2ObjectMap tradeData = event.getTrades();
            for (Map.Entry entry : newTrades.entries()) {
                ((List)tradeData.computeIfAbsent((Object)((Integer)entry.getKey()), ArrayList::new)).add((VillagerTrades.ItemListing)entry.getValue());
            }
        }
    }

    private void registerWanderingTrades(WandererTradesEvent event, List<VillagerTrades.ItemListing> common, List<VillagerTrades.ItemListing> rare) {
        event.getGenericTrades().addAll(common);
        event.getRareTrades().addAll(rare);
    }

    private <ET extends Event, RT> void consumeWithForgeEvent(IRegistryEntries<RT> registry, Class<ET> eventType, EventConsumer<ET, RT> func) {
        Consumer<Event> listener = event -> registry.build((id, value) -> func.apply(event, (ResourceLocation)id, value));
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, eventType, listener);
    }

    private <ET extends Event, RT> void consumeWithModEvent(IRegistryEntries<RT> registry, Class<ET> eventType, EventConsumer<ET, RT> func) {
        Consumer<Event> listener = event -> registry.build((id, value) -> func.apply(event, (ResourceLocation)id, value));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, eventType, listener);
    }

    private <T> void consumeRegistry(IRegistryEntries<T> registry, ResourceKey<? extends Registry<T>> registryKey) {
        this.consumeRegistry(registry, registryKey, v -> v);
    }

    private <T> void consumeRegistry(IRegistryEntries<T> registry, ResourceKey<? extends Registry<T>> registryKey, Function<T, ? extends T> wrapper) {
        Consumer<RegisterEvent> listener = event -> {
            if (event.getRegistryKey().equals((Object)registryKey)) {
                registry.build((id, value) -> event.register(registryKey, id, () -> wrapper.apply(value)));
            }
        };
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, RegisterEvent.class, listener);
    }

    private void consumeArgumentTypes(IRegistryEntries<CommandArgumentEntry<?, ?, ?>> registry) {
        if (registry.isEmpty()) {
            return;
        }
        Consumer<RegisterEvent> listener = event -> {
            if (event.getRegistryKey().equals((Object)Registries.f_256982_)) {
                registry.build((id, value) -> event.register(Registries.f_256982_, id, () -> {
                    ArgumentTypeInfo serializer = (ArgumentTypeInfo)value.getSerializer().get();
                    ArgumentTypeInfos.registerByClass(value.getType(), (ArgumentTypeInfo)serializer);
                    return serializer;
                }));
            }
        };
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, RegisterEvent.class, listener);
    }

    static interface EventConsumer<E extends Event, V> {
        public void apply(E var1, ResourceLocation var2, V var3);
    }
}

