/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.sleeping_bags.corelib.item;

import java.util.Comparator;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemUtils {
    public static final Comparator<ItemStack> ITEM_COMPARATOR = (item1, item2) -> {
        int cmp = item2.m_41720_().hashCode() - item1.m_41720_().hashCode();
        if (cmp != 0) {
            return cmp;
        }
        cmp = item2.m_41773_() - item1.m_41773_();
        if (cmp != 0) {
            return cmp;
        }
        CompoundTag c1 = item1.m_41783_();
        CompoundTag c2 = item2.m_41783_();
        if (c1 == null && c2 == null) {
            return 0;
        }
        if (c1 == null) {
            return 1;
        }
        if (c2 == null) {
            return -1;
        }
        return c1.hashCode() - c2.hashCode();
    };

    public static ItemStack itemStackAmount(int amount, ItemStack stack, Player player) {
        if (stack == null || stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (player != null && player.m_150110_().f_35937_) {
            return stack;
        }
        stack.m_41764_(stack.m_41613_() + amount);
        if (stack.m_41613_() <= 0) {
            stack.m_41764_(0);
            return ItemStack.f_41583_;
        }
        if (stack.m_41613_() > stack.m_41741_()) {
            stack.m_41764_(stack.m_41741_());
        }
        return stack;
    }

    public static ItemStack decrItemStack(ItemStack stack, Player player) {
        return ItemUtils.itemStackAmount(-1, stack, player);
    }

    public static ItemStack incrItemStack(ItemStack stack, Player player) {
        return ItemUtils.itemStackAmount(1, stack, player);
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (stack1.m_41720_() == stack2.m_41720_()) {
            return stack1.m_41773_() == stack2.m_41773_();
        }
        return false;
    }

    public static void saveInventory(CompoundTag compound, String name, Container inv) {
        ListTag tagList = new ListTag();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (inv.m_8020_(i).m_41619_()) continue;
            CompoundTag slot = new CompoundTag();
            slot.m_128405_("Slot", i);
            inv.m_8020_(i).m_41739_(slot);
            tagList.add((Object)slot);
        }
        compound.m_128365_(name, (Tag)tagList);
    }

    public static void saveInventory(CompoundTag compound, String name, NonNullList<ItemStack> inv) {
        ListTag tagList = new ListTag();
        for (int i = 0; i < inv.size(); ++i) {
            if (((ItemStack)inv.get(i)).m_41619_()) continue;
            CompoundTag slot = new CompoundTag();
            slot.m_128405_("Slot", i);
            ((ItemStack)inv.get(i)).m_41739_(slot);
            tagList.add((Object)slot);
        }
        compound.m_128365_(name, (Tag)tagList);
    }

    public static void saveItemList(CompoundTag compound, String name, NonNullList<ItemStack> list) {
        ItemUtils.saveItemList(compound, name, list, true);
    }

    public static void saveItemList(CompoundTag compound, String name, NonNullList<ItemStack> list, boolean includeEmpty) {
        ListTag itemList = new ListTag();
        for (ItemStack stack : list) {
            if (!includeEmpty && stack.m_41619_()) continue;
            itemList.add((Object)stack.m_41739_(new CompoundTag()));
        }
        compound.m_128365_(name, (Tag)itemList);
    }

    public static void readInventory(CompoundTag compound, String name, Container inv) {
        if (!compound.m_128441_(name)) {
            return;
        }
        ListTag tagList = compound.m_128437_(name, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag slot = tagList.m_128728_(i);
            int j = slot.m_128451_("Slot");
            if (j < 0 || j >= inv.m_6643_()) continue;
            inv.m_6836_(j, ItemStack.m_41712_((CompoundTag)slot));
        }
    }

    public static void readInventory(CompoundTag compound, String name, NonNullList<ItemStack> inv) {
        if (!compound.m_128441_(name)) {
            return;
        }
        ListTag tagList = compound.m_128437_(name, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag slot = tagList.m_128728_(i);
            int j = slot.m_128451_("Slot");
            if (j < 0 || j >= inv.size()) continue;
            inv.set(j, (Object)ItemStack.m_41712_((CompoundTag)slot));
        }
    }

    public static NonNullList<ItemStack> readItemList(CompoundTag compound, String name, boolean includeEmpty) {
        NonNullList items = NonNullList.m_122779_();
        if (!compound.m_128441_(name)) {
            return items;
        }
        ListTag itemList = compound.m_128437_(name, 10);
        for (int i = 0; i < itemList.size(); ++i) {
            ItemStack item = ItemStack.m_41712_((CompoundTag)itemList.m_128728_(i));
            if (!includeEmpty) {
                if (item.m_41619_()) continue;
                items.add((Object)item);
                continue;
            }
            items.add((Object)item);
        }
        return items;
    }

    public static NonNullList<ItemStack> readItemList(CompoundTag compound, String name) {
        return ItemUtils.readItemList(compound, name, true);
    }

    public static void readItemList(CompoundTag compound, String name, NonNullList<ItemStack> list) {
        if (!compound.m_128441_(name)) {
            return;
        }
        ListTag itemList = compound.m_128437_(name, 10);
        for (int i = 0; i < itemList.size() && i < list.size(); ++i) {
            list.set(i, (Object)ItemStack.m_41712_((CompoundTag)itemList.m_128728_(i)));
        }
    }

    public static void removeStackFromSlot(Container inventory, int index) {
        inventory.m_6836_(index, ItemStack.f_41583_);
    }

    public static boolean isStackable(ItemStack stack1, ItemStack stack2) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)stack1, (ItemStack)stack2);
    }

    public static CompoundTag writeOverstackedItem(CompoundTag compound, ItemStack stack) {
        stack.m_41739_(compound);
        compound.m_128473_("Count");
        compound.m_128405_("Count", stack.m_41613_());
        return compound;
    }

    public static ItemStack readOverstackedItem(CompoundTag compound) {
        CompoundTag data = compound.m_6426_();
        int count = data.m_128451_("Count");
        data.m_128473_("Count");
        data.m_128344_("Count", (byte)1);
        ItemStack stack = ItemStack.m_41712_((CompoundTag)data);
        stack.m_41764_(count);
        return stack;
    }
}

