/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.sleepingbags.items;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemSleepingBag
extends Item {
    protected DyeColor dyeColor;

    public ItemSleepingBag(DyeColor dyeColor) {
        super(new Item.Properties().m_41487_(1));
        this.dyeColor = dyeColor;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (worldIn.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)playerIn.m_21120_(handIn));
        }
        if (!BedBlock.m_49488_((Level)worldIn)) {
            playerIn.m_5661_((Component)Component.m_237115_((String)"message.sleeping_bags.cant_sleep_here"), true);
            return InteractionResultHolder.m_19090_((Object)playerIn.m_21120_(handIn));
        }
        if (!playerIn.m_20096_()) {
            playerIn.m_5661_((Component)Component.m_237115_((String)"message.sleeping_bags.cant_sleep_in_air"), true);
            return InteractionResultHolder.m_19090_((Object)playerIn.m_21120_(handIn));
        }
        this.trySleep((ServerPlayer)playerIn).ifLeft(sleepResult -> {
            if (sleepResult != null && sleepResult.m_36423_() != null) {
                playerIn.m_5661_(sleepResult.m_36423_(), true);
            }
        });
        return InteractionResultHolder.m_19090_((Object)playerIn.m_21120_(handIn));
    }

    public Either<Player.BedSleepingProblem, Unit> trySleep(ServerPlayer player) {
        Vec3 vector3d;
        List list;
        Player.BedSleepingProblem ret = ForgeEventFactory.onPlayerSleepInBed((Player)player, Optional.empty());
        if (ret != null) {
            return Either.left((Object)ret);
        }
        if (player.m_5803_() || !player.m_6084_()) {
            return Either.left((Object)Player.BedSleepingProblem.OTHER_PROBLEM);
        }
        if (!player.f_19853_.m_6042_().f_63858_()) {
            return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_HERE);
        }
        if (player.f_19853_.m_46461_()) {
            return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
        }
        if (!ForgeEventFactory.fireSleepingTimeCheck((Player)player, Optional.empty())) {
            return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
        }
        if (!player.m_7500_() && !(list = player.f_19853_.m_6443_(Monster.class, new AABB((vector3d = player.m_20182_()).m_7096_() - 8.0, vector3d.m_7098_() - 5.0, vector3d.m_7094_() - 8.0, vector3d.m_7096_() + 8.0, vector3d.m_7098_() + 5.0, vector3d.m_7094_() + 8.0), entity -> entity.m_6935_((Player)player))).isEmpty()) {
            return Either.left((Object)Player.BedSleepingProblem.NOT_SAFE);
        }
        player.m_7166_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_));
        if (player.m_20159_()) {
            player.m_8127_();
        }
        player.m_20124_(Pose.SLEEPING);
        player.m_21250_(player.m_20183_());
        player.m_20256_(Vec3.f_82478_);
        player.f_19812_ = true;
        player.f_36110_ = 0;
        player.m_36220_(Stats.f_12969_);
        CriteriaTriggers.f_10583_.m_222618_(player);
        ((ServerLevel)player.f_19853_).m_8878_();
        return Either.right((Object)Unit.INSTANCE);
    }
}

