/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure;

import com.legacy.structure_gel.api.structure.base.IPieceBuilderModifier;
import com.legacy.structure_gel.api.structure.jigsaw.IPieceFactory;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawCapability;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.legacy.structure_gel.core.structure.ExtendedJigsawPlacement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;

public class ExtendedJigsawStructure
extends JigsawStructure
implements IPieceBuilderModifier {
    public static final Codec<ExtendedJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtendedJigsawStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(jigsaw -> jigsaw.f_227605_), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(jigsaw -> jigsaw.f_227606_), (App)Codec.intRange((int)0, (int)32).fieldOf("size").forGetter(jigsaw -> jigsaw.f_227607_), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(jigsaw -> jigsaw.f_227608_), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(jigsaw -> jigsaw.f_227609_), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(jigsaw -> jigsaw.f_227610_), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(jigsaw -> jigsaw.f_227611_), (App)JigsawCapability.CODEC.optionalFieldOf("capability").forGetter(jigsaw -> jigsaw.capability)).apply((Applicative)instance, ExtendedJigsawStructure::new)).flatXmap(ExtendedJigsawStructure::verifyRange, ExtendedJigsawStructure::verifyRange).codec();
    protected final Optional<JigsawCapability.IJigsawCapability> capability;

    protected DataResult<ExtendedJigsawStructure> verifyRange() {
        byte dist = switch (this.m_226620_()) {
            case TerrainAdjustment.NONE -> 0;
            case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> 12;
            default -> throw new IncompatibleClassChangeError();
        };
        return this.f_227611_ + dist > 128 ? DataResult.error((String)("Structure size including terrain adaptation must not exceed 128. Terrain adaptation dist: " + dist + ", Size: " + this.f_227611_)) : DataResult.success((Object)this);
    }

    protected ExtendedJigsawStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, HeightProvider startHeight, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, Optional<JigsawCapability.IJigsawCapability> capability) {
        super(settings, startPool, startJigsawName, maxDepth, startHeight, useExpansionHack, projectStartToHeightmap, maxDistanceFromCenter);
        this.capability = capability;
    }

    public static Builder builder(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool) {
        return new Builder(settings, startPool);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        int height = this.f_227608_.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        BlockPos pos = new BlockPos(chunkPos.m_45604_(), height, chunkPos.m_45605_());
        if (this.capability.isEmpty() || this.capability.get().canPlace(context, pos, new PlaceContext((Holder<StructureTemplatePool>)this.f_227605_, this.f_227606_, this.f_227607_, this.f_227609_, this.f_227610_, this.f_227611_, this.capability))) {
            return new ExtendedJigsawPlacement(this).addPieces(context, (Holder<StructureTemplatePool>)this.f_227605_, this.f_227606_, this.f_227607_, pos, this.f_227609_, this.f_227610_, this.f_227611_);
        }
        return Optional.empty();
    }

    public StructureType<?> m_213658_() {
        return SGRegistry.StructureTypes.EXTENDED_JIGSAW.get();
    }

    public IPieceFactory getPieceFactory() {
        if (this.capability.isPresent()) {
            return this.capability.get().getPieceFactory();
        }
        return IPieceFactory.VANILLA;
    }

    @Override
    public void modifyPieceBuilder(StructurePiecesBuilder pieceBuilder, Structure.GenerationContext context) {
        if (this.capability.isPresent()) {
            this.capability.get().modifyPieceBuilder(pieceBuilder, context);
        }
    }

    public Optional<JigsawCapability.IJigsawCapability> getCapability() {
        return this.capability;
    }

    public <T extends JigsawCapability.IJigsawCapability> Optional<T> getCapability(Class<T> expectedClass) {
        return this.getCapability().map(cap -> expectedClass.isInstance(cap) ? (JigsawCapability.IJigsawCapability)expectedClass.cast(cap) : null);
    }

    public static class Builder {
        final Structure.StructureSettings settings;
        final Holder<StructureTemplatePool> startPool;
        Optional<ResourceLocation> startJigsawName = Optional.empty();
        int maxDepth = 7;
        HeightProvider startHeight = ConstantHeight.f_161945_;
        boolean useExpansionHack = false;
        Optional<Heightmap.Types> projectStartToHeightmap = Optional.empty();
        int maxDistanceFromCenter = 80;
        Optional<JigsawCapability.IJigsawCapability> capability = Optional.empty();

        private Builder(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool) {
            this.settings = settings;
            this.startPool = startPool;
        }

        public Builder startJigsaw(ResourceLocation startJigsawName) {
            this.startJigsawName = Optional.ofNullable(startJigsawName);
            return this;
        }

        public Builder maxDepth(int maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public Builder startHeight(HeightProvider startHeight) {
            this.startHeight = startHeight;
            return this;
        }

        public Builder startHeight(int startHeight) {
            return this.startHeight((HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)startHeight)));
        }

        public Builder startHeight(int minHeight, int maxHeight) {
            return this.startHeight((HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158922_((int)minHeight), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxHeight)));
        }

        public Builder useExpansionHack() {
            this.useExpansionHack = true;
            return this;
        }

        public Builder heightmap(Heightmap.Types heightmap) {
            this.projectStartToHeightmap = Optional.ofNullable(heightmap);
            return this;
        }

        public Builder onSurface() {
            return this.heightmap(Heightmap.Types.WORLD_SURFACE_WG);
        }

        public Builder onOceanFloor() {
            return this.heightmap(Heightmap.Types.OCEAN_FLOOR_WG);
        }

        public Builder maxDistanceFromCenter(int maxDistanceFromCenter) {
            this.maxDistanceFromCenter = maxDistanceFromCenter;
            return this;
        }

        public Builder capability(JigsawCapability.IJigsawCapability capability) {
            this.capability = Optional.ofNullable(capability);
            return this;
        }

        public ExtendedJigsawStructure build() {
            return new ExtendedJigsawStructure(this.settings, this.startPool, this.startJigsawName, this.maxDepth, this.startHeight, this.useExpansionHack, this.projectStartToHeightmap, this.maxDistanceFromCenter, this.capability);
        }
    }

    public record PlaceContext(Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, Optional<JigsawCapability.IJigsawCapability> capability) {
    }
}

