/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure;

import com.legacy.structure_gel.api.structure.base.IModifyState;
import com.legacy.structure_gel.api.structure.processor.RemoveGelStructureProcessor;
import com.legacy.structure_gel.core.block_entity.DataHandlerBlockEntity;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.legacy.structure_gel.core.structure.GelTemplate;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GelTemplateStructurePiece
extends TemplateStructurePiece
implements IModifyState {
    private static final Logger LOGGER = LogManager.getLogger();
    public Rotation f_73379_ = Rotation.NONE;
    public Mirror f_73378_ = Mirror.NONE;

    public GelTemplateStructurePiece(StructurePieceType structurePieceType, int componentType, StructureTemplateManager structureManager, ResourceLocation templateName, StructurePlaceSettings placeSettings, BlockPos pos) {
        super(structurePieceType, componentType, structureManager, templateName, templateName.toString(), placeSettings, pos);
    }

    public GelTemplateStructurePiece(StructurePieceType structurePieceType, int componentType, StructureTemplateManager structureManager, ResourceLocation templateName, BlockPos pos) {
        this(structurePieceType, componentType, structureManager, templateName, new StructurePlaceSettings(), pos);
    }

    public GelTemplateStructurePiece(StructurePieceType structurePieceType, CompoundTag nbt, StructureTemplateManager structureManager, Function<ResourceLocation, StructurePlaceSettings> placeSettingsGetter) {
        super(structurePieceType, nbt, structureManager, placeSettingsGetter);
        this.f_73379_ = GelTemplateStructurePiece.getRotation(nbt);
        this.f_73378_ = GelTemplateStructurePiece.getMirror(nbt);
    }

    public GelTemplateStructurePiece(StructurePieceType structurePieceType, CompoundTag nbt, StructureTemplateManager structureManager) {
        this(structurePieceType, nbt, structureManager, name -> new StructurePlaceSettings());
    }

    protected StructurePlaceSettings getPlaceSettings(StructureTemplateManager structureManager) {
        return new StructurePlaceSettings();
    }

    protected void setupPlaceSettings(StructureTemplateManager structureManager) {
        StructurePlaceSettings placeSettings = this.getPlaceSettings(structureManager).m_74379_(this.f_73379_).m_74377_(this.f_73378_);
        placeSettings.m_74379_(this.f_73379_);
        placeSettings.m_74377_(this.f_73378_);
        if (this.useGelProcessor() && !placeSettings.m_74411_().contains((Object)RemoveGelStructureProcessor.INSTANCE)) {
            placeSettings.m_74383_((StructureProcessor)RemoveGelStructureProcessor.INSTANCE);
        }
        this.f_73657_ = placeSettings;
        this.f_73383_ = this.f_73656_.m_74633_(this.f_73657_, this.f_73658_);
    }

    protected boolean useGelProcessor() {
        return true;
    }

    public static BlockPos getPos(CompoundTag nbt) {
        return new BlockPos(nbt.m_128451_("TPX"), nbt.m_128451_("TPY"), nbt.m_128451_("TPZ"));
    }

    public static Rotation getRotation(CompoundTag nbt) {
        return Rotation.valueOf((String)nbt.m_128461_("Rot"));
    }

    public static Mirror getMirror(CompoundTag nbt) {
        return Mirror.valueOf((String)nbt.m_128461_("Mirror"));
    }

    protected void m_183620_(StructurePieceSerializationContext level, CompoundTag nbt) {
        super.m_183620_(level, nbt);
        nbt.m_128359_("Rot", this.f_73379_.name());
        nbt.m_128359_("Mirror", this.f_73378_.name());
    }

    @Internal
    public void m_213694_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGen, RandomSource rand, BoundingBox bounds, ChunkPos chunkPos, BlockPos pos) {
        this.f_73657_.m_74381_(bounds);
        this.f_73383_ = this.f_73656_.m_74633_(this.f_73657_, this.f_73658_);
        if (GelTemplate.placeInWorld(this.f_73656_, (ServerLevelAccessor)level, this.f_73658_, pos, this.f_73657_, rand, 2, this::modifyState)) {
            GelTemplateStructurePiece.processDataHandlers(this, this.f_73656_, this.f_73658_, this.f_73657_, level, rand, bounds);
            for (StructureTemplate.StructureBlockInfo blockInfo : this.f_73656_.m_74603_(this.f_73658_, this.f_73657_, Blocks.f_50677_)) {
                if (blockInfo.f_74677_ == null || StructureMode.valueOf((String)blockInfo.f_74677_.m_128461_("mode")) != StructureMode.DATA) continue;
                this.m_213704_(blockInfo.f_74677_.m_128461_("metadata"), blockInfo.f_74675_, (ServerLevelAccessor)level, rand, bounds);
            }
            for (StructureTemplate.StructureBlockInfo blockInfo : this.f_73656_.m_74603_(this.f_73658_, this.f_73657_, Blocks.f_50678_)) {
                if (blockInfo.f_74677_ == null) continue;
                String stateString = blockInfo.f_74677_.m_128461_("final_state");
                BlockState state = Blocks.f_50016_.m_49966_();
                try {
                    state = BlockStateParser.m_245437_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (String)stateString, (boolean)false).f_234748_();
                }
                catch (CommandSyntaxException ex) {
                    LOGGER.error("Error while parsing blockstate {} in structure block @ {}", (Object)stateString, (Object)blockInfo.f_74675_);
                }
                level.m_7731_(blockInfo.f_74675_, state, 3);
            }
        }
    }

    public static void processDataHandlers(TemplateStructurePiece piece, StructureTemplate template, BlockPos templatePos, StructurePlaceSettings placeSettings, WorldGenLevel level, RandomSource rand, BoundingBox bounds) {
        for (StructureTemplate.StructureBlockInfo blockInfo : template.m_74603_(templatePos, placeSettings, (Block)SGRegistry.Blocks.DATA_HANDLER.get())) {
            ResourceLocation typeName;
            BlockState state = level.m_8055_(blockInfo.f_74675_);
            if (blockInfo.f_74677_ == null || state.m_60734_() != SGRegistry.Blocks.DATA_HANDLER.get() || (typeName = DataHandlerBlockEntity.readType(blockInfo.f_74677_)) == null) continue;
            DataHandlerBlockEntity.handle(state, typeName, DataHandlerBlockEntity.readDataEntries(blockInfo.f_74677_), blockInfo.f_74675_, level, rand, bounds, (StructurePiece)piece, false);
        }
    }

    @Override
    @Nullable
    public BlockState modifyState(ServerLevelAccessor level, RandomSource rand, BlockPos pos, BlockState originalState) {
        return originalState;
    }
}

