/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure.jigsaw;

import com.legacy.structure_gel.api.structure.base.IModifyState;
import com.legacy.structure_gel.api.structure.jigsaw.IPieceFactory;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawAccessHelper;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawCapability;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.structure.jigsaw.GelSinglePoolElement;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.util.Lazy;

public abstract class ExtendedJigsawStructurePiece
extends PoolElementStructurePiece
implements IModifyState {
    private static final String CAP_KEY = "capability";
    private Optional<JigsawCapability.IJigsawCapability> jigsawCapability = Optional.empty();

    public ExtendedJigsawStructurePiece(IPieceFactory.Context context) {
        super(context.structureManager(), context.poolElement(), context.pos(), context.groundLevelDelta(), context.rotation(), context.bounds());
        this.jigsawCapability = context.jigsawCapability();
        this.setStructurePieceType(this.m_210000_());
    }

    public ExtendedJigsawStructurePiece(StructurePieceSerializationContext context, CompoundTag nbt) {
        super(context, nbt);
        this.setStructurePieceType(this.m_210000_());
        this.loadCapability(context, nbt);
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag nbt) {
        super.m_183620_(context, nbt);
        this.saveCapability(context, nbt);
    }

    private void loadCapability(StructurePieceSerializationContext context, CompoundTag nbt) {
        Optional result;
        if (nbt.m_128425_(this.getCapabilityKey(), 10) && (result = JigsawCapability.CODEC.decode((DynamicOps)RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)context.f_192763_()), (Object)nbt.m_128469_(CAP_KEY)).result()).isPresent()) {
            JigsawCapability.IJigsawCapability cap = (JigsawCapability.IJigsawCapability)((Pair)result.get()).getFirst();
            this.attachCapability(Optional.ofNullable(cap));
        }
    }

    private void saveCapability(StructurePieceSerializationContext context, CompoundTag nbt) {
        Optional result;
        if (this.jigsawCapability.isPresent() && (result = JigsawCapability.CODEC.encodeStart((DynamicOps)RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)context.f_192763_()), (Object)this.jigsawCapability.get()).result()).isPresent() && result.get() instanceof CompoundTag) {
            Tag tag = (Tag)result.get();
            nbt.m_128365_(this.getCapabilityKey(), tag);
        }
    }

    protected String getCapabilityKey() {
        return CAP_KEY;
    }

    public abstract void handleDataMarker(String var1, BlockPos var2, ServerLevelAccessor var3, RandomSource var4, BoundingBox var5);

    public abstract StructurePieceType m_210000_();

    private void setStructurePieceType(StructurePieceType structurePieceType) {
        this.f_73380_ = structurePieceType;
    }

    private final void attachCapability(@Nonnull Optional<JigsawCapability.IJigsawCapability> jigsawCapability) {
        Objects.requireNonNull(jigsawCapability);
        this.jigsawCapability = jigsawCapability;
    }

    public Optional<JigsawCapability.IJigsawCapability> getCapability() {
        return this.jigsawCapability;
    }

    public <C extends JigsawCapability.IJigsawCapability> Optional<C> getCapability(Class<C> capabilityClass) {
        return this.getCapability().map(c -> capabilityClass.isInstance(c) ? (JigsawCapability.IJigsawCapability)capabilityClass.cast(c) : null);
    }

    protected <C extends JigsawCapability.IJigsawCapability, T> Lazy<T> getCapabilityValue(Class<C> capabilityClass, Function<C, T> getter, Supplier<T> errorFallback) {
        return Lazy.of(() -> this.getCapability(capabilityClass).map(getter).orElseGet(() -> ExtendedJigsawStructurePiece.lambda$getCapabilityValue$1(capabilityClass, (Supplier)errorFallback)));
    }

    @Internal
    public void m_226509_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGen, RandomSource rand, BoundingBox bounds, BlockPos pos, boolean isLegacy) {
        StructurePoolElement structurePoolElement = this.f_72597_;
        if (structurePoolElement instanceof GelSinglePoolElement) {
            GelSinglePoolElement gelElement = (GelSinglePoolElement)structurePoolElement;
            gelElement.place(this.getStructureManager(), level, structureManager, chunkGen, this.f_72598_, pos, this.f_72599_, bounds, rand, isLegacy, this);
        } else {
            this.f_72597_.m_213695_(this.getStructureManager(), level, structureManager, chunkGen, this.f_72598_, pos, this.f_72599_, bounds, rand, isLegacy);
        }
    }

    @Override
    @Nullable
    public BlockState modifyState(ServerLevelAccessor level, RandomSource rand, BlockPos pos, BlockState originalState) {
        return originalState;
    }

    public <T extends Entity> T createEntity(EntityType<T> entityType, ServerLevelAccessor level, BlockPos pos, Rotation rotation) {
        Entity entity = entityType.m_20615_((Level)level.m_6018_());
        entity.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, rotation.m_55954_(Direction.SOUTH).m_122435_(), 0.0f);
        return (T)entity;
    }

    public ResourceLocation getLocation() {
        StructurePoolElement structurePoolElement = this.f_72597_;
        if (structurePoolElement instanceof SinglePoolElement) {
            SinglePoolElement singleElement = (SinglePoolElement)structurePoolElement;
            return JigsawAccessHelper.getSingleJigsawPieceLocation(singleElement);
        }
        return new ResourceLocation("empty");
    }

    public StructureTemplateManager getStructureManager() {
        return this.f_226493_;
    }

    public Vec3i getSize() {
        Optional optional = this.getStructureManager().m_230407_(this.getLocation());
        return optional.isPresent() ? ((StructureTemplate)optional.get()).m_163801_() : Vec3i.f_123288_;
    }

    public void setAir(LevelAccessor level, BlockPos pos) {
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
    }

    public void extendDown(LevelAccessor level, BlockState state, BoundingBox bounds, Rotation rotation, RandomSource rand) {
        this.extendDown(level, (RandomSource random) -> state, bounds, rotation, rand);
    }

    public void extendDown(LevelAccessor level, Function<RandomSource, BlockState> randStateGetter, BoundingBox bounds, Rotation rotation, RandomSource rand) {
        int offsetX = rotation == Rotation.CLOCKWISE_180 || this.f_72599_ == Rotation.CLOCKWISE_90 ? -(this.getSize().m_123341_() - 1) : 0;
        int offsetZ = rotation == Rotation.CLOCKWISE_180 || this.f_72599_ == Rotation.COUNTERCLOCKWISE_90 ? -(this.getSize().m_123343_() - 1) : 0;
        for (int x = 0; x < 13; ++x) {
            for (int z = 0; z < 13; ++z) {
                if (level.m_8055_(this.f_72598_.m_7918_(x + offsetX, 0, z + offsetZ)).m_60767_() == Material.f_76296_) continue;
                int offsetY = -1;
                while ((level.m_46859_(this.f_72598_.m_7918_(x + offsetX, offsetY, z + offsetZ)) || level.m_8055_(this.f_72598_.m_7918_(x + offsetX, offsetY, z + offsetZ)).m_60767_().m_76332_()) && this.f_72598_.m_123342_() + offsetY > 0) {
                    level.m_7731_(this.f_72598_.m_7918_(x + offsetX, offsetY, z + offsetZ), randStateGetter.apply(rand), 2);
                    --offsetY;
                }
            }
        }
    }

    private static /* synthetic */ Object lambda$getCapabilityValue$1(Class capabilityClass, Supplier errorFallback) {
        StructureGelMod.LOGGER.warn("The capability for a jigsaw piece did not match the expected class: " + capabilityClass, new Object[0]);
        return errorFallback.get();
    }
}

