/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.renderers;

import com.legacy.structure_gel.core.client.renderers.IRenderBase;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.CapturedBlocks;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public abstract class BuildingToolRenderer
implements IRenderBase {
    private static final Map<BuildingToolMode, Supplier<BuildingToolRenderer>> RENDERERS = new HashMap<BuildingToolMode, Supplier<BuildingToolRenderer>>();
    @Nullable
    private static BuildingToolMode mode = null;
    @Nullable
    private static BuildingToolRenderer instance = null;
    private static boolean shouldClear = false;
    @Nullable
    protected BlockPos pos;
    @Nullable
    protected BlockPos hitPos;
    @Nullable
    protected Direction hitFace;
    @Nullable
    protected Vec3 hitVec;
    protected boolean hitBlock = false;
    @Nullable
    private VertexBuffer lineBuffer;
    protected boolean needsCompiled = true;
    protected Vec3i renderPos = Vec3i.f_123288_;

    protected BuildingToolRenderer() {
    }

    private static void updateInstance(ItemStack stack) {
        BuildingToolRenderer.updateInstance(stack.m_150930_((Item)SGRegistry.Items.BUILDING_TOOL.get()) ? BuildingToolItem.getMode(stack) : null);
    }

    private static void updateInstance(@Nullable BuildingToolMode newMode) {
        if (mode != newMode) {
            mode = newMode;
            if (instance != null) {
                instance.close();
            }
            instance = mode == null ? null : RENDERERS.getOrDefault(mode, () -> null).get();
        }
    }

    public static void render(Minecraft mc, PoseStack poseStack, Matrix4f projectionMatrix, double camX, double camY, double camZ) {
        LocalPlayer player;
        if (shouldClear) {
            shouldClear = false;
            if (instance != null) {
                instance.close();
            }
            instance = null;
        }
        if ((player = mc.f_91074_) != null && player.m_7500_()) {
            ItemStack mainItem = player.m_21205_();
            ItemStack offItem = player.m_21206_();
            BuildingToolItem buildingTool = SGRegistry.Items.BUILDING_TOOL.get();
            boolean isMain = mainItem.m_150930_((Item)buildingTool);
            boolean isOff = offItem.m_150930_((Item)buildingTool);
            ItemStack toolStack = isMain && !isOff ? mainItem : (isOff && !isMain ? offItem : ItemStack.f_41583_);
            BuildingToolRenderer.updateInstance(toolStack);
            if (instance != null && !toolStack.m_41619_()) {
                instance.updateData(mc, toolStack);
                Vec3i camPos = new Vec3i(camX, camY, camZ);
                if (instance.shouldRender(camPos)) {
                    poseStack.m_85836_();
                    poseStack.m_85837_(-camX, -camY, -camZ);
                    if (BuildingToolRenderer.instance.needsCompiled) {
                        BuildingToolRenderer.instance.needsCompiled = false;
                        instance.compile(mc, player, toolStack, poseStack, projectionMatrix, camX, camY, camZ);
                    }
                    instance.render(mc, player, toolStack, poseStack, projectionMatrix, camX, camY, camZ);
                    poseStack.m_85849_();
                }
            }
        }
    }

    protected void compile(Minecraft mc, LocalPlayer player, ItemStack stack, PoseStack poseStack, Matrix4f projectionMatrix, double camX, double camY, double camZ) {
        if (this.lineBuffer != null) {
            this.lineBuffer.close();
        }
        this.lineBuffer = new VertexBuffer();
        BufferBuilder buffBuilder = Tesselator.m_85913_().m_85915_();
        buffBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        this.compileInfo(mc, stack, poseStack, buffBuilder, camX, camY, camZ);
        this.lineBuffer.m_85921_();
        this.lineBuffer.m_231221_(buffBuilder.m_231175_());
        VertexBuffer.m_85931_();
    }

    protected void render(Minecraft mc, LocalPlayer player, ItemStack stack, PoseStack poseStack, Matrix4f projectionMatrix, double camX, double camY, double camZ) {
        if (this.lineBuffer != null) {
            poseStack.m_85836_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.m_69482_();
            poseStack.m_85837_(camX, camY, camZ);
            poseStack.m_85837_((double)this.renderPos.m_123341_() - camX, (double)this.renderPos.m_123342_() - camY, (double)this.renderPos.m_123343_() - camZ);
            this.lineBuffer.m_85921_();
            this.lineBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, RenderSystem.m_157196_());
            VertexBuffer.m_85931_();
            RenderSystem.m_69461_();
            RenderSystem.m_69465_();
            poseStack.m_85849_();
        }
    }

    protected static Collection<BlockPos> mapPosesTo(Collection<BlockPos> poses, Vec3i renderPos) {
        ArrayList<BlockPos> newPoses = new ArrayList<BlockPos>(poses.size());
        int x = renderPos.m_123341_();
        int y = renderPos.m_123342_();
        int z = renderPos.m_123343_();
        for (BlockPos pos : poses) {
            newPoses.add(pos.m_7918_(-x, -y, -z));
        }
        return newPoses;
    }

    protected boolean shouldRender(Vec3i camPos) {
        return true;
    }

    protected void updateData(Minecraft mc, ItemStack stack) {
        if (this.usesHitPos().store) {
            boolean hBlock;
            Direction hDir;
            BlockPos hPos;
            HitResult hitResult = mc.f_91077_;
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult bHitResult = (BlockHitResult)hitResult;
                hPos = bHitResult.m_82425_();
                hDir = bHitResult.m_82434_();
                hBlock = bHitResult.m_6662_() == HitResult.Type.BLOCK;
            } else {
                hPos = null;
                hDir = null;
                hBlock = false;
            }
            if (this.hitPos != null && !this.hitPos.equals((Object)hPos) || hPos != null && !hPos.equals((Object)this.hitPos) || this.hitPos == null != (hPos == null) || hDir != this.hitFace || hBlock != this.hitBlock) {
                this.hitPos = hPos;
                this.hitFace = hDir;
                this.hitBlock = hBlock;
                if (this.usesHitPos().compile) {
                    this.needsCompiled = true;
                }
            }
        }
        if (this.usesHitVec().store) {
            Vec3 hVec;
            HitResult hitResult = mc.f_91077_;
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult bHitResult = (BlockHitResult)hitResult;
                hVec = bHitResult.m_82450_();
            } else {
                hVec = null;
            }
            if (this.hitVec != null && !this.hitVec.equals((Object)hVec) || hVec != null && !hVec.equals((Object)this.hitVec)) {
                this.hitVec = hVec;
                if (this.usesHitVec().compile) {
                    this.needsCompiled = true;
                }
            }
        }
    }

    protected UseDataMode usesHitPos() {
        return UseDataMode.DONT;
    }

    protected UseDataMode usesHitVec() {
        return UseDataMode.DONT;
    }

    protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ) {
    }

    protected void close() {
        if (this.lineBuffer != null) {
            this.lineBuffer.close();
        }
        this.lineBuffer = null;
    }

    public static void needsUpdated() {
        if (instance != null) {
            BuildingToolRenderer.instance.needsCompiled = true;
        }
    }

    public static void clear() {
        shouldClear = true;
    }

    static {
        RENDERERS.put(BuildingToolMode.CLEAR, () -> new ForCorners(){

            @Override
            protected float[] getOutlineRGB() {
                return new float[]{0.85f, 0.0f, 0.0f};
            }
        });
        RENDERERS.put(BuildingToolMode.FILL, () -> new ForCorners(){

            @Override
            protected float[] getOutlineRGB() {
                return new float[]{0.75f, 0.0f, 0.75f};
            }
        });
        RENDERERS.put(BuildingToolMode.CLONE, () -> new ForCorners(){
            @Nullable
            private CapturedBlocks capturedBlocksCache = null;
            @Nullable
            private VertexBuffer destBuffer = null;

            @Override
            protected float[] getOutlineRGB() {
                return new float[]{0.0f, 0.85f, 0.0f};
            }

            @Override
            protected UseDataMode usesHitPos() {
                return UseDataMode.STORE;
            }

            @Override
            protected UseDataMode usesHitVec() {
                return UseDataMode.STORE;
            }

            @Override
            protected void updateData(Minecraft mc, ItemStack stack) {
                super.updateData(mc, stack);
                if (this.needsCompiled) {
                    if (this.pos != null && this.secondPos != null && mc.f_91073_.m_46749_(this.pos) && mc.f_91073_.m_46749_(this.secondPos)) {
                        RandomSource rand = mc.f_91073_.f_46441_;
                        ToolModeProperty.SGMirror mirror = BuildingToolItem.getProperty(stack, ToolModeProperty.MIRROR);
                        ToolModeProperty.SGRotation rotation = BuildingToolItem.getProperty(stack, ToolModeProperty.ROTATION);
                        this.capturedBlocksCache = new CapturedBlocks((Level)mc.f_91073_, this.pos, this.secondPos, (mirror == ToolModeProperty.SGMirror.RANDOM ? ToolModeProperty.SGMirror.NONE : mirror).toVanilla(rand), (rotation == ToolModeProperty.SGRotation.RANDOM ? ToolModeProperty.SGRotation.R_0 : rotation).toVanilla(rand));
                        this.capturedBlocksCache.compressForRender((Level)mc.f_91073_, this.pos);
                    } else {
                        this.capturedBlocksCache = null;
                    }
                }
            }

            @Override
            protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ) {
                super.compileInfo(mc, stack, poseStack, buffBuilder, camX, camY, camZ);
            }

            protected void compileDest(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ) {
                if (this.hitPos != null && this.pos != null && this.secondPos != null && this.capturedBlocksCache != null) {
                    BoundingBox destBB = BuildingToolMode.getCloneDestBounds(this.capturedBlocksCache, BlockPos.f_121853_, Blocks.f_50016_.m_49966_(), Vec3.f_82478_, false);
                    BlockPos worldPos = new BlockPos(destBB.m_162395_(), destBB.m_162396_(), destBB.m_162398_());
                    for (CapturedBlocks.BlockInfo info : this.capturedBlocksCache.getBlockInfos()) {
                        BlockPos p = worldPos.m_121955_((Vec3i)info.pos());
                        info.state().m_60808_((BlockGetter)mc.f_91073_, p).m_83286_((x, y, z, mx, my, mz) -> {
                            double o = 0.001;
                            IRenderBase.makeBox(buffBuilder, new Vec3((double)p.m_123341_() - o + x, (double)p.m_123342_() - o + y, (double)p.m_123343_() - o + z), new Vec3((double)p.m_123341_() + o + mx, (double)p.m_123342_() + o + my, (double)p.m_123343_() + o + mz), 0.6f, 0.0f, 0.9f, 0.7f);
                        });
                    }
                    IRenderBase.makeLineBox(buffBuilder, destBB, -0.01, 0.75f, 0.0f, 0.75f, 0.3f);
                }
            }

            @Override
            protected void compile(Minecraft mc, LocalPlayer player, ItemStack stack, PoseStack poseStack, Matrix4f projectionMatrix, double camX, double camY, double camZ) {
                super.compile(mc, player, stack, poseStack, projectionMatrix, camX, camY, camZ);
                if (this.destBuffer != null) {
                    this.destBuffer.close();
                }
                this.destBuffer = new VertexBuffer();
                BufferBuilder buffBuilder = Tesselator.m_85913_().m_85915_();
                buffBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
                this.compileDest(mc, stack, poseStack, buffBuilder, camX, camY, camZ);
                this.destBuffer.m_85921_();
                this.destBuffer.m_231221_(buffBuilder.m_231175_());
                VertexBuffer.m_85931_();
            }

            @Override
            protected void render(Minecraft mc, LocalPlayer player, ItemStack stack, PoseStack poseStack, Matrix4f projectionMatrix, double camX, double camY, double camZ) {
                super.render(mc, player, stack, poseStack, projectionMatrix, camX, camY, camZ);
                if (this.destBuffer != null && this.hitPos != null && this.capturedBlocksCache != null) {
                    poseStack.m_85836_();
                    RenderSystem.m_157427_(GameRenderer::m_172811_);
                    RenderSystem.m_69478_();
                    RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    RenderSystem.m_69482_();
                    poseStack.m_85837_(camX, camY, camZ);
                    BoundingBox destBB = BuildingToolMode.getCloneDestBounds(this.capturedBlocksCache, this.hitPos, player.f_19853_.m_8055_(this.hitPos), player.m_20182_(), player.m_6144_());
                    poseStack.m_85837_((double)destBB.m_162395_() - camX, (double)destBB.m_162396_() - camY, (double)destBB.m_162398_() - camZ);
                    this.destBuffer.m_85921_();
                    this.destBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, RenderSystem.m_157196_());
                    VertexBuffer.m_85931_();
                    RenderSystem.m_69461_();
                    RenderSystem.m_69465_();
                    poseStack.m_85849_();
                }
            }

            @Override
            protected void close() {
                super.close();
                if (this.destBuffer != null) {
                    this.destBuffer.close();
                }
                this.destBuffer = null;
            }
        });
        RENDERERS.put(BuildingToolMode.FLOOD, () -> new BuildingToolRenderer(){

            @Override
            protected UseDataMode usesHitPos() {
                return UseDataMode.COMPILE;
            }

            @Override
            protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ) {
                super.compileInfo(mc, stack, poseStack, buffBuilder, camX, camY, camZ);
                if (this.hitPos != null && this.hitFace != null && this.hitBlock) {
                    this.renderPos = this.hitPos;
                    IRenderBase.highlightBlockPos(buffBuilder, 4.mapPosesTo(BuildingToolMode.getFloodPositions((Level)mc.f_91073_, this.hitPos, this.hitFace), this.renderPos), 0.75f, 0.0f, 0.75f, 0.3f);
                }
            }
        });
        RENDERERS.put(BuildingToolMode.EXTEND, () -> new BuildingToolRenderer(){
            private Set<BlockPos> extendPoses = new HashSet<BlockPos>();

            @Override
            protected UseDataMode usesHitPos() {
                return UseDataMode.COMPILE;
            }

            @Override
            protected void updateData(Minecraft mc, ItemStack stack) {
                super.updateData(mc, stack);
                if (this.hitPos != null && this.hitFace != null && this.extendPoses.size() != BuildingToolMode.getExtendPositions((Level)mc.f_91073_, this.hitPos, this.hitFace).size()) {
                    this.needsCompiled = true;
                }
            }

            @Override
            protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ) {
                super.compileInfo(mc, stack, poseStack, buffBuilder, camX, camY, camZ);
                if (this.hitPos != null && this.hitFace != null && this.hitBlock) {
                    this.renderPos = this.hitPos;
                    this.extendPoses = BuildingToolMode.getExtendPositions((Level)mc.f_91073_, this.hitPos, this.hitFace);
                    IRenderBase.highlightBlockPos(buffBuilder, 5.mapPosesTo(this.extendPoses, this.renderPos), 0.75f, 0.0f, 0.75f, 0.3f);
                }
            }
        });
        RENDERERS.put(BuildingToolMode.MOVE, () -> new ForCorners(){

            @Override
            protected float[] getOutlineRGB() {
                return new float[]{0.75f, 0.0f, 0.75f};
            }
        });
        RENDERERS.put(BuildingToolMode.LINE, () -> new ForCorners(){

            @Override
            protected float[] getOutlineRGB() {
                return new float[]{0.75f, 0.0f, 0.75f};
            }

            @Override
            protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ) {
                if (this.pos != null && this.secondPos != null) {
                    float[] rgb = this.getOutlineRGB();
                    float a = 0.3f;
                    BoundingBox fullBounds = BoundingBox.m_162375_((Vec3i)this.pos, (Vec3i)this.secondPos);
                    int minX = fullBounds.m_162395_();
                    int minY = fullBounds.m_162396_();
                    int minZ = fullBounds.m_162398_();
                    this.renderPos = new Vec3i(minX, minY, minZ);
                    BoundingBox pos1 = BoundingBox.m_162375_((Vec3i)this.pos, (Vec3i)this.pos);
                    BoundingBox pos2 = BoundingBox.m_162375_((Vec3i)this.secondPos, (Vec3i)this.secondPos);
                    IRenderBase.makeLineBox(buffBuilder, BoundingBox.m_162375_((Vec3i)Vec3i.f_123288_, (Vec3i)pos1.m_71053_()).m_71045_(pos1.m_162395_() - minX, pos1.m_162396_() - minY, pos1.m_162398_() - minZ), rgb[0], rgb[1], rgb[2], a);
                    IRenderBase.makeLineBox(buffBuilder, BoundingBox.m_162375_((Vec3i)Vec3i.f_123288_, (Vec3i)pos2.m_71053_()).m_71045_(pos2.m_162395_() - minX, pos2.m_162396_() - minY, pos2.m_162398_() - minZ), rgb[0], rgb[1], rgb[2], a);
                    IRenderBase.highlightBlockPos(buffBuilder, 7.mapPosesTo(BuildingToolMode.getLinePositions(this.pos, this.secondPos), this.renderPos), rgb[0], rgb[1], rgb[2], a);
                }
            }
        });
        RENDERERS.put(BuildingToolMode.SHAPE, () -> new BuildingToolRenderer(){

            @Override
            protected UseDataMode usesHitPos() {
                return UseDataMode.COMPILE;
            }

            @Override
            protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ) {
                super.compileInfo(mc, stack, poseStack, buffBuilder, camX, camY, camZ);
                if (this.hitPos != null) {
                    int r = BuildingToolItem.getProperty(stack, ToolModeProperty.RADIUS);
                    BoundingBox destBB = BoundingBox.m_162375_((Vec3i)Vec3i.f_123288_.m_7918_(-r, -r, -r), (Vec3i)Vec3i.f_123288_.m_7918_(r, r, r));
                    this.renderPos = this.hitPos;
                    IRenderBase.makeLineBox(buffBuilder, destBB, 0.75f, 0.0f, 0.75f, 0.3f);
                }
            }
        });
    }

    private static enum UseDataMode {
        DONT(false, false),
        STORE(true, false),
        COMPILE(true, true);

        private final boolean store;
        private final boolean compile;

        private UseDataMode(boolean store, boolean compile) {
            this.store = store;
            this.compile = compile;
        }
    }

    private static abstract class ForCorners
    extends BuildingToolRenderer {
        @Nullable
        protected BlockPos secondPos;

        private ForCorners() {
        }

        @Override
        protected boolean shouldRender(Vec3i camPos) {
            int dist = 300;
            return this.pos != null && this.pos.m_123314_(camPos, (double)dist) || this.secondPos != null && this.secondPos.m_123314_(camPos, (double)dist);
        }

        @Override
        protected void updateData(Minecraft mc, ItemStack stack) {
            super.updateData(mc, stack);
            Optional<BlockPos> pos0 = BuildingToolItem.getPos(stack, 0);
            Optional<BlockPos> pos1 = BuildingToolItem.getPos(stack, 1);
            boolean pos0Flag = this.arePosesDifferent(pos0, this.pos);
            boolean pos1Flag = this.arePosesDifferent(pos1, this.secondPos);
            if (pos0Flag) {
                this.pos = pos0.orElse(null);
            }
            if (pos1Flag) {
                this.secondPos = pos1.orElse(null);
            }
            if (pos0Flag || pos1Flag) {
                this.needsCompiled = true;
            }
        }

        private boolean arePosesDifferent(Optional<BlockPos> opPos, BlockPos compareTo) {
            return opPos.isPresent() ? !opPos.get().equals((Object)compareTo) : compareTo != null;
        }

        protected abstract float[] getOutlineRGB();

        @Override
        protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ) {
            if (this.pos != null && this.secondPos != null) {
                float[] rgb = this.getOutlineRGB();
                BoundingBox bb = BoundingBox.m_162375_((Vec3i)this.pos, (Vec3i)this.secondPos);
                this.renderPos = new Vec3i(bb.m_162395_(), bb.m_162396_(), bb.m_162398_());
                IRenderBase.makeLineBox(buffBuilder, BoundingBox.m_162375_((Vec3i)Vec3i.f_123288_, (Vec3i)bb.m_71053_()), rgb[0], rgb[1], rgb[2], 0.3f);
            }
        }
    }
}

