/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.screen;

import com.legacy.structure_gel.api.data_handler.DataHandlerType;
import com.legacy.structure_gel.core.block_entity.DataHandlerBlockEntity;
import com.legacy.structure_gel.core.client.widget.DataParamsList;
import com.legacy.structure_gel.core.client.widget.SuggestionEditBox;
import com.legacy.structure_gel.core.network.PacketHandler;
import com.legacy.structure_gel.core.network.UpdateDataHandlerPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class DataHandlerScreen
extends Screen {
    private static final int TEXT_COLOR = 0xA0A0A0;
    public static final MutableComponent TYPE_LABEL = Component.m_237115_((String)"gui.structure_gel.data_handler.type_label");
    private final Map<ResourceLocation, List<DataParamsList.Entry>> dataParamsCache = new HashMap<ResourceLocation, List<DataParamsList.Entry>>();
    private final DataHandlerBlockEntity dataHandler;
    private SuggestionEditBox typeEdit;
    private DataParamsList dataParamsList;
    public Button doneButton;
    public Button generateButton;

    public DataHandlerScreen(DataHandlerBlockEntity dataHandler) {
        super((Component)Component.m_237119_());
        this.dataHandler = dataHandler;
    }

    public void m_86600_() {
        this.typeEdit.m_94120_();
        this.dataParamsList.tick();
    }

    private void onDone(byte flag) {
        this.sendToServer(flag);
        this.f_96541_.m_91152_((Screen)null);
    }

    private void onCancel() {
        this.f_96541_.m_91152_((Screen)null);
    }

    private void sendToServer(byte flag) {
        PacketHandler.sendToServer(new UpdateDataHandlerPacket(flag, this.dataHandler.m_58899_(), new ResourceLocation(this.typeEdit.m_94155_()), this.dataParamsList.values()));
    }

    public void m_7379_() {
        this.onCancel();
    }

    protected void m_7856_() {
        this.typeEdit = new SuggestionEditBox(this.f_96547_, this.f_96543_ / 2 - 152, 25, 215, 20, (Component)TYPE_LABEL, 10, DataHandlerType.REGISTRY.getKeys());
        this.typeEdit.m_94199_(128);
        ResourceLocation type = this.dataHandler.getDataHandlerType();
        if (type != null) {
            this.typeEdit.m_94144_(type.toString());
        }
        this.typeEdit.m_94151_(s -> this.updateWidgets());
        this.m_7787_((GuiEventListener)this.typeEdit);
        this.dataParamsList = new DataParamsList(this, this.f_96541_, null);
        this.m_7787_((GuiEventListener)this.dataParamsList);
        this.doneButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.onDone((byte)0)).m_252794_(this.f_96543_ / 2 - 3 - 150, this.f_96544_ - 30).m_253046_(150, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.onCancel()).m_252794_(this.f_96543_ / 2 + 4, this.f_96544_ - 30).m_253046_(150, 20).m_253136_());
        this.generateButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"jigsaw_block.generate"), button -> this.onDone((byte)1)).m_252794_(this.typeEdit.m_252754_() + this.typeEdit.m_5711_() + 7, this.typeEdit.m_252907_()).m_253046_(305 - this.typeEdit.m_5711_() - 6, this.typeEdit.m_93694_()).m_253136_());
        this.updateWidgets();
        Map<String, String> dataMap = this.dataHandler.getDataEntries();
        for (DataParamsList.Entry entry : this.dataParamsList.m_6702_()) {
            String val = dataMap.get(entry.parser.key);
            if (val == null) continue;
            entry.setValue(val);
        }
    }

    public boolean allowDoneButton() {
        return ResourceLocation.m_135830_((String)this.typeEdit.m_94155_()) && this.dataParamsList.isValid();
    }

    public boolean allowGenerateButton() {
        return this.allowDoneButton() && DataHandlerType.REGISTRY.get(new ResourceLocation(this.typeEdit.m_94155_())) != null && this.dataParamsList.isValid();
    }

    protected void updateWidgets() {
        String typeStr = this.typeEdit.m_94155_();
        boolean typeFlag = ResourceLocation.m_135830_((String)this.typeEdit.m_94155_());
        this.doneButton.f_93623_ = this.allowDoneButton();
        this.generateButton.f_93623_ = this.allowGenerateButton();
        if (!typeFlag) {
            this.dataParamsList.setEntries(null);
            return;
        }
        ResourceLocation typeName = new ResourceLocation(typeStr);
        DataHandlerType<?> type = DataHandlerType.REGISTRY.get(typeName);
        if (type != null) {
            List<DataParamsList.Entry> cachedParams = this.dataParamsCache.get(typeName);
            if (cachedParams == null) {
                this.dataParamsList.createEntries(type.getDataParser());
                this.dataParamsCache.put(typeName, this.dataParamsList.childrenClone());
            } else {
                this.dataParamsList.setEntries(cachedParams);
            }
        } else {
            this.dataParamsList.setEntries(null);
        }
    }

    public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        this.dataParamsList.m_86412_(poseStack, mouseX, mouseY, partialTicks);
        DataHandlerScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)TYPE_LABEL, (int)(this.f_96543_ / 2 - 153), (int)10, (int)0xA0A0A0);
        this.typeEdit.m_86412_(poseStack, mouseX, mouseY, partialTicks);
        super.m_86412_(poseStack, mouseX, mouseY, partialTicks);
    }

    public void m_6574_(Minecraft mc, int mouseX, int mouseY) {
        String type = this.typeEdit.m_94155_();
        this.m_6575_(mc, mouseX, mouseY);
        this.typeEdit.m_94144_(type);
    }

    public boolean m_6375_(double mouseX, double mouseY, int clickType) {
        for (DataParamsList.Entry entry : this.dataParamsList.m_6702_()) {
            if (!entry.widget.m_93696_() || !entry.widget.m_6375_(mouseX, mouseY, clickType)) continue;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, clickType);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_7933_(int keyCode, int keyB, int modifiers) {
        if (this.typeEdit.m_93696_() && this.typeEdit.m_7933_(keyCode, keyB, modifiers)) {
            return true;
        }
        for (DataParamsList.Entry entry : this.dataParamsList.m_6702_()) {
            if (!entry.widget.m_93696_() || !entry.widget.m_7933_(keyCode, keyB, modifiers)) continue;
            return true;
        }
        if (super.m_7933_(keyCode, keyB, modifiers)) {
            return true;
        }
        if (this.doneButton.f_93623_ && (keyCode == 257 || keyCode == 335)) {
            this.onDone((byte)0);
            return true;
        }
        return false;
    }
}

