/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.widget;

import com.legacy.structure_gel.core.client.widget.OnTooltip;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TexturedEditBox
extends EditBox {
    private final int u;
    private final int v;
    private final int texWidth;
    private final int texHeight;
    private final ResourceLocation texture;
    private int textColor;
    private int hoveredTextColor;
    @Nullable
    private OnTooltip<TexturedEditBox> onTooltip;

    public TexturedEditBox(Font font, int x, int y, int width, int height, int u, int v, int texWidth, int texHeight, ResourceLocation texture, Component name) {
        super(font, x, y, width, height, name);
        this.u = u;
        this.v = v;
        this.texWidth = texWidth;
        this.texHeight = texHeight;
        this.texture = texture;
        this.textColor = 0xE0E0E0;
        this.hoveredTextColor = 0xE0E0E0;
        this.m_94182_(false);
    }

    public TexturedEditBox(Font font, int x, int y, int width, int height, int u, int v, ResourceLocation texture, Component name) {
        this(font, x, y, width, height, u, v, 256, 256, texture, name);
    }

    public void onTooltip(OnTooltip<TexturedEditBox> onTooltip) {
        this.onTooltip = onTooltip;
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.m_94213_()) {
            this.renderTexture(poseStack, mouseX, mouseY, partialTicks);
            if (this.m_198029_()) {
                this.renderToolTip(poseStack, mouseX, mouseY);
            }
        }
        int oldX = this.m_252754_();
        int oldY = this.m_252907_();
        this.m_252865_(this.m_252754_() + 4);
        this.m_252888_(this.m_252907_() + 8);
        this.m_94202_(this.m_198029_() ? this.hoveredTextColor : this.textColor);
        super.m_6303_(poseStack, mouseX, mouseY, partialTicks);
        this.m_252865_(oldX);
        this.m_252888_(oldY);
    }

    public void renderTexture(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        RenderSystem.m_69478_();
        int h = this.f_93619_;
        TexturedEditBox.m_93133_((PoseStack)poseStack, (int)this.m_252754_(), (int)this.m_252907_(), (float)this.u, (float)(this.m_198029_() ? (float)(this.v + h) : (float)this.v), (int)this.f_93618_, (int)h, (int)this.texWidth, (int)this.texHeight);
        RenderSystem.m_69461_();
    }

    public void renderToolTip(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.onTooltip != null) {
            this.onTooltip.onTooltip(this, poseStack, mouseX, mouseY);
        }
    }

    @Deprecated
    public void m_94202_(int color) {
        super.m_94202_(color);
    }

    public void setTextColor(int textColor, int hoveredTextColor) {
        super.m_94202_(textColor);
        this.textColor = textColor;
        this.hoveredTextColor = hoveredTextColor;
    }
}

