/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.legacy.structure_gel.api.structure.StructureAccessHelper;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class GetStructuresCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"getstructures").requires(source -> source.m_6761_(2));
        command.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"here").executes(c -> GetStructuresCommand.here((CommandContext<CommandSourceStack>)c, new BlockPos(((CommandSourceStack)c.getSource()).m_81371_())))).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(c -> GetStructuresCommand.here((CommandContext<CommandSourceStack>)c, BlockPosArgument.m_118242_((CommandContext)c, (String)"pos")))));
        command.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"biome").executes(c -> GetStructuresCommand.biome((CommandContext<CommandSourceStack>)c))).then(Commands.m_82129_((String)"biome", (ArgumentType)ResourceKeyArgument.m_212386_((ResourceKey)Registries.f_256952_)).executes(c -> GetStructuresCommand.biome((CommandContext<CommandSourceStack>)c, (ResourceKey<Biome>)((ResourceKey)c.getArgument("biome", ResourceKey.class))))));
        return command;
    }

    private static int here(CommandContext<CommandSourceStack> context, BlockPos pos) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.m_81372_();
        Registry structureReg = level.m_8891_().m_175515_(Registries.f_256944_);
        List<Pair> structures = level.m_215010_().m_220477_(new ChunkPos(pos), s -> true).stream().map(s -> {
            Structure struc = s.m_226861_();
            boolean inBounds = StructureAccessHelper.isInStructure(level, struc, pos);
            boolean inPiece = StructureAccessHelper.isInStructurePiece(level, struc, pos);
            String name = structureReg.m_7854_((Object)struc).map(r -> r.m_135782_().toString()).orElse("null");
            return Pair.of((Object)name, (Object)(inPiece ? "inside" : (inBounds ? "in bounds" : "not inside")));
        }).sorted((p1, p2) -> ((String)p1.getFirst()).compareTo((String)p2.getFirst())).toList();
        int size = structures.size();
        if (size > 0) {
            source.m_81354_((Component)Component.m_237113_((String)String.format("Structures at (%d, %d, %d):", pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).m_130940_(ChatFormatting.GREEN), true);
            structures.forEach(p -> source.m_81354_((Component)Component.m_237113_((String)String.format("- %s (%s)", p.getFirst(), p.getSecond())), true));
            return size;
        }
        source.m_81354_((Component)Component.m_237113_((String)"There are no structures."), true);
        return 0;
    }

    private static int biome(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Optional opName = source.m_81372_().m_204166_(new BlockPos(source.m_81371_())).m_203543_();
        if (opName.isPresent()) {
            return GetStructuresCommand.biome(context, (ResourceKey<Biome>)((ResourceKey)opName.get()));
        }
        source.m_81352_((Component)Component.m_237113_((String)"The biome you're in doesn't have a registry name."));
        return 0;
    }

    private static int biome(CommandContext<CommandSourceStack> context, ResourceKey<Biome> biomeKey) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.m_81372_();
        ResourceLocation name = biomeKey.m_135782_();
        Optional opBiome = level.m_8891_().m_175515_(Registries.f_256952_).m_203636_(biomeKey);
        if (opBiome.isPresent()) {
            Holder biome = (Holder)opBiome.get();
            source.m_81354_((Component)Component.m_237113_((String)("[" + name.toString() + "]")).m_130940_(ChatFormatting.GREEN), true);
            ArrayList structures = new ArrayList();
            ChunkGeneratorStructureState chunkGen = level.m_7726_().m_255415_();
            chunkGen.m_255252_().forEach(holder -> {
                StructureSet structureSet = (StructureSet)holder.m_203334_();
                for (StructureSet.StructureSelectionEntry entry : structureSet.f_210003_()) {
                    Structure structure = (Structure)entry.f_210026_().m_203334_();
                    if (!structure.m_226559_().m_203333_(biome)) continue;
                    structures.add(structure);
                }
            });
            if (structures.isEmpty()) {
                source.m_81354_((Component)Component.m_237113_((String)(name.toString() + " has no structures.")), true);
            } else {
                Registry registry = level.m_8891_().m_175515_(Registries.f_256944_);
                structures.stream().map(arg_0 -> ((Registry)registry).m_7981_(arg_0)).map(r -> r == null ? "null" : r.toString()).sorted().forEach(r -> source.m_81354_((Component)Component.m_237113_((String)(" - " + r)), true));
            }
            return structures.size();
        }
        source.m_81352_((Component)Component.m_237113_((String)"The biome you're in is unregistered."));
        return 0;
    }
}

