/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.legacy.structure_gel.core.commands.BuildingToolCommand;
import com.legacy.structure_gel.core.commands.GetBiomesCommand;
import com.legacy.structure_gel.core.commands.GetSpawnsCommand;
import com.legacy.structure_gel.core.commands.GetStructuresCommand;
import com.legacy.structure_gel.core.commands.SaveStructuresCommand;
import com.legacy.structure_gel.core.commands.StructureDistanceCommand;
import com.legacy.structure_gel.core.commands.ViewBoundsCommand;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class StructureGelCommand {
    private static final DynamicCommandExceptionType INVALID_KEY = new DynamicCommandExceptionType(obj -> Component.m_237113_((String)(obj + " is not valid in registry.")));

    public static <T> CompletableFuture<Suggestions> suggestFromRegistry(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder, ResourceKey<Registry<T>> registry) {
        ((Registry)((CommandSourceStack)context.getSource()).m_5894_().m_6632_(registry).get()).m_6566_().stream().map(ResourceLocation::toString).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = Commands.m_82127_((String)"structure_gel");
        command.then(SaveStructuresCommand.get());
        command.then(GetSpawnsCommand.get());
        command.then(GetStructuresCommand.get());
        command.then(GetBiomesCommand.get());
        command.then(ViewBoundsCommand.get());
        command.then(BuildingToolCommand.get());
        command.then(StructureDistanceCommand.get());
        dispatcher.register(command);
    }

    public static <T> Holder<T> getResourceKeyHolder(CommandContext<CommandSourceStack> context, ResourceKey<Registry<T>> registryKey, String arg) throws CommandSyntaxException {
        ResourceKey rawKey = (ResourceKey)context.getArgument(arg, ResourceKey.class);
        ResourceKey key = (ResourceKey)rawKey.m_195975_(registryKey).orElseThrow(() -> INVALID_KEY.create((Object)rawKey));
        return (Holder)((CommandSourceStack)context.getSource()).m_81377_().m_206579_().m_175515_(registryKey).m_203636_(key).orElseThrow(() -> INVALID_KEY.create((Object)key));
    }
}

