/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.events;

import com.legacy.structure_gel.api.data.providers.RegistrarDatapackEntriesProvider;
import com.legacy.structure_gel.api.data_handler.DataHandlerType;
import com.legacy.structure_gel.api.data_handler.LootTableAlias;
import com.legacy.structure_gel.api.dynamic_spawner.DynamicSpawnerType;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawCapability;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.capability.entity.GelCapability;
import com.legacy.structure_gel.core.capability.entity.GelEntityProvider;
import com.legacy.structure_gel.core.capability.entity.IGelEntity;
import com.legacy.structure_gel.core.commands.StructureGelCommand;
import com.legacy.structure_gel.core.data.generators.SGTagProv;
import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.legacy.structure_gel.core.network.PacketHandler;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegisterEvent;

@Internal
public class SGCommonEvents {

    @Mod.EventBusSubscriber(modid="structure_gel", bus=Mod.EventBusSubscriber.Bus.FORGE)
    protected static class ForgeBus {
        protected ForgeBus() {
        }

        @SubscribeEvent
        protected static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            event.addCapability(StructureGelMod.locate("gel_entity"), (ICapabilityProvider)new GelEntityProvider());
        }

        @SubscribeEvent
        protected static void onEntityJoinLevel(EntityJoinLevelEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                GelCapability.ifPresent(serverPlayer, gelPlayer -> gelPlayer.sendToClient(serverPlayer));
            }
        }

        @SubscribeEvent
        protected static void registerCommands(RegisterCommandsEvent event) {
            StructureGelCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }

        @SubscribeEvent
        protected static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            ActionHistory.clearHistory();
        }

        @SubscribeEvent
        protected static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
            if (event.getItemStack().m_150930_((Item)SGRegistry.Items.BUILDING_TOOL.get())) {
                event.setUseBlock(Event.Result.DENY);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="structure_gel", bus=Mod.EventBusSubscriber.Bus.MOD)
    protected static class ModBus {
        private static boolean registeredCustom = false;

        protected ModBus() {
        }

        @SubscribeEvent
        protected static void register(RegisterEvent event) {
            if (!registeredCustom && "forge".equals(event.getRegistryKey().m_135782_().m_135827_())) {
                registeredCustom = true;
                LootTableAlias.REGISTRY.init();
                DataHandlerType.REGISTRY.init();
                DynamicSpawnerType.REGISTRY.init();
                JigsawCapability.JigsawType.REGISTRY.init();
            }
        }

        @SubscribeEvent
        protected static void registerCapability(RegisterCapabilitiesEvent event) {
            event.register(IGelEntity.class);
        }

        @SubscribeEvent
        protected static void commonSetup(FMLCommonSetupEvent event) {
            PacketHandler.register();
        }

        @SubscribeEvent
        protected static void onTabLoad(CreativeModeTabEvent.BuildContents event) {
            if (event.getTab().equals(CreativeModeTabs.f_256837_) && event.hasPermissions()) {
                ArrayList<ItemStack> structureBlocks = new ArrayList<ItemStack>(4);
                for (StructureMode mode : StructureMode.values()) {
                    ItemStack stack = new ItemStack((ItemLike)Blocks.f_50677_);
                    CompoundTag tag = stack.m_41784_();
                    CompoundTag blockEntityTag = new CompoundTag();
                    blockEntityTag.m_128359_("mode", mode.name());
                    tag.m_128365_("BlockEntityTag", (Tag)blockEntityTag);
                    structureBlocks.add(stack);
                }
                ModBus.insertAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)event.getEntries(), structureBlocks, (ItemLike)Items.f_42352_);
                event.accept(SGRegistry.Blocks.RED_GEL);
                event.accept(SGRegistry.Blocks.BLUE_GEL);
                event.accept(SGRegistry.Blocks.GREEN_GEL);
                event.accept(SGRegistry.Blocks.CYAN_GEL);
                event.accept(SGRegistry.Blocks.ORANGE_GEL);
                event.accept(SGRegistry.Blocks.YELLOW_GEL);
                event.m_246326_((ItemLike)Items.f_42403_);
                event.accept(SGRegistry.Blocks.DATA_HANDLER);
                event.accept(SGRegistry.Blocks.DYNAMIC_SPAWNER);
                event.accept(SGRegistry.Items.BUILDING_TOOL);
            }
        }

        private static void insertAfter(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> entries, List<ItemStack> items, ItemLike target) {
            ItemStack currentStack = null;
            for (Map.Entry e : entries) {
                if (((ItemStack)e.getKey()).m_41720_() != target) continue;
                currentStack = (ItemStack)e.getKey();
                break;
            }
            for (ItemStack item : items) {
                ItemStack itemStack = currentStack;
                currentStack = item;
                entries.putAfter((Object)itemStack, (Object)currentStack, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }

        @SubscribeEvent
        protected static void attachCapabilities(GatherDataEvent event) {
            DataGenerator dataGen = event.getGenerator();
            ExistingFileHelper existingHelper = event.getExistingFileHelper();
            PackOutput packOutput = dataGen.getPackOutput();
            boolean server = event.includeServer();
            RegistrarDatapackEntriesProvider registrarProv = ModList.get().isLoaded("test") ? RegistrarHandler.createGenerator(packOutput, "structure_gel", "test") : RegistrarHandler.createGenerator(packOutput, "structure_gel", new String[0]);
            registrarProv = (RegistrarDatapackEntriesProvider)dataGen.addProvider(server, (DataProvider)registrarProv);
            dataGen.addProvider(server, (DataProvider)new SGTagProv.BlockTagProv(packOutput, registrarProv.getLookupProvider(), existingHelper));
        }
    }
}

