/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.Configuration;
import bl4ckscor3.mod.snowundertrees.SereneSeasonsHandler;
import bl4ckscor3.mod.snowundertrees.SnowUnderTrees;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="snowundertrees")
public class LevelTickHandler {
    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            if (event.phase == TickEvent.Phase.START && event.level.m_46471_() && ((Boolean)Configuration.CONFIG.enableWhenSnowing.get()).booleanValue()) {
                ServerLevel level = (ServerLevel)event.level;
                level.m_7726_().f_8325_.m_140416_().forEach(chunkHolder -> {
                    Optional optional = chunkHolder.m_140073_().getNow(ChunkHolder.f_139997_).left();
                    if (optional.isPresent() && SnowUnderTrees.RANDOM.m_188503_(16) == 0) {
                        BlockPos posBelow;
                        BlockState stateBelow;
                        BlockPos pos;
                        LevelChunk chunk = (LevelChunk)optional.get();
                        ChunkPos chunkPos = chunk.m_7697_();
                        int chunkX = chunkPos.m_45604_();
                        int chunkY = chunkPos.m_45605_();
                        BlockPos randomPos = level.m_46496_(chunkX, 0, chunkY, 15);
                        Biome biome = (Biome)level.m_204166_(randomPos).m_203334_();
                        boolean biomeDisabled = ((List)Configuration.CONFIG.filteredBiomes.get()).contains(level.m_8891_().m_175515_(Registries.f_256952_).m_7981_((Object)biome).toString());
                        if (!biomeDisabled && level.m_8055_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING, randomPos).m_7495_()).m_60734_() instanceof LeavesBlock && SnowUnderTrees.placeSnow((WorldGenLevel)level, pos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, randomPos)) && (stateBelow = level.m_8055_(posBelow = pos.m_7495_())).m_61138_((Property)SnowyDirtBlock.f_56637_)) {
                            level.m_7731_(posBelow, (BlockState)stateBelow.m_61124_((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(true)), 2);
                        }
                    }
                });
            } else if (event.phase == TickEvent.Phase.END && SnowUnderTrees.isSereneSeasonsLoaded()) {
                SereneSeasonsHandler.tryMeltSnowUnderTrees(event);
            }
        }
    }
}

