/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.Configuration;
import bl4ckscor3.mod.snowundertrees.SereneSeasonsHandler;
import bl4ckscor3.mod.snowundertrees.SnowUnderTreesBiomeModifier;
import bl4ckscor3.mod.snowundertrees.SnowUnderTreesFeature;
import bl4ckscor3.mod.snowundertrees.manager.SnowManager;
import bl4ckscor3.mod.snowundertrees.manager.SnowRealMagicManager;
import bl4ckscor3.mod.snowundertrees.manager.VanillaManager;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="snowundertrees")
@Mod.EventBusSubscriber(modid="snowundertrees", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SnowUnderTrees {
    public static final String MODID = "snowundertrees";
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"snowundertrees");
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"snowundertrees");
    public static final RegistryObject<SnowUnderTreesFeature> SNOW_UNDER_TREES_FEATURE = FEATURES.register("snow_under_trees", () -> new SnowUnderTreesFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Codec<SnowUnderTreesBiomeModifier>> SNOW_UNDER_TREES_BIOME_MODIFIER_CODEC = BIOME_MODIFIER_SERIALIZERS.register("snow_under_trees", () -> RecordCodecBuilder.create(builder -> builder.group((App)PlacedFeature.f_191773_.fieldOf("feature").forGetter(SnowUnderTreesBiomeModifier::snowUnderTreesFeature)).apply((Applicative)builder, SnowUnderTreesBiomeModifier::new)));
    public static final RandomSource RANDOM = RandomSource.m_216327_();
    public static List<ResourceLocation> biomesToAddTo = new ArrayList<ResourceLocation>();
    public static SnowManager snowManager;
    private static boolean isSereneSeasonsLoaded;
    private static BiFunction<WorldGenLevel, BlockPos, Boolean> temperatureCheck;

    public SnowUnderTrees() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configuration.CONFIG_SPEC);
        FEATURES.register(FMLJavaModLoadingContext.get().getModEventBus());
        BIOME_MODIFIER_SERIALIZERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        isSereneSeasonsLoaded = ModList.get().isLoaded("sereneseasons");
        snowManager = ModList.get().isLoaded("snowrealmagic") ? new SnowRealMagicManager() : new VanillaManager();
        temperatureCheck = isSereneSeasonsLoaded ? (level, pos) -> !SereneSeasonsHandler.warmEnoughToRain(level, (Holder<Biome>)level.m_204166_(pos), pos) : (level, pos) -> !((Biome)level.m_204166_(pos).m_203334_()).m_198906_(pos);
    }

    public static void addSnowUnderTrees(Biome biome) {
        ResourceLocation biomeName = ForgeRegistries.BIOMES.getKey((Object)biome);
        if (!biomesToAddTo.contains(biomeName)) {
            biomesToAddTo.add(biomeName);
        }
    }

    public static boolean placeSnow(WorldGenLevel level, BlockPos pos) {
        return snowManager.placeSnow(level, pos);
    }

    public static boolean canSnow(WorldGenLevel level, BlockPos pos) {
        if (temperatureCheck.apply(level, pos).booleanValue() && SnowUnderTrees.isInBuildRangeAndDarkEnough(level, pos)) {
            BlockPos posBelow = pos.m_7495_();
            BlockState stateBelow = level.m_8055_(posBelow);
            return stateBelow.m_60783_((BlockGetter)level, posBelow, Direction.UP);
        }
        return false;
    }

    public static boolean isSnow(WorldGenLevel level, BlockPos pos) {
        return snowManager.isSnow(level, pos);
    }

    public static BlockState getStateAfterMelting(BlockState stateNow, WorldGenLevel level, BlockPos pos) {
        return snowManager.getStateAfterMelting(stateNow, level, pos);
    }

    private static final boolean isInBuildRangeAndDarkEnough(WorldGenLevel level, BlockPos pos) {
        return pos.m_123342_() >= level.m_141937_() && pos.m_123342_() < level.m_151558_() && level.m_45517_(LightLayer.BLOCK, pos) < 10;
    }

    public static boolean isSereneSeasonsLoaded() {
        return isSereneSeasonsLoaded;
    }
}

