/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.shrink.cap;

import javax.annotation.Nonnull;
import net.gigabit101.shrink.api.IShrinkProvider;
import net.gigabit101.shrink.api.ShrinkAPI;
import net.gigabit101.shrink.network.PacketHandler;
import net.gigabit101.shrink.network.PacketShrink;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public final class ShrinkImpl {
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(IShrinkProvider.class);
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        public static final ResourceLocation NAME = new ResourceLocation("shrink", "shrunk");
        private final DefaultImpl impl;
        private final LazyOptional<IShrinkProvider> cap;

        public Provider(LivingEntity livingEntity) {
            this.impl = new DefaultImpl(livingEntity);
            this.cap = LazyOptional.of(() -> this.impl);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
            if (capability == ShrinkAPI.SHRINK_CAPABILITY) {
                return this.cap.cast();
            }
            return LazyOptional.empty();
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability) {
            if (capability == ShrinkAPI.SHRINK_CAPABILITY) {
                return this.cap.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.impl.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.impl.deserializeNBT(nbt);
        }
    }

    private static class DefaultImpl
    implements IShrinkProvider {
        private final LivingEntity livingEntity;
        private boolean isShrunk = false;
        private EntityDimensions defaultEntitySize;
        private float defaultEyeHeight;
        private float scale = 1.0f;
        private boolean isShrinking = false;

        private DefaultImpl(@Nonnull LivingEntity livingEntity) {
            this.livingEntity = livingEntity;
        }

        @Override
        public boolean isShrunk() {
            return this.isShrunk;
        }

        @Override
        public boolean isShrinking() {
            return this.isShrinking;
        }

        @Override
        public void setShrinking(boolean value) {
            this.isShrinking = value;
        }

        @Override
        public void setShrunk(boolean isShrunk) {
            if (this.isShrunk != isShrunk) {
                this.isShrunk = isShrunk;
                this.sync(this.livingEntity);
            }
        }

        @Override
        public void sync(@Nonnull LivingEntity livingEntity) {
            PacketHandler.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> livingEntity), new PacketShrink(livingEntity.m_19879_(), this.serializeNBT()));
        }

        @Override
        public void shrink(@Nonnull LivingEntity livingEntity) {
            this.setShrinking(true);
            livingEntity.m_6210_();
            this.setShrunk(true);
            this.sync(livingEntity);
        }

        @Override
        public void deShrink(@Nonnull LivingEntity livingEntity) {
            this.setShrunk(false);
            livingEntity.m_6210_();
            this.sync(livingEntity);
        }

        @Override
        public EntityDimensions defaultEntitySize() {
            return this.defaultEntitySize;
        }

        @Override
        public float defaultEyeHeight() {
            return this.defaultEyeHeight;
        }

        @Override
        public float scale() {
            return this.scale;
        }

        @Override
        public void setScale(float scale) {
            if (this.scale != scale) {
                this.scale = scale;
                this.sync(this.livingEntity);
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag properties = new CompoundTag();
            properties.m_128379_("isshrunk", this.isShrunk);
            if (this.defaultEntitySize != null) {
                properties.m_128350_("width", this.defaultEntitySize.f_20377_);
                properties.m_128350_("height", this.defaultEntitySize.f_20378_);
                properties.m_128379_("fixed", this.defaultEntitySize.f_20379_);
            }
            properties.m_128350_("defaulteyeheight", this.defaultEyeHeight);
            properties.m_128350_("scale", this.scale);
            properties.m_128379_("isshrinking", this.isShrinking);
            return properties;
        }

        public void deserializeNBT(CompoundTag properties) {
            this.isShrunk = properties.m_128471_("isshrunk");
            this.defaultEntitySize = new EntityDimensions(properties.m_128457_("width"), properties.m_128457_("height"), properties.m_128471_("fixed"));
            this.defaultEyeHeight = properties.m_128457_("defaulteyeheight");
            this.scale = properties.m_128457_("scale");
            this.isShrinking = properties.m_128471_("isshrinking");
        }
    }
}

