/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.maptrades;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class StructureSpecificMaps {

    public static class TreasureMapForEmeralds
    implements VillagerTrades.ItemListing {
        private final int emeraldCost;
        private final ResourceKey<Structure> destination;
        private final TagKey<Structure> destinationTag;
        private final String displayName;
        private final MapDecoration.Type destinationType;
        private final int maxUses;
        private final int villagerXp;
        private final int spawnRegionSearchRadius;

        public TreasureMapForEmeralds(int emeraldCost, String csf, String displayName, MapDecoration.Type mapIcon, int maxUse, int xp, int spawnRegionSearchRadius) {
            this.emeraldCost = emeraldCost;
            if (csf.startsWith("#")) {
                this.destination = null;
                this.destinationTag = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(csf.replaceFirst("#", "")));
            } else {
                this.destination = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(csf));
                this.destinationTag = null;
            }
            this.displayName = displayName;
            this.destinationType = mapIcon;
            this.maxUses = maxUse;
            this.villagerXp = xp;
            this.spawnRegionSearchRadius = spawnRegionSearchRadius;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            Level level = entity.f_19853_;
            if (!(level instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverlevel = (ServerLevel)level;
            return this.getOffer(serverlevel, entity);
        }

        private HolderSet<Structure> getHolderSet(ServerLevel level) {
            Registry registry = level.m_8891_().m_175515_(Registries.f_256944_);
            return HolderSet.m_205809_((Holder[])new Holder[]{registry.m_246971_(this.destination)});
        }

        private MerchantOffer getOffer(ServerLevel level, Entity entity) {
            BlockPos blockpos = null;
            if (this.destinationTag == null) {
                HolderSet<Structure> holderSet = this.getHolderSet(level);
                Pair pairResult = level.m_7726_().m_8481_().m_223037_(level, holderSet, entity.m_20183_(), this.spawnRegionSearchRadius, true);
                if (pairResult != null) {
                    blockpos = (BlockPos)pairResult.getFirst();
                }
            } else {
                blockpos = level.m_215011_(this.destinationTag, entity.m_20183_(), this.spawnRegionSearchRadius, true);
            }
            if (blockpos != null) {
                ItemStack itemstack = MapItem.m_42886_((Level)level, (int)blockpos.m_123341_(), (int)blockpos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                MapItem.m_42850_((ServerLevel)level, (ItemStack)itemstack);
                MapItemSavedData.m_77925_((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)this.destinationType);
                itemstack.m_41714_((Component)Component.m_237115_((String)this.displayName));
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldCost), new ItemStack((ItemLike)Items.f_42522_), itemstack, this.maxUses, this.villagerXp, 0.2f);
            }
            return null;
        }
    }
}

