/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class PillarProcessor
extends StructureProcessor {
    private static final ResourceLocation EMPTY_RL = new ResourceLocation("minecraft", "empty");
    public static final Codec<PillarProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.mapPair((MapCodec)BlockState.f_61039_.fieldOf("trigger"), (MapCodec)BlockState.f_61039_.fieldOf("replacement")).codec().listOf().xmap(list -> list.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)), map -> map.entrySet().stream().map(entry -> Pair.of((Object)((BlockState)entry.getKey()), (Object)((BlockState)entry.getValue()))).collect(Collectors.toList())).fieldOf("pillar_trigger_and_replacements").forGetter(processor -> processor.pillarTriggerAndReplacementBlocks), (App)ResourceLocation.f_135803_.optionalFieldOf("pillar_processor_list", (Object)EMPTY_RL).forGetter(processor -> processor.processorList), (App)Direction.f_175356_.optionalFieldOf("direction", (Object)Direction.DOWN).forGetter(processor -> processor.direction), (App)BlockState.f_61039_.optionalFieldOf("original_replaced_block").forGetter(processor -> processor.originalReplacedBlock), (App)Codec.INT.optionalFieldOf("pillar_length", (Object)1000).forGetter(config -> config.pillarLength), (App)Codec.BOOL.optionalFieldOf("forced_placement", (Object)false).forGetter(config -> config.forcePlacement)).apply((Applicative)instance, instance.stable(PillarProcessor::new)));
    public final Map<BlockState, BlockState> pillarTriggerAndReplacementBlocks;
    public final Optional<BlockState> originalReplacedBlock;
    public final ResourceLocation processorList;
    public final Direction direction;
    public final int pillarLength;
    public final boolean forcePlacement;

    private PillarProcessor(Map<BlockState, BlockState> pillarTriggerAndReplacementBlocks, ResourceLocation processorList, Direction direction, Optional<BlockState> originalReplacedBlock, int pillarLength, boolean forcePlacement) {
        this.pillarTriggerAndReplacementBlocks = pillarTriggerAndReplacementBlocks;
        this.processorList = processorList;
        this.direction = direction;
        this.originalReplacedBlock = originalReplacedBlock;
        this.pillarLength = pillarLength;
        this.forcePlacement = forcePlacement;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos templateOffset, BlockPos worldOffset, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        BlockState blockState = structureBlockInfoWorld.f_74676_;
        if (this.pillarTriggerAndReplacementBlocks.containsKey(blockState)) {
            WorldGenRegion worldGenRegion;
            BlockPos worldPos = structureBlockInfoWorld.f_74675_;
            BlockState replacementState = this.pillarTriggerAndReplacementBlocks.get(blockState);
            BlockState originalReplacementState = this.originalReplacedBlock.orElse(replacementState);
            BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)worldPos);
            StructureProcessorList structureProcessorList = null;
            if (this.processorList != null && !this.processorList.equals((Object)EMPTY_RL)) {
                structureProcessorList = (StructureProcessorList)levelReader.m_8891_().m_175515_(Registries.f_257011_).m_7745_(this.processorList);
            }
            if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).m_143488_().equals((Object)new ChunkPos((BlockPos)currentPos))) {
                return PillarProcessor.getReturnBlock(worldPos, originalReplacementState);
            }
            int terrainY = Integer.MIN_VALUE;
            if (this.direction == Direction.DOWN && !this.forcePlacement && (terrainY = GeneralUtils.getFirstLandYFromPos(levelReader, worldPos)) <= levelReader.m_141937_() && this.pillarLength + 2 >= worldPos.m_123342_() - levelReader.m_141937_()) {
                return PillarProcessor.getReturnBlock(worldPos, originalReplacementState);
            }
            BlockState currentBlock = levelReader.m_8055_(worldPos.m_7495_());
            while (!(!this.forcePlacement && currentBlock.m_60815_() || !this.forcePlacement && currentPos.m_123342_() < terrainY || levelReader.m_151562_(currentPos.m_123342_()) || !currentPos.m_123314_((Vec3i)worldPos, (double)this.pillarLength))) {
                StructureTemplate.StructureBlockInfo newPillarState1 = new StructureTemplate.StructureBlockInfo(currentPos.m_121996_((Vec3i)worldPos).m_121955_((Vec3i)templateOffset), replacementState, null);
                StructureTemplate.StructureBlockInfo newPillarState2 = new StructureTemplate.StructureBlockInfo(currentPos.m_7949_(), replacementState, null);
                if (structureProcessorList != null) {
                    for (StructureProcessor processor : structureProcessorList.m_74425_()) {
                        if (newPillarState2 == null) break;
                        newPillarState2 = processor.m_7382_(levelReader, newPillarState1.f_74675_, newPillarState2.f_74675_, newPillarState1, newPillarState2, structurePlacementData);
                    }
                }
                if (newPillarState2 != null) {
                    levelReader.m_46865_((BlockPos)currentPos).m_6978_((BlockPos)currentPos, newPillarState2.f_74676_, false);
                }
                currentPos.m_122173_(this.direction);
                currentBlock = levelReader.m_8055_((BlockPos)currentPos);
            }
            return PillarProcessor.getReturnBlock(worldPos, originalReplacementState);
        }
        return structureBlockInfoWorld;
    }

    private static StructureTemplate.StructureBlockInfo getReturnBlock(BlockPos worldPos, BlockState originalReplacementState) {
        return originalReplacementState == null || originalReplacementState.m_60713_(Blocks.f_50454_) ? null : new StructureTemplate.StructureBlockInfo(worldPos, originalReplacementState, null);
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)RSProcessors.PILLAR_PROCESSOR.get();
    }
}

