/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.miningdimension.corelib.inventory;

import de.maxhenkel.miningdimension.corelib.sound.SoundUtils;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public abstract class ShulkerBoxInventory
implements Container,
MenuProvider {
    protected NonNullList<ItemStack> items;
    protected ItemStack shulkerBox;
    protected int invSize;
    protected CompoundTag blockEntityTag;
    protected ResourceLocation lootTable;
    protected long lootTableSeed;

    public ShulkerBoxInventory(Player player, ItemStack shulkerBox, int invSize) {
        this.shulkerBox = shulkerBox;
        this.invSize = invSize;
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        this.m_5856_(player);
        CompoundTag c = shulkerBox.m_41783_();
        if (c == null) {
            return;
        }
        if (!c.m_128441_("BlockEntityTag")) {
            return;
        }
        this.blockEntityTag = c.m_128469_("BlockEntityTag");
        if (this.blockEntityTag.m_128441_("Items")) {
            ContainerHelper.m_18980_((CompoundTag)this.blockEntityTag, this.items);
        } else if (this.blockEntityTag.m_128441_("LootTable")) {
            this.lootTable = new ResourceLocation(this.blockEntityTag.m_128461_("LootTable"));
            this.lootTableSeed = this.blockEntityTag.m_128454_("LootTableSeed");
            this.fillWithLoot(player);
            this.blockEntityTag.m_128473_("LootTable");
            this.blockEntityTag.m_128473_("LootTableSeed");
        }
    }

    public ShulkerBoxInventory(Player player, ItemStack shulkerBox) {
        this(player, shulkerBox, 27);
    }

    public void fillWithLoot(@Nullable Player player) {
        if (this.lootTable != null && player != null) {
            LootTable loottable = player.f_19853_.m_7654_().m_129898_().m_79217_(this.lootTable);
            this.lootTable = null;
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)player.f_19853_);
            if (this.lootTableSeed != 0L) {
                builder.m_78965_(this.lootTableSeed);
            }
            builder.m_78963_(player.m_36336_()).m_78972_(LootContextParams.f_81455_, (Object)player);
            loottable.m_79123_((Container)this, builder.m_78975_(LootContextParamSets.f_81411_));
            this.m_6596_();
        }
    }

    public int m_6643_() {
        return this.invSize;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.items, (int)index, (int)count);
        this.m_6596_();
        return itemstack;
    }

    public ItemStack m_8016_(int index) {
        ItemStack stack = ContainerHelper.m_18966_(this.items, (int)index);
        this.m_6596_();
        return stack;
    }

    public void m_6836_(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        this.m_6596_();
    }

    public int m_6893_() {
        return 64;
    }

    public void m_6596_() {
        CompoundTag tag = this.shulkerBox.m_41784_();
        if (this.blockEntityTag == null) {
            this.blockEntityTag = new CompoundTag();
            tag.m_128365_("BlockEntityTag", (Tag)this.blockEntityTag);
        } else {
            tag.m_128365_("BlockEntityTag", (Tag)this.blockEntityTag);
        }
        ContainerHelper.m_18976_((CompoundTag)this.blockEntityTag, this.items, (boolean)true);
    }

    public void m_5856_(Player player) {
        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.getOpenSound(), SoundSource.BLOCKS, 0.5f, SoundUtils.getVariatedPitch(player.f_19853_));
    }

    public void m_5785_(Player player) {
        this.m_6596_();
        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.getCloseSound(), SoundSource.BLOCKS, 0.5f, player.f_19853_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    protected SoundEvent getOpenSound() {
        return SoundEvents.f_12409_;
    }

    protected SoundEvent getCloseSound() {
        return SoundEvents.f_12408_;
    }

    public void m_6211_() {
        this.items.clear();
        this.m_6596_();
    }

    public boolean m_7983_() {
        return this.items.isEmpty();
    }

    public boolean m_6542_(Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            if (!player.m_21120_(hand).equals(this.shulkerBox)) continue;
            return true;
        }
        return false;
    }

    public Component m_5446_() {
        return this.shulkerBox.m_41786_();
    }

    @Nullable
    public abstract AbstractContainerMenu m_7208_(int var1, Inventory var2, Player var3);
}

