/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.miningdimension.dimension;

import de.maxhenkel.miningdimension.Main;
import de.maxhenkel.miningdimension.block.BlockTeleporter;
import de.maxhenkel.miningdimension.tileentity.TileentityTeleporter;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.util.ITeleporter;

public class MiningDimensionTeleporter
implements ITeleporter {
    private BlockPos pos;

    public MiningDimensionTeleporter(BlockPos pos) {
        this.pos = pos;
    }

    public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        Entity e = repositionEntity.apply(false);
        if (!(e instanceof ServerPlayer)) {
            return e;
        }
        ServerPlayer player = (ServerPlayer)e;
        LevelChunk chunk = (LevelChunk)destWorld.m_46865_(this.pos);
        BlockPos teleporterPos = this.findPortalInChunk(chunk);
        if (teleporterPos == null) {
            teleporterPos = destWorld.m_46472_().equals(Main.MINING_DIMENSION) ? this.placeTeleporterMining(destWorld, chunk) : this.placeTeleporterOverworld(destWorld, chunk);
        }
        if (teleporterPos == null) {
            return e;
        }
        player.m_6749_(0);
        player.m_6021_((double)teleporterPos.m_123341_() + 0.5, (double)teleporterPos.m_123342_() + 1.0, (double)teleporterPos.m_123343_() + 0.5);
        return e;
    }

    private BlockPos findPortalInChunk(LevelChunk chunk) {
        Stream<Map.Entry> stream = chunk.m_62954_().entrySet().stream().filter(entry -> entry.getValue() instanceof TileentityTeleporter);
        BlockPos teleporter = (Boolean)Main.SERVER_CONFIG.spawnDeep.get() != false ? (BlockPos)stream.sorted(Comparator.comparingInt(o -> ((BlockPos)o.getKey()).m_123342_())).map(Map.Entry::getKey).findFirst().orElse(null) : (BlockPos)stream.sorted((o1, o2) -> ((BlockPos)o2.getKey()).m_123342_() - ((BlockPos)o1.getKey()).m_123342_()).map(Map.Entry::getKey).findFirst().orElse(null);
        if (teleporter != null && chunk.m_8055_(teleporter.m_7494_()).m_60795_()) {
            return teleporter;
        }
        return null;
    }

    private BlockPos placeTeleporterMining(ServerLevel world, LevelChunk chunk) {
        int z;
        int x;
        int y;
        boolean deep = (Boolean)Main.SERVER_CONFIG.spawnDeep.get();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int min = world.m_141937_();
        int max = world.m_151558_();
        int n = y = deep ? min : max - 1;
        while (deep ? y < max - 1 : y >= min) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    pos.m_122178_(x, y, z);
                    if (!chunk.m_8055_((BlockPos)pos).m_60795_() || !chunk.m_8055_(pos.m_6630_(1)).m_60795_() || !chunk.m_8055_(pos.m_6630_(2)).m_60795_()) continue;
                    BlockPos absolutePos = chunk.m_7697_().m_45615_().m_7918_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                    world.m_46597_(absolutePos, ((BlockTeleporter)Main.TELEPORTER.get()).m_49966_());
                    return absolutePos;
                }
            }
            y = deep ? y + 1 : y - 1;
        }
        int n2 = y = deep ? min : max - 1;
        while (deep ? y < max - 1 : y >= min) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    BlockPos absolutePos;
                    pos.m_122178_(x, y, z);
                    if (!this.isAirOrStone(chunk, (BlockPos)pos) || !this.isAirOrStone(chunk, pos.m_6630_(1)) || !this.isAirOrStone(chunk, pos.m_6630_(2)) || !this.isReplaceable((Level)world, (absolutePos = chunk.m_7697_().m_45615_().m_7918_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).m_6630_(3)) || !this.isReplaceable((Level)world, absolutePos.m_6630_(1).m_121945_(Direction.NORTH)) || !this.isReplaceable((Level)world, absolutePos.m_6630_(1).m_121945_(Direction.NORTH)) || !this.isReplaceable((Level)world, absolutePos.m_6630_(1).m_121945_(Direction.SOUTH)) || !this.isReplaceable((Level)world, absolutePos.m_6630_(1).m_121945_(Direction.EAST)) || !this.isReplaceable((Level)world, absolutePos.m_6630_(1).m_121945_(Direction.WEST)) || !this.isReplaceable((Level)world, absolutePos.m_6630_(2).m_121945_(Direction.NORTH)) || !this.isReplaceable((Level)world, absolutePos.m_6630_(2).m_121945_(Direction.SOUTH)) || !this.isReplaceable((Level)world, absolutePos.m_6630_(2).m_121945_(Direction.EAST)) || !this.isReplaceable((Level)world, absolutePos.m_6630_(2).m_121945_(Direction.WEST))) continue;
                    world.m_46597_(absolutePos, ((BlockTeleporter)Main.TELEPORTER.get()).m_49966_());
                    world.m_46597_(absolutePos.m_6630_(1), Blocks.f_50016_.m_49966_());
                    world.m_46597_(absolutePos.m_6630_(2), Blocks.f_50016_.m_49966_());
                    world.m_46597_(absolutePos.m_6630_(3), Blocks.f_50069_.m_49966_());
                    world.m_46597_(absolutePos.m_6630_(1).m_121945_(Direction.NORTH), Blocks.f_50069_.m_49966_());
                    world.m_46597_(absolutePos.m_6630_(1).m_121945_(Direction.SOUTH), Blocks.f_50069_.m_49966_());
                    world.m_46597_(absolutePos.m_6630_(1).m_121945_(Direction.EAST), Blocks.f_50069_.m_49966_());
                    world.m_46597_(absolutePos.m_6630_(1).m_121945_(Direction.WEST), Blocks.f_50069_.m_49966_());
                    world.m_46597_(absolutePos.m_6630_(2).m_121945_(Direction.NORTH), Blocks.f_50069_.m_49966_());
                    world.m_46597_(absolutePos.m_6630_(2).m_121945_(Direction.SOUTH), Blocks.f_50069_.m_49966_());
                    world.m_46597_(absolutePos.m_6630_(2).m_121945_(Direction.EAST), Blocks.f_50069_.m_49966_());
                    world.m_46597_(absolutePos.m_6630_(2).m_121945_(Direction.WEST), Blocks.f_50069_.m_49966_());
                    return absolutePos;
                }
            }
            y = deep ? y + 1 : y - 1;
        }
        return null;
    }

    private boolean isAirOrStone(LevelChunk chunk, BlockPos pos) {
        BlockState state = chunk.m_8055_(pos);
        return state.m_60734_().equals(Blocks.f_50069_) || state.m_60795_();
    }

    private boolean isReplaceable(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_().equals(Blocks.f_50069_) || state.m_60734_().equals(Blocks.f_50122_) || state.m_60734_().equals(Blocks.f_50334_) || state.m_60734_().equals(Blocks.f_50228_) || state.m_60734_().equals(Blocks.f_50493_) || state.m_60734_().equals(Blocks.f_49994_) || state.m_60734_().equals(Blocks.f_49991_) || state.m_60795_();
    }

    private BlockPos placeTeleporterOverworld(ServerLevel world, LevelChunk chunk) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = world.m_5736_(); y < world.m_151558_(); ++y) {
                    pos.m_122178_(x, y, z);
                    if (!chunk.m_8055_((BlockPos)pos).m_60795_() || !chunk.m_8055_(pos.m_6630_(1)).m_60795_()) continue;
                    BlockPos absolutePos = chunk.m_7697_().m_45615_().m_7918_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                    world.m_46597_(absolutePos, ((BlockTeleporter)Main.TELEPORTER.get()).m_49966_());
                    return absolutePos;
                }
            }
        }
        return null;
    }
}

