/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.displacement.MentalDisplacementSpellEffect;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.networking.MentalDisplacementUpdatePacket;
import stepsword.mahoutsukai.networking.PacketHandler;

public class MentalDisplacementEntity
extends Entity {
    public static final String entityName = "mental_displacement";
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(MentalDisplacementEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public BlockPos origPos;
    public Player player;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    private boolean backInputDown;
    private boolean forwardInputDown;
    private boolean leftInputDown;
    private boolean rightInputDown;
    private boolean upInputDown;
    private boolean downInputDown;
    public boolean used = false;

    public MentalDisplacementEntity(PlayMessages.SpawnEntity packet, Level worldIn) {
        super((EntityType)ModEntities.MENTAL_DISPLACEMENT.get(), worldIn);
        this.f_19811_ = true;
    }

    public MentalDisplacementEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public MentalDisplacementEntity(Level world) {
        super((EntityType)ModEntities.MENTAL_DISPLACEMENT.get(), world);
        this.origPos = null;
        this.player = null;
    }

    public MentalDisplacementEntity(Level world, BlockPos o, Player p) {
        this(world);
        this.origPos = o;
        this.player = p;
        this.m_6034_(this.origPos.m_123341_(), this.origPos.m_123342_(), this.origPos.m_123343_());
        this.m_20334_(0.0, 0.0, 0.0);
        this.f_19857_ = p.f_19857_;
        this.f_19858_ = p.f_19858_;
    }

    private void tickLerp() {
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d3 = Mth.m_14175_((double)(this.lerpYaw - (double)this.f_19857_));
            this.f_19857_ = (float)((double)this.f_19857_ + d3 / (double)this.lerpSteps);
            this.f_19858_ = (float)((double)this.f_19858_ + (this.lerpPitch - (double)this.f_19858_) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
            this.m_19915_(this.f_19857_, this.f_19858_);
        }
    }

    public boolean m_6109_() {
        return false;
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = posRotationIncrements;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.player == null) {
                this.m_146870_();
                return;
            }
            if (!this.player.m_6084_()) {
                this.m_146870_();
                return;
            }
            if (MentalDisplacementSpellEffect.checkDistance(this.player.m_20183_(), this.m_20183_()) > MTConfig.MENTAL_DISPLACEMENT_RANGE) {
                this.m_146870_();
                return;
            }
        }
        this.m_19915_(this.f_19857_, this.f_19858_);
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        Vec3 motion = this.m_20184_();
        Vec3 position = this.m_20182_().m_82549_(motion);
        this.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
        this.tickLerp();
        this.playerControl();
    }

    public void playerControl() {
        if (this.f_19853_.f_46443_) {
            float moveSpeed = 0.01f;
            float slowFactor = 0.1f;
            float f = 1.0E-8f;
            float l = 1.0E-8f;
            float u = 0.0f;
            float fm = 0.0f;
            float lm = 0.0f;
            float um = 1.0f;
            if (this.backInputDown) {
                f += -moveSpeed;
            }
            if (this.forwardInputDown) {
                f += moveSpeed;
            }
            if (this.leftInputDown) {
                l += moveSpeed;
            }
            if (this.rightInputDown) {
                l += -moveSpeed;
            }
            if (this.upInputDown) {
                u += moveSpeed;
            }
            if (this.downInputDown) {
                u += -moveSpeed;
            }
            if (!this.forwardInputDown && !this.backInputDown) {
                fm = 1.0f;
            }
            if (!this.leftInputDown && !this.rightInputDown) {
                lm = 1.0f;
            }
            if (!this.upInputDown && !this.downInputDown) {
                um = slowFactor;
            }
            Vec3 motion = this.m_20184_();
            this.m_20334_(motion.f_82479_ + (double)(-(Mth.m_14031_((float)(this.f_19857_ * ((float)Math.PI / 180))) * f)) + (double)(Mth.m_14089_((float)(this.f_19857_ * ((float)Math.PI / 180))) * l), motion.f_82480_, motion.f_82481_ + (double)(Mth.m_14089_((float)(this.f_19857_ * ((float)Math.PI / 180))) * f) + (double)(Mth.m_14031_((float)(this.f_19857_ * ((float)Math.PI / 180))) * l));
            motion = this.m_20184_();
            double g = Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_);
            float angle = (float)(-Math.atan2(motion.f_82479_, motion.f_82481_)) * 57.2958f;
            double c = g * (double)Mth.m_14089_((float)((angle - this.f_19857_ + 90.0f) * ((float)Math.PI / 180)));
            double c2 = c * (double)Mth.m_14089_((float)(this.f_19857_ * ((float)Math.PI / 180)));
            double c1 = c * (double)Mth.m_14031_((float)(this.f_19857_ * ((float)Math.PI / 180)));
            double d = g * (double)Mth.m_14089_((float)((angle - this.f_19857_) * ((float)Math.PI / 180)));
            double d2 = -d * (double)Mth.m_14031_((float)(this.f_19857_ * ((float)Math.PI / 180)));
            double d1 = d * (double)Mth.m_14089_((float)(this.f_19857_ * ((float)Math.PI / 180)));
            this.m_20334_(motion.f_82479_ - (double)lm * c2 - (double)fm * d2, (double)um * ((double)u + motion.f_82480_), motion.f_82481_ - (double)lm * c1 - (double)fm * d1);
            Vec3 v = this.m_20182_().m_82549_(this.m_20184_());
            this.m_6034_(v.f_82479_, v.f_82480_, v.f_82481_);
            Vec3 dm = this.m_20184_();
            Vec3 pp = this.m_20182_();
            PacketHandler.sendToServer(new MentalDisplacementUpdatePacket(this, pp.f_82479_, pp.f_82480_, pp.f_82481_, dm.f_82479_, dm.f_82480_, dm.f_82481_, this.f_19857_, this.f_19858_));
        }
    }

    public void updatePacket(MentalDisplacementUpdatePacket packet) {
        this.m_6034_(packet.x, packet.y, packet.z);
        this.m_20334_(packet.vx, packet.vy, packet.vz);
        this.m_19915_((float)packet.yaw, (float)packet.pitch);
    }

    public void updateInputs(boolean b, boolean f, boolean l, boolean r, boolean u, boolean d) {
        this.backInputDown = b;
        this.forwardInputDown = f;
        this.leftInputDown = l;
        this.rightInputDown = r;
        this.upInputDown = u;
        this.downInputDown = d;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(UUID.randomUUID());
    }

    public void setOwnerId(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    public void m_7378_(CompoundTag compound) {
        this.used = compound.m_128471_("mahoutsukai_used");
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128379_("mahoutsukai_used", this.used);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public AABB m_20191_() {
        return new AABB(this.m_20185_() - 0.1, this.m_20186_() - 0.1, this.m_20189_() - 0.1, this.m_20185_() + 0.1, this.m_20186_() + 0.1, this.m_20189_() + 0.1);
    }

    public AABB m_6921_() {
        return new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }
}

