/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.integration;

import io.netty.util.internal.ConcurrentSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.registries.RegisterEvent;
import stepsword.jousting.item.ItemLance;
import stepsword.mahoutsukai.MahouRegistry;
import stepsword.mahoutsukai.capability.lance.ILanceMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.PowerConsolidationSpellEffect;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.integration.JoustingProxy;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.lance.Rhongomyniad;
import stepsword.mahoutsukai.util.Utils;

public class JoustingLoadedProxy
extends JoustingProxy {
    @Override
    public void registerItems(RegisterEvent.RegisterHelper<Item> helper) {
        helper.register(MahouRegistry.ITEM_RHONGOMYNIAD, (Object)new Rhongomyniad());
    }

    @Override
    public void addToCreativeTab(CreativeModeTab.Output output) {
        output.m_246326_((ItemLike)ModItems.rhongomyniad.get());
    }

    @Override
    public void powerConsolidation(TickEvent.LevelTickEvent event, ItemEntity item, List<ItemEntity> toDelete, List<WeaponProjectileEntity> toSpawn) {
        if (item.m_32055_().m_41720_() instanceof ItemLance && PowerConsolidationSpellEffect.isItemAllowed(item.m_32055_())) {
            boolean z = Utils.isInMurkyWater((Entity)item);
            double rhongomyniadNerf = MTConfig.RHONGOMYNIAD_NERF_FACTOR;
            if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                System.out.println("Allowed sword found. Is in murky water: " + z);
            }
            if (z) {
                Player player;
                if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                    System.out.println("Lance is enchanted:" + item.m_32055_().m_41793_());
                }
                if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                    System.out.println("ThrowerID:" + item.m_32057_());
                }
                if (item.m_32055_().m_41793_() && item.m_32057_() != null && (player = event.level.m_46003_(item.m_32057_())) != null) {
                    ConcurrentSet connected = new ConcurrentSet();
                    boolean lt = PowerConsolidationSpellEffect.lakeThreshhold(item.m_20183_(), (ConcurrentSet<BlockPos>)connected, event.level);
                    if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                        System.out.println("Lake Threshhold:" + lt);
                    }
                    if (lt) {
                        ItemStack stack;
                        ILanceMahou mahou;
                        BlockPos p = PowerConsolidationSpellEffect.findCenter((ConcurrentSet<BlockPos>)connected);
                        if (!Utils.isBlockAir(event.level, p)) {
                            p = p.m_7495_();
                        }
                        if ((mahou = Utils.getLanceMahou(stack = new ItemStack((ItemLike)ModItems.rhongomyniad.get()))) != null) {
                            float damage = Rhongomyniad.simulateHit(item.m_32055_(), event.level);
                            ItemStack stackCopy = item.m_32055_().m_41777_();
                            ListTag tagList = stackCopy.m_41785_();
                            tagList.clear();
                            float damageWithoutEnchant = Rhongomyniad.simulateHit(stackCopy, event.level);
                            damage = (float)((double)damage - rhongomyniadNerf * (double)(damage - damageWithoutEnchant));
                            mahou.setAttackDamage(damage -= 1.0f);
                            mahou.setWeight(mahou.getWeight() - 0.02f);
                            Rhongomyniad.setattacktonbt(stack, event.level);
                        }
                        if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                            System.out.println("Advancement Time");
                        }
                        WeaponProjectileEntity wpe = new WeaponProjectileEntity(event.level, p.m_123341_(), p.m_123342_(), p.m_123343_(), stack);
                        wpe.m_20334_(0.0, -1.0, 0.0);
                        wpe.m_5602_((Entity)player);
                        toSpawn.add(wpe);
                        toDelete.add(item);
                    }
                }
            }
        }
    }

    @Override
    public boolean treasuryProjection(Item i) {
        return i instanceof ItemLance;
    }
}

