/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.networking.ClientPacketHandler;

public class ReplicaKnockbackParticlePacket {
    public double posX;
    public double posY;
    public double posZ;
    public float r;
    public float g;
    public float b;

    public ReplicaKnockbackParticlePacket() {
    }

    public ReplicaKnockbackParticlePacket(double posX, double posY, double posZ, float r, float g, float b) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public void fromBytes(ByteBuf buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.r = buf.readFloat();
        this.g = buf.readFloat();
        this.b = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeFloat(this.r);
        buf.writeFloat(this.g);
        buf.writeFloat(this.b);
    }

    public static void encode(ReplicaKnockbackParticlePacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static ReplicaKnockbackParticlePacket decode(FriendlyByteBuf buf) {
        ReplicaKnockbackParticlePacket msg = new ReplicaKnockbackParticlePacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(ReplicaKnockbackParticlePacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.replicaKnockbackParticleHandler(message);
        context.get().setPacketHandled(true);
    }
}

