/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.butterfly.ButterflyEntity;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

@OnlyIn(value=Dist.CLIENT)
public class RenderButterfly
extends EntityRenderer<ButterflyEntity> {
    private static final ResourceLocation butterfly1 = new ResourceLocation("mahoutsukai:textures/entity/butterfly1.png");
    private static final ResourceLocation butterfly2 = new ResourceLocation("mahoutsukai:textures/entity/butterfly2.png");
    private static final ResourceLocation butterfly3 = new ResourceLocation("mahoutsukai:textures/entity/butterfly3.png");
    private static final ResourceLocation butterfly4 = new ResourceLocation("mahoutsukai:textures/entity/butterfly4.png");
    private static final ResourceLocation butterfly5 = new ResourceLocation("mahoutsukai:textures/entity/butterfly5.png");
    private static final ResourceLocation butterfly6 = new ResourceLocation("mahoutsukai:textures/entity/butterfly6.png");
    private static final ResourceLocation butterfly7 = new ResourceLocation("mahoutsukai:textures/entity/butterfly7.png");

    public RenderButterfly(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(ButterflyEntity entityIn, float entityYaw, float partialTicks, PoseStack matrix, MultiBufferSource buf, int packedLightIn) {
        boolean z;
        boolean bl = z = entityIn.getCasterUUID() != null && Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_20148_().equals(entityIn.getCasterUUID());
        if (MTConfig.BUTTERFLY_EFFECT_VISIBLE_TO_OTHERS || z) {
            matrix.m_85836_();
            float angle = entityIn.prevangle + partialTicks * (entityIn.angle - entityIn.prevangle);
            float size = entityIn.getSize();
            float yaw = this.calcPartialYaw(entityIn.f_19857_, entityIn.f_19859_, partialTicks);
            matrix.m_85841_(size, size, size);
            RenderUtils.rotateQ(yaw, 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(entityIn.f_19858_, 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.rotateQ(angle, 0.0f, 0.0f, 1.0f, matrix);
            this.drawWing(entityIn, matrix, 0.0f);
            RenderUtils.rotateQ(180.0f - 2.0f * angle, 0.0f, 0.0f, 1.0f, matrix);
            this.drawWing(entityIn, matrix, 0.0f);
            matrix.m_85849_();
        }
    }

    public ResourceLocation getTextureLocation(ButterflyEntity entity) {
        return TextureAtlas.f_118259_;
    }

    private void drawWing(ButterflyEntity e, PoseStack matrix, float m) {
        this.drawTexture(m * 0.0f, matrix, 0.0f, 0.0f, 0.0f, 1.0f, butterfly1);
        this.drawTexture(m * 0.001f, matrix, e.colors[0][0] / 255.0f, e.colors[0][1] / 255.0f, e.colors[0][2] / 255.0f, 1.0f, butterfly2);
        this.drawTexture(m * 0.001f, matrix, e.colors[1][0] / 255.0f, e.colors[1][1] / 255.0f, e.colors[1][2] / 255.0f, 1.0f, butterfly3);
        this.drawTexture(m * 0.001f, matrix, e.colors[2][0] / 255.0f, e.colors[2][1] / 255.0f, e.colors[2][2] / 255.0f, 1.0f, butterfly4);
        this.drawTexture(m * 0.001f, matrix, e.colors[3][0] / 255.0f, e.colors[3][1] / 255.0f, e.colors[3][2] / 255.0f, 1.0f, butterfly5);
        this.drawTexture(m * 0.001f, matrix, e.colors[4][0] / 255.0f, e.colors[4][1] / 255.0f, e.colors[4][2] / 255.0f, 1.0f, butterfly6);
        this.drawTexture(m * 0.001f, matrix, e.colors[5][0] / 255.0f, e.colors[5][1] / 255.0f, e.colors[5][2] / 255.0f, 1.0f, butterfly7);
    }

    private void drawTexture(float cy, PoseStack matrix, float r, float g, float b, float a, ResourceLocation loc) {
        int lightmapX = 240;
        int lightmapY = 240;
        Matrix4f positionMatrix = matrix.m_85850_().m_252922_();
        RenderType type = MahoujinRenderType.createMahoujinRenderType(loc, 0, true);
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer bb = buffer.m_6299_(type);
        bb.m_252986_(positionMatrix, 0.0f, cy, 0.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_252986_(positionMatrix, 0.0f, cy, 1.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_252986_(positionMatrix, 1.0f, cy, 1.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_252986_(positionMatrix, 1.0f, cy, 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        buffer.m_109911_();
    }

    public float calcPartialYaw(float yw, float pyw, float partial) {
        if ((yw %= 360.0f) < 0.0f) {
            yw += 360.0f;
        }
        if (yw > 360.0f) {
            yw -= 360.0f;
        }
        if ((pyw %= 360.0f) < 0.0f) {
            pyw += 360.0f;
        }
        if (pyw > 360.0f) {
            pyw -= 360.0f;
        }
        if (yw < pyw) {
            float d2 = pyw - yw;
            float d1 = yw + (360.0f - pyw);
            if (d2 < d1) {
                return partial * d2 + yw;
            }
            return partial * d1 + pyw;
        }
        float d2 = yw - pyw;
        float d1 = pyw + (360.0f - yw);
        if (d2 < d1) {
            return partial * d2 + pyw;
        }
        return partial * d1 + yw;
    }
}

