/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import stepsword.mahoutsukai.entity.GateWeaponProjectileEntity;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderGateWeaponProjectile
extends EntityRenderer<GateWeaponProjectileEntity> {
    public RenderGateWeaponProjectile(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(GateWeaponProjectileEntity weapon, float yaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
        matrix.m_85836_();
        float s = 2.5f;
        float ryaw = 90.0f + weapon.f_19859_ + (weapon.f_19857_ - weapon.f_19859_) * partialTicks;
        float rpitch = 135.0f - weapon.f_19860_ + (weapon.f_19858_ - weapon.f_19860_) * partialTicks;
        float progress = weapon.getProgress();
        float progresscap = weapon.getProgressCap();
        boolean flag = progress < progresscap;
        float yRotate = -90.0f + weapon.f_19859_ + (weapon.f_19857_ - weapon.f_19859_) * partialTicks;
        float pRotate = 90.0f + weapon.f_19860_ + (weapon.f_19858_ - weapon.f_19860_) * partialTicks;
        float ytranslate = progress + (progress - weapon.lastProgress) * partialTicks - 2.0f;
        matrix.m_85836_();
        RenderUtils.rotateQ(yRotate, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(pRotate, 0.0f, 0.0f, 1.0f, matrix);
        matrix.m_252880_(0.0f, ytranslate, 0.0f);
        matrix.m_85841_(s, s, s);
        if (flag) {
            this.drawCircle(0.0f, matrix, weapon.getTColor());
        }
        matrix.m_85841_(1.0f / s, 1.0f / s, 1.0f / s);
        matrix.m_252880_(0.0f, -ytranslate, 0.0f);
        RenderUtils.rotateQ(-pRotate, 0.0f, 0.0f, 1.0f, matrix);
        RenderUtils.rotateQ(-yRotate, 0.0f, 1.0f, 0.0f, matrix);
        matrix.m_85849_();
        matrix.m_252781_(RenderUtils.getQuaternion(new Vector3f(0.0f, 1.0f, 0.0f), ryaw, true));
        matrix.m_252781_(RenderUtils.getQuaternion(new Vector3f(0.0f, 0.0f, 1.0f), rpitch, true));
        matrix.m_85837_(-0.59, -0.59, -0.59);
        matrix.m_85841_(s, s, s);
        ItemStack stack = weapon.getStack();
        BakedModel bakedModel = Minecraft.m_91087_().m_91291_().m_174264_(stack, null, null, weapon.m_19879_());
        Vec3 zz = weapon.m_20182_();
        RenderUtils.renderClippedItem(stack, ItemTransforms.TransformType.GROUND, false, matrix, buffer, packedLight, OverlayTexture.f_118083_, bakedModel, ytranslate, zz.f_82479_, zz.f_82480_, zz.f_82481_, weapon.f_19857_, weapon.f_19858_, s, flag);
        Minecraft.m_91087_().m_91269_().m_110104_().m_109911_();
        matrix.m_85849_();
        super.m_7392_((Entity)weapon, yaw, partialTicks, matrix, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(GateWeaponProjectileEntity entity) {
        return TextureAtlas.f_118259_;
    }

    private void drawCircle(float progress, PoseStack matrix, float[] colors) {
        int lightmapX = 240;
        int lightmapY = 240;
        float r = colors[0];
        float g = colors[1];
        float b = colors[2];
        float a = 1.0f;
        Matrix4f positionMatrix = matrix.m_85850_().m_252922_();
        RenderType type = MahoujinRenderType.createMahoujinRenderType(RenderUtils.mahoujin, 0, true);
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer bb = buffer.m_6299_(type);
        bb.m_252986_(positionMatrix, -0.5f, progress, -0.5f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_252986_(positionMatrix, -0.5f, progress, 0.5f).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_252986_(positionMatrix, 0.5f, progress, 0.5f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_252986_(positionMatrix, 0.5f, progress, -0.5f).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        buffer.m_109911_();
    }
}

