/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.FogRenderLayer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.render.shader.ModShaders;

public class ParticleFog
extends Particle {
    public ResourceLocation loc;
    public float[] rgba = new float[4];
    public float softness = 0.07f;
    public float rotation = 0.0f;
    public float sz = 8.0f;
    public boolean startmoving = false;
    public boolean shaders = true;
    public boolean agecolor = true;

    public ParticleFog(ClientLevel worldIn, ResourceLocation loc, double xCoordIn, double yCoordIn, double zCoordIn, float scale, double motionX, double motionY, double motionZ) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, 0.0, 0.0, 0.0);
        float color;
        this.f_107228_ = 0.7137255f;
        this.f_107227_ = 1.0f;
        this.f_107229_ = 0.75686276f;
        float maxAge = 180.0f;
        this.f_107225_ = (int)((double)maxAge / (Math.random() * 0.3 + 0.6));
        this.f_107225_ = (int)((float)this.f_107225_ * scale);
        this.f_107204_ = this.f_107231_ = (float)worldIn.f_46441_.m_188503_(360) * 0.0174533f;
        this.loc = loc;
        this.softness += 0.0f;
        this.rgba[0] = color = 0.8f + 0.2f * worldIn.f_46441_.m_188501_();
        this.rgba[1] = color;
        this.rgba[2] = color;
        this.rgba[3] = 0.0f;
        this.rotation = worldIn.f_46441_.m_188501_() * 360.0f;
        this.sz += worldIn.f_46441_.m_188501_() * 12.0f - 2.0f;
        motionX = this.f_107208_.f_46441_.m_188501_() * 2.0E-4f - 1.0E-4f;
        motionZ = this.f_107208_.f_46441_.m_188501_() * 2.0E-4f - 1.0E-4f;
    }

    public ParticleFog(ClientLevel worldIn, ResourceLocation loc, double xCoordIn, double yCoordIn, double zCoordIn, float scale, double motionX, double motionY, double motionZ, boolean shaders, float r, float g, float b, float a, float thickness, float size) {
        this(worldIn, loc, xCoordIn, yCoordIn, zCoordIn, scale, motionX, motionY, motionZ);
        this.shaders = shaders;
        this.f_107215_ = motionX;
        this.f_107216_ = motionY;
        this.f_107217_ = motionZ;
        this.rgba = new float[]{r, g, b, a};
        this.startmoving = true;
        this.softness = thickness;
        this.sz = size;
        this.agecolor = false;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107434_;
    }

    public void m_5744_(VertexConsumer builder, Camera activeRenderInfo, float partial) {
    }

    public double getDistance(double x1, double y1, double z1) {
        return (x1 - this.f_107212_) * (x1 - this.f_107212_) + (y1 - this.f_107213_) * (y1 - this.f_107213_) + (z1 - this.f_107214_) * (z1 - this.f_107214_);
    }

    public void m_5989_() {
        ++this.f_107224_;
        if ((double)this.f_107208_.f_46441_.m_188501_() < 0.001 || !this.startmoving) {
            this.f_107215_ = this.f_107208_.f_46441_.m_188501_() * 0.01f - 0.005f;
            this.f_107217_ = this.f_107208_.f_46441_.m_188501_() * 0.01f - 0.005f;
            this.startmoving = true;
        }
        if (this.agecolor) {
            this.f_107216_ = 0.0;
        }
        if (this.startmoving) {
            this.f_107209_ = this.f_107212_;
            this.f_107210_ = this.f_107213_;
            this.f_107211_ = this.f_107214_;
            this.f_107212_ += this.f_107215_;
            this.f_107213_ += this.f_107216_;
            this.f_107214_ += this.f_107217_;
        }
        if (this.agecolor) {
            this.rgba[3] = this.f_107224_ < 40 ? (float)this.f_107224_ / 40.0f * 0.5f : (this.f_107224_ > 730 ? (float)(800 - this.f_107224_) / 70.0f * 0.5f : 0.5f);
        }
        if (this.f_107224_ > 800) {
            this.m_107274_();
        }
    }

    public static void renderFog(ParticleFog particle, double d3, double d4, double d5, PoseStack matrix, float partialTicks) {
        FogRenderLayer fog;
        double d0 = particle.f_107209_ + (particle.f_107212_ - particle.f_107209_) * (double)partialTicks;
        double d1 = particle.f_107210_ + (particle.f_107213_ - particle.f_107210_) * (double)partialTicks;
        double d2 = particle.f_107211_ + (particle.f_107214_ - particle.f_107211_) * (double)partialTicks;
        matrix.m_85836_();
        matrix.m_85837_(d0 - d3, d1 - d4, d2 - d5);
        RenderUtils.billboard(matrix, particle.rotation, partialTicks);
        matrix.m_85841_(particle.sz, particle.sz, particle.sz);
        float r = particle.rgba[0];
        float g = particle.rgba[1];
        float b = particle.rgba[2];
        float a = particle.rgba[3];
        int j = 240;
        int k = 240;
        float xx = 0.5f;
        float bxx = -xx;
        float yy = 0.0f;
        MultiBufferSource.BufferSource buf = Minecraft.m_91087_().m_91269_().m_110104_();
        Matrix4f m = matrix.m_85850_().m_252922_();
        if (!MTConfig.NO_SHADERS && ModShaders.FOGGY_QUADS != null) {
            ModShaders.FOGGY_QUADS.smoke(0.07f);
            ModShaders.FOGGY_QUADS.color(particle.rgba[0], particle.rgba[1], particle.rgba[2], particle.rgba[3]);
            ModShaders.FOGGY_QUADS.nearfar(0.07f, 400.0f);
            if (ModShaders.FOGGY_QUADS.f_173308_ != null) {
                ModShaders.FOGGY_QUADS.f_173308_.m_5679_(m);
            }
            if (ModShaders.FOGGY_QUADS.f_173309_ != null) {
                ModShaders.FOGGY_QUADS.f_173309_.m_5679_(RenderSystem.m_253262_());
            }
            fog = new FogRenderLayer(new CullWrappedRenderLayer(MahoujinRenderType.createMahoujinRenderType(new ResourceLocation("mahoutsukai", "textures/particle/fog3.png"), 0, false, () -> ModShaders.FOGGY_QUADS)), particle.rgba, particle.softness);
        } else {
            RenderSystem.m_69478_();
            RenderSystem.m_69456_((int)513);
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69405_((int)770, (int)771);
            fog = new FogRenderLayer(new CullWrappedRenderLayer(MahoujinRenderType.createMahoujinRenderType(new ResourceLocation("mahoutsukai", "textures/particle/fog3.png"), 0, false)), particle.rgba, particle.softness);
        }
        VertexConsumer bb = buf.m_6299_((RenderType)fog);
        bb.m_252986_(m, bxx, yy, bxx).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(j, k).m_5752_();
        bb.m_252986_(m, bxx, yy, xx).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(j, k).m_5752_();
        bb.m_252986_(m, xx, yy, xx).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(j, k).m_5752_();
        bb.m_252986_(m, xx, yy, bxx).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(j, k).m_5752_();
        buf.m_109912_((RenderType)fog);
        matrix.m_85849_();
    }
}

