/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.GlowRenderLayer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.render.shader.ModShaders;

public class ParticleMagic
extends Particle {
    public String loc;
    public float[] rgba = new float[4];
    public float softness = 0.01f;
    public float rotation = 0.0f;
    public float sz = 0.2f;
    public double slow = 0.6;
    public boolean shaders = false;
    public int image;

    public ParticleMagic(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, float scale, double vx, double vy, double vz, String loc, float sz, float r, float g, float b, float a, boolean shaders) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, vx, vy, vz);
        this.f_107215_ = vx;
        this.f_107216_ = vy;
        this.f_107217_ = vz;
        this.f_107228_ = 1.0f;
        this.f_107227_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.f_107230_ = 0.4f;
        float maxAge = 50.0f + sz * 100.0f;
        if (g == 1.0f) {
            maxAge = 25.0f + sz * 10.0f;
        }
        this.f_107225_ = (int)((double)maxAge / (Math.random() * 0.3 + 0.6));
        this.f_107225_ = (int)((float)this.f_107225_ * scale);
        this.rgba[0] = r;
        this.rgba[1] = g;
        this.rgba[2] = b;
        this.rgba[3] = a;
        this.loc = loc;
        this.sz = sz;
        this.image = this.f_107223_.m_188503_(6) + 1;
        this.shaders = shaders;
        this.slow = 0.6;
    }

    public ParticleMagic(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, float scale, double vx, double vy, double vz, String loc, float sz, float r, float g, float b, float a, boolean shaders, double slow) {
        this(worldIn, xCoordIn, yCoordIn, zCoordIn, scale, vx, vy, vz, loc, sz, r, g, b, a, shaders);
        this.slow = slow;
    }

    public ParticleMagic(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, float scale, double vx, double vy, double vz, String loc, float sz, float r, float g, float b, float a, float maxAge) {
        this(worldIn, xCoordIn, yCoordIn, zCoordIn, scale, vx, vy, vz, loc, sz, r, g, b, a, false);
        this.f_107225_ = (int)((double)maxAge / (Math.random() * 0.3 + 0.6));
        this.f_107225_ = (int)((float)this.f_107225_ * scale);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
        this.f_107212_ += this.f_107215_;
        this.f_107213_ += this.f_107216_;
        this.f_107214_ += this.f_107217_;
        this.f_107215_ *= this.slow;
        this.f_107216_ *= this.slow;
        this.f_107217_ *= this.slow;
        this.f_107204_ = this.f_107231_;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107434_;
    }

    public void m_5744_(VertexConsumer builder, Camera activeRenderInfo, float partial) {
    }

    public static void renderMagic(ParticleMagic particle, double d3, double d4, double d5, PoseStack matrix, float partialTicks) {
        double d0 = particle.f_107209_ + (particle.f_107212_ - particle.f_107209_) * (double)partialTicks;
        double d1 = particle.f_107210_ + (particle.f_107213_ - particle.f_107210_) * (double)partialTicks;
        double d2 = particle.f_107211_ + (particle.f_107214_ - particle.f_107211_) * (double)partialTicks;
        matrix.m_85836_();
        matrix.m_85837_(d0 - d3, d1 - d4, d2 - d5);
        Entity e = Minecraft.m_91087_().m_91288_();
        if (e != null) {
            GlowRenderLayer fog;
            float a;
            float yaw = e.f_19859_ + (e.f_19857_ - e.f_19859_) * partialTicks;
            float pitch = e.f_19860_ + (e.f_19858_ - e.f_19860_) * partialTicks;
            RenderUtils.rotateQ(360.0f - yaw, 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(pitch + 90.0f, 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.rotateQ(particle.rotation, 0.0f, 1.0f, 0.0f, matrix);
            matrix.m_85841_(particle.sz, particle.sz, particle.sz);
            float r = particle.rgba[0];
            float g = particle.rgba[1];
            float b = particle.rgba[2];
            particle.rgba[3] = a = 1.0f - (float)particle.f_107224_ / (float)particle.f_107225_;
            int j = 240;
            int k = 240;
            float xx = 0.5f;
            float bxx = -xx;
            float yy = 0.0f;
            MultiBufferSource.BufferSource buf = Minecraft.m_91087_().m_91269_().m_110104_();
            Matrix4f m = matrix.m_85850_().m_252922_();
            ResourceLocation loc = new ResourceLocation("mahoutsukai", particle.loc + particle.image + ".png");
            if (!MTConfig.NO_SHADERS && particle.shaders) {
                ModShaders.FOGGY_QUADS.smoke(0.07f);
                ModShaders.FOGGY_QUADS.color(particle.rgba[0], particle.rgba[1], particle.rgba[2], particle.rgba[3]);
                ModShaders.FOGGY_QUADS.nearfar(0.07f, 400.0f);
                if (ModShaders.FOGGY_QUADS.f_173308_ != null) {
                    ModShaders.FOGGY_QUADS.f_173308_.m_5679_(m);
                }
                if (ModShaders.FOGGY_QUADS.f_173309_ != null) {
                    ModShaders.FOGGY_QUADS.f_173309_.m_5679_(RenderSystem.m_253262_());
                }
                fog = new GlowRenderLayer(new CullWrappedRenderLayer(MahoujinRenderType.createMahoujinRenderType(new ResourceLocation("mahoutsukai", "textures/particle/fog3.png"), 0, false, () -> ModShaders.FOGGY_QUADS)), particle.rgba, particle.softness, particle.shaders);
            } else {
                RenderSystem.m_69478_();
                RenderSystem.m_69405_((int)770, (int)771);
                RenderSystem.m_69456_((int)515);
                RenderSystem.m_69458_((boolean)false);
                RenderSystem.m_157427_(() -> ModShaders.PASSTHROUGH_QUADS);
                fog = new GlowRenderLayer(new CullWrappedRenderLayer(MahoujinRenderType.createMahoujinRenderType(loc, 0, false)), particle.rgba, particle.softness, particle.shaders);
            }
            VertexConsumer bb = buf.m_6299_((RenderType)fog);
            bb.m_252986_(m, bxx, yy, bxx).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(j, k).m_5752_();
            bb.m_252986_(m, bxx, yy, xx).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(j, k).m_5752_();
            bb.m_252986_(m, xx, yy, xx).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(j, k).m_5752_();
            bb.m_252986_(m, xx, yy, bxx).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(j, k).m_5752_();
            buf.m_109912_((RenderType)fog);
        }
        matrix.m_85849_();
    }
}

