/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.block.MahoujinProjector;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.overlay.RenderInterestingBlock;
import stepsword.mahoutsukai.tile.MahoujinProjectorTileEntity;
import stepsword.mahoutsukai.util.ClientImageDownloadUtil;
import stepsword.mahoutsukai.util.EffectUtil;

public class MahoujinProjectorRenderer
implements BlockEntityRenderer<MahoujinProjectorTileEntity> {
    public static int rindex = 0;
    private static final ResourceLocation mahoujin = new ResourceLocation("mahoutsukai:textures/block/mahoujin_casting.png");
    private static final ResourceLocation runes = new ResourceLocation("mahoutsukai:textures/block/runes.png");

    public MahoujinProjectorRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public void render(MahoujinProjectorTileEntity te, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int i, int i1) {
        RenderType type;
        if (te.m_58904_() != null && te.m_58904_().m_46753_(te.m_58899_())) {
            return;
        }
        ItemStack stack = Minecraft.m_91087_().f_91074_.m_21205_();
        if (stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() instanceof MahoujinProjector) {
            RenderInterestingBlock.renderBox(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 220, 220, 10, 255);
        }
        if (rindex == 0x7FFFFFFD) {
            rindex = 0;
        }
        float offsetx = te.getCx();
        float offsety = te.getCy();
        float offsetz = te.getCz();
        float r = (float)te.getCr() / 255.0f;
        float g = (float)te.getCg() / 255.0f;
        float b = (float)te.getCb() / 255.0f;
        float a = (float)te.getCa() / 255.0f;
        float rotation = te.getRotation();
        float yaw = te.getCyaw();
        float pitch = te.getCpitch();
        float speed = te.getCspeed();
        float ring = te.getCringangle();
        float size = te.getCsize();
        yaw = yaw - te.getCyspeed() + te.getCyspeed() * partialTicks;
        pitch = pitch - te.getCpspeed() + te.getCpspeed() * partialTicks;
        rotation = te.getRotationOffset() + (rotation - speed) + speed * partialTicks;
        matrix.m_85836_();
        Matrix4f positionMatrix = matrix.m_85850_().m_252922_();
        float preyaw = te.getCpreyaw();
        float prepitch = te.getCprepitch();
        float orbit = te.getCorbit() - te.getCorbitspeed() + te.getCorbitspeed() * partialTicks;
        matrix.m_85837_(0.5, 0.5, 0.5);
        matrix.m_252781_(Axis.f_252529_.m_252977_(prepitch));
        matrix.m_252781_(Axis.f_252436_.m_252977_(preyaw));
        matrix.m_252781_(Axis.f_252529_.m_252977_(orbit));
        matrix.m_252880_(offsetx, offsety, offsetz);
        matrix.m_252781_(Axis.f_252436_.m_252977_(yaw));
        matrix.m_252781_(Axis.f_252529_.m_252977_(pitch));
        matrix.m_252781_(Axis.f_252436_.m_252977_(rotation));
        int loadImage = te.getImage();
        if (loadImage >= 0) {
            for (int j = 0; j < MTConfig.MAGIC_CIRCLES.size(); ++j) {
                ClientImageDownloadUtil.download("circle" + j, MTConfig.MAGIC_CIRCLES.get(j), false);
            }
            if (loadImage < ClientImageDownloadUtil.lst.size()) {
                try {
                    type = MahoujinRenderType.createMahoujinRenderType(ClientImageDownloadUtil.lst.get(loadImage), 0, false);
                }
                catch (Exception e) {
                    type = MahoujinRenderType.createMahoujinRenderType(mahoujin, 0, false);
                }
            } else {
                type = MahoujinRenderType.createMahoujinRenderType(mahoujin, 0, false);
            }
        } else {
            type = MahoujinRenderType.createMahoujinRenderType(mahoujin, 0, false);
        }
        int lightmapX = 240;
        int lightmapY = 240;
        if (te.getShowCircle()) {
            VertexConsumer builder = buffer.m_6299_(type);
            builder.m_252986_(positionMatrix, -0.5f * size, 0.0f, -0.5f * size).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
            builder.m_252986_(positionMatrix, -0.5f * size, 0.0f, 0.5f * size).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
            builder.m_252986_(positionMatrix, 0.5f * size, 0.0f, 0.5f * size).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
            builder.m_252986_(positionMatrix, 0.5f * size, 0.0f, -0.5f * size).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        }
        matrix.m_85837_(0.0, Math.sin(EffectUtil.toRad(te.getCringangle())) / 2.0 * (double)te.getHeight(), 0.0);
        loadImage = te.getRunes();
        if (te.getShowRing()) {
            if (loadImage >= 0) {
                for (int j = 0; j < MTConfig.MAGIC_RUNES.size(); ++j) {
                    ClientImageDownloadUtil.download("runes" + j, MTConfig.MAGIC_RUNES.get(j), true);
                }
                if (loadImage < ClientImageDownloadUtil.lstRunes.size()) {
                    try {
                        type = MahoujinRenderType.createRunesRenderType(ClientImageDownloadUtil.lstRunes.get(loadImage), rindex++);
                    }
                    catch (Exception e) {
                        type = MahoujinRenderType.createRunesRenderType(runes, rindex++);
                    }
                } else {
                    type = MahoujinRenderType.createRunesRenderType(runes, rindex++);
                }
            } else {
                type = MahoujinRenderType.createRunesRenderType(runes, rindex++);
            }
            MahoujinProjectorRenderer.renderRing(positionMatrix, 0.0, ring, size / 2.0f + 0.125f, te.getHeight(), 128, buffer, lightmapX, lightmapY, r, g, b, a, type);
        }
        matrix.m_85849_();
    }

    public static void renderRing(Matrix4f matrix4f, double cy, float flatness, float radius, float height, int num_segments, MultiBufferSource buf, int lx, int ly, float r, float g, float b, float a, RenderType rt) {
        double theta = 6.2831852 / (double)num_segments;
        double q = (double)height * Math.sin(EffectUtil.toRad(flatness));
        double p = (double)radius + (double)height * Math.cos(EffectUtil.toRad(flatness));
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double xb = 0.0;
        double yb = 0.0;
        double zb = 0.0;
        VertexConsumer buffer = buf.m_6299_(rt);
        float squeeze = 3.0f;
        float texx = 0.0f;
        for (int i = 0; i < num_segments + 1; ++i) {
            if ((texx += squeeze * 1.0f / (float)(num_segments + 1)) >= 1.0f) {
                texx = squeeze * 1.0f / (float)(num_segments + 1);
                buffer.m_252986_(matrix4f, (float)x, (float)y, (float)z).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
                buffer.m_252986_(matrix4f, (float)xb, (float)yb, (float)zb).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lx, ly).m_5752_();
            }
            double tt = (double)i * theta;
            x = (double)(-radius) * Math.sin(tt);
            y = cy;
            z = (double)radius * Math.cos(tt);
            xb = -p * Math.sin(tt);
            yb = cy - q;
            zb = p * Math.cos(tt);
            buffer.m_252986_(matrix4f, (float)x, (float)y, (float)z).m_85950_(r, g, b, a).m_7421_(texx, 0.0f).m_7120_(lx, ly).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix4f, (float)xb, (float)yb, (float)zb).m_85950_(r, g, b, a).m_7421_(texx, 1.0f).m_7120_(lx, ly).m_85950_(r, g, b, a).m_5752_();
        }
    }

    public static void cacheClear() {
        ClientImageDownloadUtil.lstRunes = new ArrayList();
        ClientImageDownloadUtil.lst = new ArrayList();
    }

    public boolean shouldRenderOffScreen(MahoujinProjectorTileEntity te) {
        return true;
    }

    public int m_142163_() {
        return 250000;
    }
}

