/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.displacement;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.kodoku.KodokuItem;
import stepsword.mahoutsukai.networking.DataManagerPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.ScryingEntityPacket;
import stepsword.mahoutsukai.potion.MisfortunePotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.proxy.CommonProxy;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;
import stepsword.mahoutsukai.util.Utils;

public class ScryingMahoujinTileEntity
extends MahoujinTileEntity
implements BlockEntityTicker<ScryingMahoujinTileEntity> {
    public LivingEntity scryTarget = null;
    public CompoundTag scryNBT = null;
    private float yaw = 0.0f;
    private float hyaw = 0.0f;
    private float ryaw = 0.0f;
    private float pitch = 0.0f;
    private float pyaw = 0.0f;
    private float phyaw = 0.0f;
    private float pryaw = 0.0f;
    private float ppitch = 0.0f;
    private double velx = 0.0;
    private double vely = 0.0;
    private double velz = 0.0;
    public Vec3 targetPos = null;
    public float prevSwingProgress = 0.0f;
    public float swingProgress = 0.0f;
    private UUID scryUniqueID = null;
    public float limbSwingAmount = 0.0f;
    public float prevLimbSwingAmount = 0.0f;
    public float limbSwing = 0.0f;
    public ArrayList<BlockPosInfo> lst = null;
    public List<SynchedEntityData.DataValue<?>> scryDataManager = null;
    private int tickCounter = 0;
    private int scryTimer = 0;
    private String viewTarget = "";
    private String VIEW_TARGET = "MAHOUTSUKAI_VIEW_TARGET";
    private String SCRY_RENDER_YAW = "MAHOUTSUKAI_RENDER_YAW";
    private String SCRY_YAW = "MAHOUTSUKAI_YAW";
    private String SCRY_HEAD_YAW = "MAHOUTSUKAI_HYAW";
    private String SCRY_PITCH = "MAHOUTSUKAI_PITCH";
    private String SCRY_VEL_X = "MAHOUTSUKAI_VEL_X";
    private String SCRY_VEL_Y = "MAHOUTSUKAI_VEL_Y";
    private String SCRY_VEL_Z = "MAHOUTSUKAI_VEL_Z";
    private String SCRY_UNIQ = "MAHOUTSUKAI_SCRY_UNIQ";
    private String LIMB_SWING = "MAHOUTSUKAI_LS";
    private String LIMB_SWING_AMOUNT = "MAHOUTSUKAI_LSA";
    private String LIMB_SWING_PROGRESS = "MAHOUTSUKAI_LSP";
    private String SCRY_LOC_X = "MAHOUTSUKAI_LOC_X";
    private String SCRY_LOC_Y = "MAHOUTSUKAI_LOC_Y";
    private String SCRY_LOC_Z = "MAHOUTSUKAI_LOC_Z";
    private String SCRY_BLOCK = "MAHOUTSUKAI_BLOCK_";
    public boolean doRead = false;

    public ScryingMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.scrying.get(), p, bs);
    }

    public LivingEntity getScryTarget() {
        return this.scryTarget;
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        compound.m_128359_(this.VIEW_TARGET, this.viewTarget);
        if (this.scryTarget != null) {
            compound.m_128350_(this.SCRY_PITCH, this.scryTarget.m_146909_());
            compound.m_128350_(this.SCRY_YAW, this.scryTarget.m_146908_());
            compound.m_128350_(this.SCRY_HEAD_YAW, this.scryTarget.f_20885_);
            compound.m_128350_(this.SCRY_RENDER_YAW, this.scryTarget.f_20883_);
            compound.m_128350_(this.SCRY_RENDER_YAW, this.scryTarget.f_20883_);
            compound.m_128350_(this.LIMB_SWING, this.scryTarget.f_20925_);
            compound.m_128350_(this.LIMB_SWING_AMOUNT, this.scryTarget.f_20924_);
            compound.m_128350_(this.LIMB_SWING_PROGRESS, this.scryTarget.f_20921_);
            Vec3 epos = this.scryTarget.m_20182_();
            Vec3 emot = this.scryTarget.m_20184_();
            compound.m_128347_(this.SCRY_VEL_X, emot.f_82479_);
            compound.m_128347_(this.SCRY_VEL_Y, emot.f_82480_);
            compound.m_128347_(this.SCRY_VEL_Z, emot.f_82481_);
            compound.m_128347_(this.SCRY_LOC_X, epos.f_82479_);
            compound.m_128347_(this.SCRY_LOC_Y, epos.f_82480_);
            compound.m_128347_(this.SCRY_LOC_Z, epos.f_82481_);
            compound.m_128362_(this.SCRY_UNIQ, this.scryTarget.m_20148_());
            int index = 0;
            int i = (int)Math.floor(epos.f_82479_ - 1.0);
            while ((double)i <= epos.f_82479_ + 1.0) {
                int j = (int)Math.floor(epos.f_82481_ - 1.0);
                while ((double)j <= epos.f_82481_ + 1.0) {
                    int k = (int)Math.floor(epos.f_82480_ - 1.0);
                    while ((double)k <= epos.f_82480_ + 2.0) {
                        BlockPos p = new BlockPos(i, k, j);
                        BlockPosInfo info = new BlockPosInfo(p, this.f_58857_);
                        CompoundTag infonbt = info.write();
                        compound.m_128365_(this.SCRY_BLOCK + index, (Tag)infonbt);
                        ++index;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            CompoundTag compoundTag = new CompoundTag();
        }
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.viewTarget = compound.m_128461_(this.VIEW_TARGET);
        if (compound.m_128441_(this.SCRY_YAW)) {
            this.yaw = compound.m_128457_(this.SCRY_YAW);
        }
        if (compound.m_128441_(this.SCRY_PITCH)) {
            this.pitch = compound.m_128457_(this.SCRY_PITCH);
        }
        if (compound.m_128441_(this.SCRY_HEAD_YAW)) {
            this.hyaw = compound.m_128457_(this.SCRY_HEAD_YAW);
        }
        if (compound.m_128441_(this.SCRY_RENDER_YAW)) {
            this.ryaw = compound.m_128457_(this.SCRY_RENDER_YAW);
        }
        if (compound.m_128441_(this.LIMB_SWING)) {
            this.limbSwing = compound.m_128457_(this.LIMB_SWING);
        }
        if (compound.m_128441_(this.LIMB_SWING_AMOUNT)) {
            this.limbSwingAmount = compound.m_128457_(this.LIMB_SWING_AMOUNT);
        }
        if (compound.m_128441_(this.LIMB_SWING_PROGRESS)) {
            this.swingProgress = compound.m_128457_(this.LIMB_SWING_PROGRESS);
        }
        if (compound.m_128441_(this.SCRY_VEL_X)) {
            this.velx = compound.m_128459_(this.SCRY_VEL_X);
        }
        if (compound.m_128441_(this.SCRY_VEL_Y)) {
            this.vely = compound.m_128459_(this.SCRY_VEL_Y);
        }
        if (compound.m_128441_(this.SCRY_VEL_Z)) {
            this.velz = compound.m_128459_(this.SCRY_VEL_Z);
        }
        if (compound.m_128403_(this.SCRY_UNIQ)) {
            this.scryUniqueID = compound.m_128342_(this.SCRY_UNIQ);
        }
        int index = 0;
        this.lst = new ArrayList();
        while (compound.m_128441_(this.SCRY_BLOCK + index)) {
            BlockPosInfo info = new BlockPosInfo();
            info.read(compound.m_128469_(this.SCRY_BLOCK + index), this.f_58857_);
            this.lst.add(info);
            ++index;
        }
        if (compound.m_128441_(this.SCRY_LOC_X) && compound.m_128441_(this.SCRY_LOC_Y) && compound.m_128441_(this.SCRY_LOC_X)) {
            this.targetPos = new Vec3(compound.m_128459_(this.SCRY_LOC_X), compound.m_128459_(this.SCRY_LOC_Y), compound.m_128459_(this.SCRY_LOC_Z));
        }
        this.doRead = true;
        super.m_142466_(compound);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, ScryingMahoujinTileEntity blockEntity) {
        if (!level.f_46443_) {
            if (this.scryTimer >= MTConfig.SCRYING_DURATION) {
                this.viewTarget = "";
                this.scryTarget = null;
                this.sendUpdates();
            }
            if (this.tickCounter == MTConfig.SCRYING_BLOCK_CYCLE) {
                boolean changedName = false;
                List lst = level.m_45976_(Entity.class, new AABB((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (double)(this.f_58858_.m_123341_() + 1), (double)(this.f_58858_.m_123342_() + 1), (double)(this.f_58858_.m_123343_() + 1)));
                if (!lst.isEmpty()) {
                    Player caster = this.getCaster();
                    Entity entityIn = (Entity)lst.get(0);
                    if (entityIn instanceof ItemEntity) {
                        boolean nearbyBatteriesGaveMana;
                        if (((ItemEntity)entityIn).m_32055_().m_41720_() == Items.f_42656_ && ((nearbyBatteriesGaveMana = PlayerManaManager.getManaFromBatteriesFirst(this.f_58858_, level, this.getCasterUUID(), MTConfig.SCRYING_MANA_COST)) || caster != null && PlayerManaManager.drainMana(caster, MTConfig.SCRYING_MANA_COST, false, false) == MTConfig.SCRYING_MANA_COST)) {
                            String s = ((ItemEntity)entityIn).m_32055_().m_41786_().getString();
                            this.viewTarget = s != null ? s : "";
                            this.scryTimer = 0;
                            changedName = true;
                            this.sendUpdates();
                            entityIn.m_146870_();
                        }
                        this.sympathetic((ItemEntity)entityIn);
                    }
                }
                if (this.scryTarget == null || !this.scryTarget.m_6084_() || changedName || this.doRead) {
                    if (this.viewTarget != null && !this.viewTarget.equals("")) {
                        Player e = ScryingMahoujinTileEntity.getPlayerByName(this.viewTarget, level);
                        if (e == null) {
                            HashSet<Entity> loaded = CommonProxy.getAllEntities((ServerLevel)level);
                            this.scryTarget = null;
                            if (loaded != null) {
                                for (Entity entity2 : loaded) {
                                    if (entity2.m_7770_() == null || !entity2.m_7770_().getString().equals(this.viewTarget) || !(entity2 instanceof LivingEntity)) continue;
                                    this.scryTarget = (LivingEntity)entity2;
                                    this.sendUpdates();
                                    break;
                                }
                                if (this.scryTarget == null) {
                                    for (Entity entity2 : loaded) {
                                        if (!entity2.m_5446_().getString().equals(this.viewTarget) || !(entity2 instanceof LivingEntity)) continue;
                                        this.scryTarget = (LivingEntity)entity2;
                                        this.sendUpdates();
                                        break;
                                    }
                                }
                            }
                        } else {
                            this.scryTarget = e;
                            this.sendUpdates();
                        }
                    }
                    if (this.scryTarget != null && !this.scryTarget.m_6084_()) {
                        this.scryTarget = null;
                        this.sendUpdates();
                    }
                    this.doRead = false;
                }
                if (this.scryTarget != null && this.scryTarget.m_6084_()) {
                    boolean checkDirty = this.scryDataManager != null;
                    List<SynchedEntityData.DataValue<?>> entries = this.getAll(this.scryTarget.m_20088_(), checkDirty);
                    if (entries != null) {
                        ArrayList entriesCopy = new ArrayList(entries);
                        ArrayList toSend = new ArrayList(entriesCopy);
                        this.scryDataManager = entriesCopy;
                        if (toSend.size() > 0) {
                            int r = 32;
                            AABB aabb = new AABB((double)(this.f_58858_.m_123341_() - r), (double)(this.f_58858_.m_123342_() - r), (double)(this.f_58858_.m_123343_() - r), (double)(this.f_58858_.m_123341_() + r), (double)(this.f_58858_.m_123342_() + r), (double)(this.f_58858_.m_123343_() + r));
                            List players = level.m_45976_(ServerPlayer.class, aabb);
                            for (ServerPlayer player : players) {
                                PacketHandler.sendTo(player, new DataManagerPacket(this.f_58858_, toSend));
                            }
                        }
                    }
                    this.scryNBT = new CompoundTag();
                    this.scryTarget.m_20086_(this.scryNBT);
                    this.sendUpdates();
                }
                this.tickCounter = 0;
            }
            ++this.scryTimer;
            ++this.tickCounter;
        }
        if (this.doRead && level != null && level.f_46443_ && this.scryNBT != null) {
            EntityType zz = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(this.scryNBT.m_128461_("id")));
            if (this.scryNBT != null && zz != null && zz == EntityType.f_20532_) {
                this.scryTarget = MahouTsukaiMod.proxy.getPlayerForScry(level, this.viewTarget, this.scryNBT, this.scryUniqueID);
            } else if (this.scryNBT != null && !this.scryNBT.m_128456_()) {
                try {
                    EntityType.m_20642_((CompoundTag)this.scryNBT, (Level)level).ifPresent(entity -> {
                        this.scryTarget = (LivingEntity)entity;
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.doRead = false;
        }
        if (level != null && level.f_46443_ && this.scryTarget != null) {
            this.scryTarget.f_20885_ = this.hyaw;
            this.scryTarget.f_20886_ = this.phyaw;
            this.scryTarget.m_146922_(this.yaw);
            this.scryTarget.f_19859_ = this.pyaw;
            this.scryTarget.m_146926_(this.pitch);
            this.scryTarget.f_19860_ = this.ppitch;
            this.scryTarget.f_20883_ = this.ryaw;
            this.scryTarget.f_20884_ = this.pryaw;
            this.scryTarget.m_20256_(new Vec3(this.velx, this.vely, this.velz));
            this.scryTarget.f_20925_ = this.limbSwing;
            this.scryTarget.f_20924_ = this.limbSwingAmount;
            this.scryTarget.f_20923_ = this.prevLimbSwingAmount;
            this.scryTarget.f_20921_ = this.swingProgress;
            this.scryTarget.f_20920_ = this.prevSwingProgress;
            this.scryTarget.m_6034_(this.targetPos.f_82479_, this.targetPos.f_82480_, this.targetPos.f_82481_);
            this.prevLimbSwingAmount = this.scryTarget.f_20924_;
            this.prevSwingProgress = this.scryTarget.f_20921_;
            this.pyaw = this.scryTarget.m_146908_();
            this.pryaw = this.scryTarget.f_20883_;
            this.ppitch = this.scryTarget.m_146909_();
            this.phyaw = this.scryTarget.f_20885_;
            if (this.scryDataManager != null) {
                try {
                    this.scryTarget.m_20088_().m_135356_(this.scryDataManager);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public List<SynchedEntityData.DataValue<?>> getAll(SynchedEntityData data, boolean checkDirty) {
        ArrayList<SynchedEntityData.DataValue> list = null;
        if (data.m_135352_() || !checkDirty) {
            data.f_135346_.readLock().lock();
            for (SynchedEntityData.DataItem dataitem : data.f_135345_.values()) {
                if (!dataitem.m_135406_() && checkDirty) continue;
                dataitem.m_135401_(false);
                if (list == null) {
                    list = new ArrayList<SynchedEntityData.DataValue>();
                }
                list.add(dataitem.m_253123_());
            }
            data.f_135346_.readLock().unlock();
        }
        return list;
    }

    public static Player getPlayerByName(String name, Level world) {
        Player ret = null;
        if (world != null) {
            for (Player p : world.m_6907_()) {
                if (!p.m_7755_().getString().equals(name)) continue;
                ret = p;
            }
        }
        return ret;
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void sympathetic(ItemEntity e) {
        IItemHandler inventory;
        BlockEntity down;
        double firechance = MTConfig.KODOKU_FIRE_CHANCE;
        double splashchance = MTConfig.KODOKU_SPLASH_CHANCE;
        double hungerchance = MTConfig.KODOKU_HUNGER_CHANCE;
        double hopchance = MTConfig.KODOKU_HOP_CHANCE;
        double glowchance = MTConfig.KODOKU_GLOW_CHANCE;
        double telechance = MTConfig.KODOKU_TELEPORT_CHANCE;
        double confusechance = MTConfig.KODOKU_CONFUSE_CHANCE;
        if (this.scryTarget != null && this.scryTarget.m_6084_() && this.f_58857_ != null && (down = this.f_58857_.m_7702_(this.f_58858_.m_121945_(Direction.DOWN))) != null && (inventory = Utils.getInventory(down)) != null) {
            int kodoku = 0;
            int targetkodoku = MisfortunePotion.getMaxKodoku(this.scryTarget);
            ItemStack s = null;
            for (int i = 0; i < inventory.getSlots(); ++i) {
                s = inventory.getStackInSlot(i);
                if (!(s.m_41720_() instanceof KodokuItem)) continue;
                kodoku = KodokuItem.getKodoku(s);
                break;
            }
            LivingEntity realTarget = this.scryTarget;
            if (targetkodoku > kodoku * 2) {
                realTarget = this.getCaster();
            } else {
                kodoku -= targetkodoku;
            }
            if (kodoku > 0 && s != null) {
                boolean success = false;
                boolean consume = false;
                boolean actualconsume = false;
                if (this.getCaster() != null) {
                    if (e.m_32055_().m_41720_() == Items.f_42593_) {
                        if (this.getCaster().m_217043_().m_188500_() < firechance * (double)kodoku) {
                            realTarget.m_20254_(7);
                            success = true;
                        }
                        consume = true;
                        actualconsume = true;
                    } else if (e.m_32055_().m_41720_() instanceof SplashPotionItem) {
                        if (this.getCaster().m_217043_().m_188500_() < splashchance * (double)kodoku) {
                            ItemStack pot = e.m_32055_().m_41620_(1);
                            ThrownPotion entitypotion = new ThrownPotion(this.f_58857_, realTarget.m_20185_(), realTarget.m_20186_(), realTarget.m_20189_());
                            entitypotion.m_37446_(pot);
                            this.f_58857_.m_7967_((Entity)entitypotion);
                            success = true;
                        }
                        consume = true;
                    } else if (e.m_32055_().m_41720_() == Items.f_42583_) {
                        if (realTarget instanceof Player) {
                            if (this.getCaster().m_217043_().m_188500_() < hungerchance * (double)kodoku) {
                                ((Player)realTarget).m_36324_().m_38705_(Math.max(((Player)realTarget).m_36324_().m_38702_() - 5, 0));
                                success = true;
                            }
                            consume = true;
                            actualconsume = true;
                        }
                    } else if (e.m_32055_().m_41720_() == Items.f_42648_) {
                        if (this.getCaster().m_217043_().m_188500_() < hopchance * (double)kodoku) {
                            realTarget.m_20334_(realTarget.m_20184_().f_82479_, (double)1.1f, realTarget.m_20184_().f_82481_);
                            realTarget.f_19864_ = true;
                            realTarget.f_19812_ = true;
                            success = true;
                        }
                        actualconsume = true;
                        consume = true;
                    } else if (e.m_32055_().m_41720_() == ModItems.kodoku.get()) {
                        if (KodokuItem.getKodoku(e.m_32055_()) > 0) {
                            EffectUtil.buff(realTarget, ModEffects.MISFORTUNE, true, 600, KodokuItem.getKodoku(e.m_32055_()));
                            success = true;
                        }
                        consume = true;
                        actualconsume = true;
                    } else if (e.m_32055_().m_41720_() == Items.f_42525_) {
                        if (this.getCaster().m_217043_().m_188500_() < glowchance * (double)kodoku) {
                            EffectUtil.buff(realTarget, MobEffects.f_19619_, true, 600);
                            success = true;
                        }
                        actualconsume = true;
                        consume = true;
                    } else if (e.m_32055_().m_41720_() == Items.f_42584_) {
                        if (this.getCaster().m_217043_().m_188500_() < telechance * (double)kodoku) {
                            if (!(realTarget instanceof Player) || ContractMahoujinTileEntity.isImmuneToSpell(realTarget.f_19853_, this.getCasterUUID(), (Entity)realTarget)) {
                                MahouTsukaiTeleporter.teleport((Entity)realTarget, (double)this.f_58858_.m_123341_() + 0.5, this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_() + 0.5, EffectUtil.getDimension(this.getCaster().f_19853_));
                                success = true;
                            } else {
                                this.getCaster().m_5661_((Component)Component.m_237115_((String)"mahoutsukai.teleport_kodoku.failed"), true);
                                success = true;
                            }
                        }
                        actualconsume = true;
                        consume = true;
                    } else if (e.m_32055_().m_41720_() == Items.f_42588_) {
                        if (this.getCaster().m_217043_().m_188500_() < confusechance * (double)kodoku) {
                            EffectUtil.buff(realTarget, ModEffects.CONFUSION, true, 240);
                            success = true;
                        }
                        consume = true;
                        actualconsume = true;
                    }
                    if (!success && consume) {
                        this.getCaster().m_5661_((Component)Component.m_237115_((String)"mahoutsukai.kodoku.failed"), true);
                    }
                    if (success) {
                        ModTriggers.KODOKU.trigger((ServerPlayer)this.getCaster());
                    }
                    if (actualconsume) {
                        e.m_32055_().m_41774_(1);
                        s.m_41774_(1);
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        if (this.scryTarget != null) {
            CompoundTag nbt = new CompoundTag();
            EntityType entitytype = this.scryTarget.m_6095_();
            ResourceLocation resourcelocation = EntityType.m_20613_((EntityType)entitytype);
            nbt.m_128359_("id", resourcelocation.toString());
            HashSet<String> toRemove = new HashSet<String>();
            this.scryTarget.m_20240_(nbt);
            for (String key : nbt.m_128431_()) {
                Tag zz = nbt.m_128423_(key);
                if (zz != null && zz.toString().length() > 15000) {
                    toRemove.add(key);
                }
                if (!key.equals("ForgeCaps")) continue;
                toRemove.add(key);
            }
            for (String key : toRemove) {
                nbt.m_128473_(key);
            }
            PacketHandler.sendTrackingBlock(this.m_58899_(), this.f_58857_, new ScryingEntityPacket(this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_(), nbt));
        } else {
            PacketHandler.sendTrackingBlock(this.m_58899_(), this.f_58857_, new ScryingEntityPacket(this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_(), null));
        }
        return super.getUpdatePacket();
    }

    public class BlockPosInfo {
        public BlockState state;
        public BlockEntity te;

        public BlockPosInfo(BlockPos pos, Level world) {
            this.state = world.m_8055_(pos);
            this.te = null;
        }

        public BlockPosInfo() {
            this.state = null;
            this.te = null;
        }

        public CompoundTag write() {
            if (this.state.m_60734_() == Blocks.f_50016_) {
                return new CompoundTag();
            }
            CompoundTag nbt = new CompoundTag();
            CompoundTag nbts = new CompoundTag();
            CompoundTag nbtte = new CompoundTag();
            if (this.state != null) {
                nbts = NbtUtils.m_129202_((BlockState)this.state);
                nbt.m_128365_("SCRY_STATE", (Tag)nbts);
            }
            return nbt;
        }

        public void read(CompoundTag nbt, Level level) {
            if (nbt.m_128441_("SCRY_STATE")) {
                this.state = NbtUtils.m_247651_((HolderGetter)level.m_246945_(Registries.f_256747_), (CompoundTag)nbt.m_128469_("SCRY_STATE"));
            }
        }
    }
}

