/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod;

import baguchan.earthmobsmod.EarthMobsMod;
import baguchan.earthmobsmod.block.CarvedMelonBlock;
import baguchan.earthmobsmod.capability.ShadowCapability;
import baguchan.earthmobsmod.entity.BoulderingDrowned;
import baguchan.earthmobsmod.entity.BoulderingZombie;
import baguchan.earthmobsmod.entity.LobberDrowned;
import baguchan.earthmobsmod.entity.LobberZombie;
import baguchan.earthmobsmod.entity.ZombifiedPig;
import baguchan.earthmobsmod.registry.ModBlocks;
import baguchan.earthmobsmod.registry.ModEntities;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="earthmobsmod")
public class CommonEvents {
    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(ShadowCapability.class);
    }

    @SubscribeEvent
    public void onEntityJoinWorld(LivingSpawnEvent.SpecialSpawn event) {
        Mob mob = event.getEntity();
        if (mob instanceof AbstractVillager) {
            AbstractVillager villager = (AbstractVillager)mob;
            villager.f_21346_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, BoulderingDrowned.class, 8.0f, 0.8, 0.6));
            villager.f_21346_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, BoulderingZombie.class, 8.0f, 0.8, 0.6));
            villager.f_21346_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, LobberDrowned.class, 8.0f, 0.8, 0.6));
            villager.f_21346_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, LobberZombie.class, 8.0f, 0.8, 0.6));
        }
    }

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("earthmobsmod", "shadow"), (ICapabilityProvider)new ShadowCapability());
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Direction direction;
        ItemStack itemStack = event.getEntity().m_21120_(event.getHand());
        if (itemStack.m_41720_() instanceof ShearsItem && event.getEntity().f_19853_.m_8055_(event.getPos()).m_60734_() == Blocks.f_50186_ && (direction = event.getHitVec().m_82434_()) != Direction.DOWN && direction != Direction.UP) {
            itemStack.m_41622_(1, (LivingEntity)event.getEntity(), p_29910_ -> p_29910_.m_21190_(event.getHand()));
            event.getEntity().f_19853_.m_5594_(null, event.getPos(), SoundEvents.f_12296_, SoundSource.BLOCKS, 1.0f, 1.0f);
            event.getEntity().f_19853_.m_7731_(event.getPos(), (BlockState)((Block)ModBlocks.CARVED_MELON.get()).m_49966_().m_61124_((Property)CarvedMelonBlock.FACING, (Comparable)direction), 2);
            event.setUseItem(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onUpdate(LivingEvent.LivingTickEvent event) {
        event.getEntity().getCapability(EarthMobsMod.SHADOW_CAP).ifPresent(shadowCapability -> shadowCapability.tick(event.getEntity()));
    }

    @SubscribeEvent
    public static void onLightning(EntityStruckByLightningEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Pig) {
            Pig pig = (Pig)entity;
            if (event.getEntity().m_6095_() != ModEntities.ZOMBIFIED_PIG.get()) {
                ZombifiedPig zombifiedpig = (ZombifiedPig)((EntityType)ModEntities.ZOMBIFIED_PIG.get()).m_20615_(event.getEntity().m_9236_());
                zombifiedpig.m_7678_(pig.m_20185_(), pig.m_20186_(), pig.m_20189_(), pig.m_146908_(), pig.m_146909_());
                zombifiedpig.m_21557_(pig.m_21525_());
                zombifiedpig.m_6863_(pig.m_6162_());
                if (pig.m_8077_()) {
                    zombifiedpig.m_6593_(pig.m_7770_());
                    zombifiedpig.m_20340_(pig.m_20151_());
                }
                zombifiedpig.m_21530_();
                ForgeEventFactory.onLivingConvert((LivingEntity)pig, (LivingEntity)zombifiedpig);
                event.getEntity().m_9236_().m_7967_((Entity)zombifiedpig);
                pig.m_146870_();
                event.setCanceled(true);
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        event.getEntity().getCapability(EarthMobsMod.SHADOW_CAP).ifPresent(shadowCapability -> {
            if (shadowCapability.getPercentBoost() >= 0.5f && !event.getSource().m_19384_() && !event.getSource().m_19372_() && !event.getSource().m_19376_()) {
                event.setAmount(event.getAmount() * (1.0f - shadowCapability.getPercentBoost()));
                if (shadowCapability.getPercentBoost() > 0.9f) {
                    event.setCanceled(true);
                }
            }
        });
    }

    @SubscribeEvent
    public static void onLivingKnockback(LivingKnockBackEvent event) {
        event.getEntity().getCapability(EarthMobsMod.SHADOW_CAP).ifPresent(shadowCapability -> {
            if (shadowCapability.getPercentBoost() >= 0.5f) {
                event.setCanceled(true);
            }
        });
    }
}

