/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client.render;

import baguchan.earthmobsmod.entity.TropicalSlime;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ColorableHierarchicalModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.TropicalFishModelA;
import net.minecraft.client.model.TropicalFishModelB;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SlimeOuterLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TropicalSlimeRenderer
extends MobRenderer<Slime, SlimeModel<Slime>> {
    private static final ResourceLocation SLIME_LOCATION = new ResourceLocation("earthmobsmod", "textures/entity/tropical_slime/tropical_slime.png");
    private static final ResourceLocation[] BASE_TEXTURE_LOCATIONS = new ResourceLocation[]{new ResourceLocation("textures/entity/fish/tropical_a.png"), new ResourceLocation("textures/entity/fish/tropical_b.png")};
    private static final ResourceLocation[] PATTERN_A_TEXTURE_LOCATIONS = new ResourceLocation[]{new ResourceLocation("textures/entity/fish/tropical_a_pattern_1.png"), new ResourceLocation("textures/entity/fish/tropical_a_pattern_2.png"), new ResourceLocation("textures/entity/fish/tropical_a_pattern_3.png"), new ResourceLocation("textures/entity/fish/tropical_a_pattern_4.png"), new ResourceLocation("textures/entity/fish/tropical_a_pattern_5.png"), new ResourceLocation("textures/entity/fish/tropical_a_pattern_6.png")};
    private static final ResourceLocation[] PATTERN_B_TEXTURE_LOCATIONS = new ResourceLocation[]{new ResourceLocation("textures/entity/fish/tropical_b_pattern_1.png"), new ResourceLocation("textures/entity/fish/tropical_b_pattern_2.png"), new ResourceLocation("textures/entity/fish/tropical_b_pattern_3.png"), new ResourceLocation("textures/entity/fish/tropical_b_pattern_4.png"), new ResourceLocation("textures/entity/fish/tropical_b_pattern_5.png"), new ResourceLocation("textures/entity/fish/tropical_b_pattern_6.png")};
    private final ColorableHierarchicalModel modelA;
    private final ColorableHierarchicalModel modelB;
    private final ColorableHierarchicalModel patternModelA;
    private final ColorableHierarchicalModel patternModelB;

    public TropicalSlimeRenderer(EntityRendererProvider.Context p_174391_) {
        super(p_174391_, (EntityModel)new SlimeModel(p_174391_.m_174023_(ModelLayers.f_171241_)), 0.25f);
        this.m_115326_((RenderLayer)new SlimeOuterLayer((RenderLayerParent)this, p_174391_.m_174027_()));
        this.modelA = new TropicalFishModelA(p_174391_.m_174023_(ModelLayers.f_171258_));
        this.modelB = new TropicalFishModelB(p_174391_.m_174023_(ModelLayers.f_171256_));
        this.patternModelA = new TropicalFishModelA(p_174391_.m_174023_(ModelLayers.f_171259_));
        this.patternModelB = new TropicalFishModelB(p_174391_.m_174023_(ModelLayers.f_171257_));
    }

    public void render(Slime p_115976_, float p_115977_, float p_115978_, PoseStack p_115979_, MultiBufferSource p_115980_, int p_115981_) {
        this.f_114477_ = 0.25f * (float)p_115976_.m_33632_();
        super.m_7392_((Mob)p_115976_, p_115977_, p_115978_, p_115979_, p_115980_, p_115981_);
        if (p_115976_ instanceof TropicalSlime) {
            this.renderFish((TropicalSlime)p_115976_, p_115978_, p_115979_, p_115980_, p_115981_);
        }
    }

    public static int getBaseVariant(int p_30059_) {
        return Math.min(p_30059_ & 0xFF, 1);
    }

    private static int getBaseColorIdx(int p_30061_) {
        return (p_30061_ & 0xFF0000) >> 16;
    }

    public float[] getBaseColor(int variant) {
        return DyeColor.m_41053_((int)TropicalSlimeRenderer.getBaseColorIdx(variant)).m_41068_();
    }

    private static int getPatternColorIdx(int p_30063_) {
        return (p_30063_ & 0xFF000000) >> 24;
    }

    public float[] getPatternColor(int variant) {
        return DyeColor.m_41053_((int)TropicalSlimeRenderer.getPatternColorIdx(variant)).m_41068_();
    }

    public ResourceLocation getPatternTextureLocation(int variant) {
        return TropicalSlimeRenderer.getBaseVariant(variant) == 0 ? PATTERN_A_TEXTURE_LOCATIONS[TropicalSlimeRenderer.getPatternVariant(variant)] : PATTERN_B_TEXTURE_LOCATIONS[TropicalSlimeRenderer.getPatternVariant(variant)];
    }

    public ResourceLocation getBaseTextureLocation(int variant) {
        return BASE_TEXTURE_LOCATIONS[TropicalSlimeRenderer.getBaseVariant(variant)];
    }

    private static int getPatternVariant(int p_30065_) {
        return Math.min((p_30065_ & 0xFF00) >> 8, 5);
    }

    public void renderFish(TropicalSlime parent, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        CompoundTag compoundTag = parent.getFishData();
        int i = parent.m_33632_();
        ListTag listTag = (ListTag)compoundTag.m_128423_("FishList");
        if (compoundTag != null && listTag != null && !listTag.isEmpty()) {
            float f = (float)i / 3.0f;
            for (int l = 0; l < listTag.size(); ++l) {
                float f1 = ((float)(l % 2) - 0.5f) * f;
                float f2 = ((float)(l / 2) - 0.5f) * f;
                int variant = ((CompoundTag)listTag.get(l)).m_128451_("FishVariant");
                ColorableHierarchicalModel basemodel = TropicalSlimeRenderer.getBaseVariant(((CompoundTag)listTag.get(l)).m_128451_("FishVariant")) == 0 ? this.modelA : this.modelB;
                ColorableHierarchicalModel patternModel = TropicalSlimeRenderer.getPatternVariant(((CompoundTag)listTag.get(l)).m_128451_("FishVariant")) == 0 ? this.patternModelA : this.patternModelB;
                double fishInX = Mth.m_14139_((double)partialTicks, (double)(parent.f_19790_ + (double)f1), (double)(parent.m_20185_() + (double)f1)) - Mth.m_14139_((double)partialTicks, (double)parent.f_19790_, (double)parent.m_20185_());
                double fishInY = parent.m_20186_() + 1.0 + (double)((float)parent.m_33632_() * 0.5f) - parent.m_20186_();
                double fishInZ = Mth.m_14139_((double)partialTicks, (double)(parent.f_19792_ + (double)f2), (double)(parent.m_20189_() + (double)f2)) - Mth.m_14139_((double)partialTicks, (double)parent.f_19792_, (double)parent.m_20189_());
                stack.m_85836_();
                VertexConsumer vertexConsumer = buffer.m_6299_(basemodel.m_103119_(this.getBaseTextureLocation(variant)));
                float[] afloat = this.getBaseColor(variant);
                basemodel.m_170501_(afloat[0], afloat[1], afloat[2]);
                stack.m_85837_(fishInX, fishInY, fishInZ);
                stack.m_85841_(-1.0f, -1.0f, 1.0f);
                basemodel.m_6973_((Entity)parent, 0.0f, 0.0f, this.m_6930_((LivingEntity)parent, partialTicks), 0.0f, 0.0f);
                basemodel.m_7695_(stack, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                basemodel.m_170501_(1.0f, 1.0f, 1.0f);
                stack.m_85849_();
                stack.m_85836_();
                VertexConsumer vertexConsumer2 = buffer.m_6299_(basemodel.m_103119_(this.getPatternTextureLocation(variant)));
                float[] afloat2 = this.getPatternColor(variant);
                patternModel.m_170501_(afloat2[0], afloat2[1], afloat2[2]);
                stack.m_85837_(fishInX, fishInY, fishInZ);
                stack.m_85841_(-1.0f, -1.0f, 1.0f);
                patternModel.m_6973_((Entity)parent, 0.0f, 0.0f, this.m_6930_((LivingEntity)parent, partialTicks), 0.0f, 0.0f);
                patternModel.m_7695_(stack, vertexConsumer2, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                patternModel.m_170501_(1.0f, 1.0f, 1.0f);
                stack.m_85849_();
            }
        }
    }

    protected void scale(Slime p_115983_, PoseStack p_115984_, float p_115985_) {
        float f = 0.999f;
        p_115984_.m_85841_(0.999f, 0.999f, 0.999f);
        p_115984_.m_85837_(0.0, (double)0.001f, 0.0);
        float f1 = p_115983_.m_33632_();
        float f2 = Mth.m_14179_((float)p_115985_, (float)p_115983_.f_33585_, (float)p_115983_.f_33584_) / (f1 * 0.5f + 1.0f);
        float f3 = 1.0f / (f2 + 1.0f);
        p_115984_.m_85841_(f3 * f1, 1.0f / f3 * f1, f3 * f1);
    }

    public ResourceLocation getTextureLocation(Slime p_115974_) {
        return SLIME_LOCATION;
    }
}

