/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.entity.goal.FollowOwnerEvenFlyGoal;
import baguchan.earthmobsmod.entity.goal.SitEvenFlying;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class BabyGhast
extends PathfinderMob {
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING = SynchedEntityData.m_135353_(BabyGhast.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(BabyGhast.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Boolean> DATA_SITTING = SynchedEntityData.m_135353_(BabyGhast.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState shootAnimationState = new AnimationState();

    public BabyGhast(EntityType<? extends BabyGhast> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.f_21364_ = 0;
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22280_, (double)0.14f).m_22268_(Attributes.f_22279_, (double)0.14f).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 48.0);
    }

    public void m_7023_(Vec3 p_218382_) {
        if (this.m_6142_() || this.m_6109_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, p_218382_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, p_218382_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                this.m_19920_(this.m_6113_(), p_218382_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.91f));
            }
        }
        this.m_21043_((LivingEntity)this, false);
    }

    protected PathNavigation m_6037_(Level p_218342_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_218342_);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitEvenFlying(this));
        this.f_21345_.m_25352_(3, (Goal)new GhastShootFireballGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new FollowOwnerEvenFlyGoal(this, 1.15, 6.0f, 2.0f, true));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, (double)0.9f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
        this.f_19804_.m_135372_(DATA_SITTING, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_CHARGING, (Object)false);
    }

    public void m_8119_() {
        if (this.f_19853_.m_5776_() && !this.isInSittingPose()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        super.m_8119_();
    }

    public void m_7380_(CompoundTag p_21819_) {
        super.m_7380_(p_21819_);
        if (this.getOwnerUUID() != null) {
            p_21819_.m_128362_("Owner", this.getOwnerUUID());
        }
        p_21819_.m_128379_("Sitting", this.isInSittingPose());
    }

    public void m_7378_(CompoundTag p_21815_) {
        UUID uuid;
        super.m_7378_(p_21815_);
        if (p_21815_.m_128403_("Owner")) {
            uuid = p_21815_.m_128342_("Owner");
        } else {
            String s = p_21815_.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            this.setOwnerUUID(uuid);
        }
        this.setInSittingPose(p_21815_.m_128471_("Sitting"));
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID p_21817_) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(p_21817_));
    }

    public boolean isInSittingPose() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SITTING);
    }

    public void setInSittingPose(boolean p_21838_) {
        this.f_19804_.m_135381_(DATA_SITTING, (Object)p_21838_);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CHARGING);
    }

    public void setCharging(boolean p_32759_) {
        this.f_19804_.m_135381_(DATA_IS_CHARGING, (Object)p_32759_);
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerUUID();
            return uuid == null ? null : this.f_19853_.m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    protected void spawnTamingParticles(boolean p_21835_) {
        SimpleParticleType particleoptions = ParticleTypes.f_123750_;
        if (!p_21835_) {
            particleoptions = ParticleTypes.f_123762_;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public void m_7822_(byte p_21807_) {
        if (p_21807_ == 7) {
            this.spawnTamingParticles(true);
        } else if (p_21807_ == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.m_7822_(p_21807_);
        }
    }

    public InteractionResult m_6071_(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.m_21120_(p_30413_);
        Item item = itemstack.m_41720_();
        if (this.f_19853_.f_46443_) {
            boolean flag = this.getOwner() != null || itemstack.m_150930_(Items.f_42488_) || itemstack.m_150930_(Items.f_41954_);
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.getOwner() != null) {
            if ((itemstack.m_150930_(Items.f_42488_) || itemstack.m_150930_(Items.f_41954_)) && this.m_21223_() < this.m_21233_()) {
                if (!p_30412_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_216990_(SoundEvents.f_11912_);
                this.m_5634_(2.0f);
                this.m_146850_(GameEvent.f_223698_);
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionresult = super.m_6071_(p_30412_, p_30413_);
            if ((!interactionresult.m_19077_() || this.m_6162_()) && this.isOwnedBy((LivingEntity)p_30412_)) {
                this.setInSittingPose(!this.isInSittingPose());
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                p_30412_.m_5661_((Component)(this.isInSittingPose() ? Component.m_237110_((String)"entity.earthmobsmod.baby_ghast.sit", (Object[])new Object[]{this.m_5446_()}) : Component.m_237110_((String)"entity.earthmobsmod.baby_ghast.standing", (Object[])new Object[]{this.m_5446_()})), true);
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (itemstack.m_150930_(Items.f_42488_) || itemstack.m_150930_(Items.f_41954_)) {
            if (!p_30412_.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0) {
                this.setOwnerUUID(p_30412_.m_20148_());
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.setInSittingPose(true);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(p_30412_, p_30413_);
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_6785_(double p_21542_) {
        return false;
    }

    public boolean m_6779_(LivingEntity p_21822_) {
        return this.isOwnedBy(p_21822_) ? false : super.m_6779_(p_21822_);
    }

    public boolean isOwnedBy(LivingEntity p_21831_) {
        return p_21831_ == this.getOwner();
    }

    public static boolean checkGhastSpawnRules(EntityType<? extends BabyGhast> p_33018_, ServerLevelAccessor p_33019_, MobSpawnType p_33020_, BlockPos p_33021_, RandomSource p_33022_) {
        return p_33019_.m_8055_(p_33021_.m_7495_()).m_204336_(BlockTags.f_13077_) && BabyGhast.m_217057_(p_33018_, (LevelAccessor)p_33019_, (MobSpawnType)p_33020_, (BlockPos)p_33021_, (RandomSource)p_33022_);
    }

    public boolean m_142535_(float p_147105_, float p_147106_, DamageSource p_147107_) {
        return false;
    }

    protected void m_7840_(double p_20809_, boolean p_20810_, BlockState p_20811_, BlockPos p_20812_) {
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11919_;
    }

    protected SoundEvent m_7975_(DamageSource p_32750_) {
        return SoundEvents.f_11922_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11920_;
    }

    protected float m_6121_() {
        return 0.6f;
    }

    public float m_6100_() {
        return this.f_19796_.m_188501_() - this.f_19796_.m_188501_() * 0.2f + 1.5f;
    }

    static class GhastShootFireballGoal
    extends Goal {
        private final BabyGhast ghast;
        public int chargeTime;

        public GhastShootFireballGoal(BabyGhast p_32776_) {
            this.ghast = p_32776_;
        }

        public boolean m_8036_() {
            return this.ghast.m_5448_() != null;
        }

        public void m_8056_() {
            this.chargeTime = -20;
        }

        public void m_8041_() {
            this.ghast.setCharging(false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.ghast.m_5448_();
            if (livingentity != null) {
                double d0 = 64.0;
                if (livingentity.m_20280_((Entity)this.ghast) < 128.0 && this.ghast.m_142582_((Entity)livingentity)) {
                    Level level = this.ghast.f_19853_;
                    ++this.chargeTime;
                    if (this.chargeTime == 10 && !this.ghast.m_20067_()) {
                        this.ghast.m_5496_(SoundEvents.f_11922_, 0.6f, 1.25f);
                    }
                    this.ghast.f_21365_.m_148051_((Entity)livingentity);
                    if (this.chargeTime == 20) {
                        double d1 = 4.0;
                        Vec3 vec3 = this.ghast.m_20252_(1.0f);
                        double d2 = livingentity.m_20185_() - (this.ghast.m_20185_() + vec3.f_82479_ * 0.65);
                        double d3 = livingentity.m_20188_() - this.ghast.m_20188_();
                        double d4 = livingentity.m_20189_() - (this.ghast.m_20189_() + vec3.f_82481_ * 0.65);
                        if (!this.ghast.m_20067_()) {
                            this.ghast.m_5496_(SoundEvents.f_11923_, 0.6f, 1.25f);
                        }
                        SmallFireball fireball = new SmallFireball(level, (LivingEntity)this.ghast, d2, d3, d4);
                        fireball.m_6034_(this.ghast.m_20185_() + vec3.f_82479_ * 0.65, this.ghast.m_20188_(), fireball.m_20189_() + vec3.f_82481_ * 0.65);
                        level.m_7967_((Entity)fireball);
                        this.chargeTime = -80;
                    }
                } else if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
                this.ghast.setCharging(this.chargeTime > 10);
            }
        }
    }
}

