/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity.goal;

import baguchan.earthmobsmod.entity.IHasFlower;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.phys.Vec3;

public class BeePollinateFlowerMobGoal
extends Goal {
    private static final int MIN_POLLINATION_TICKS = 400;
    private static final int MIN_FIND_FLOWER_RETRY_COOLDOWN = 20;
    private static final int MAX_FIND_FLOWER_RETRY_COOLDOWN = 60;
    public static final Predicate<LivingEntity> FLOWER_MOB_SELECTOR = p_30437_ -> p_30437_ instanceof IHasFlower && ((IHasFlower)p_30437_).hasFlower();
    private static final double ARRIVAL_THRESHOLD = 0.1;
    private static final int POSITION_CHANGE_CHANCE = 25;
    private static final float SPEED_MODIFIER = 0.35f;
    private static final float HOVER_HEIGHT_WITHIN_FLOWER = 0.6f;
    private static final float HOVER_POS_OFFSET = 0.33333334f;
    private int successfulPollinatingTicks;
    private int lastSoundPlayedTick;
    private boolean pollinating;
    private int pollinatingTicks;
    private static final int MAX_POLLINATING_TICKS = 600;
    private final Bee bee;
    private LivingEntity flowerMob;

    public BeePollinateFlowerMobGoal(Bee bee) {
        this.bee = bee;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canBeeUse() {
        if (this.bee.f_27714_ > 0) {
            return false;
        }
        if (this.bee.m_27856_()) {
            return false;
        }
        if (this.bee.f_19853_.m_46471_()) {
            return false;
        }
        Optional<LivingEntity> optional = this.findNearbyFlowerMob();
        if (optional.isPresent()) {
            this.flowerMob = optional.get();
            this.bee.m_21573_().m_26519_(this.flowerMob.m_20185_() + 0.5, this.flowerMob.m_20186_() + 0.5, this.flowerMob.m_20189_() + 0.5, (double)1.2f);
            return true;
        }
        this.bee.f_27714_ = Mth.m_216271_((RandomSource)this.bee.m_217043_(), (int)20, (int)60);
        return false;
    }

    public boolean canBeeContinueToUse() {
        if (!this.pollinating) {
            return false;
        }
        if (this.bee.f_19853_.m_46471_()) {
            return false;
        }
        if (this.hasPollinatedLongEnough()) {
            return this.bee.m_217043_().m_188501_() < 0.2f;
        }
        if (this.flowerMob == null || !this.flowerMob.m_6084_()) {
            this.flowerMob = null;
            return false;
        }
        return true;
    }

    private boolean hasPollinatedLongEnough() {
        return this.successfulPollinatingTicks > 200;
    }

    boolean isPollinating() {
        return this.pollinating;
    }

    void stopPollinating() {
        this.pollinating = false;
    }

    public boolean m_8036_() {
        return this.canBeeUse();
    }

    public boolean m_8045_() {
        return this.canBeeContinueToUse();
    }

    public void m_8056_() {
        this.successfulPollinatingTicks = 0;
        this.pollinatingTicks = 0;
        this.lastSoundPlayedTick = 0;
        this.pollinating = true;
        this.bee.m_27853_();
    }

    public void m_8041_() {
        if (this.hasPollinatedLongEnough()) {
            this.bee.m_27919_(true);
        }
        this.pollinating = false;
        this.flowerMob = null;
        this.bee.m_21573_().m_26573_();
        this.bee.f_27714_ = 200;
    }

    public void m_8037_() {
        ++this.pollinatingTicks;
        if (this.pollinatingTicks > 600 || this.flowerMob == null || !this.flowerMob.m_6084_()) {
            this.stopPollinating();
            return;
        }
        Vec3 pos = this.flowerMob.m_146892_();
        double dinstanceToFlower = this.bee.m_20238_(pos);
        if (dinstanceToFlower >= 0.5) {
            this.bee.m_21573_().m_26519_(pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)0.8f);
            this.bee.m_21563_().m_24964_(pos);
        }
        if (dinstanceToFlower <= 4.0) {
            ++this.successfulPollinatingTicks;
            if (this.bee.m_217043_().m_188501_() < 0.05f && this.successfulPollinatingTicks > this.lastSoundPlayedTick + 60) {
                this.lastSoundPlayedTick = this.successfulPollinatingTicks;
                this.bee.m_5496_(SoundEvents.f_11693_, 1.0f, 1.0f);
            }
        }
    }

    private Optional<LivingEntity> findNearbyFlowerMob() {
        return this.findNearestFlowerMob(FLOWER_MOB_SELECTOR, 10.0);
    }

    private Optional<LivingEntity> findNearestFlowerMob(Predicate<LivingEntity> p_28076_, double p_28077_) {
        TargetingConditions targetConditions = TargetingConditions.m_148353_().m_26883_(p_28077_).m_26888_(p_28076_);
        LivingEntity livingEntity = this.bee.f_19853_.m_45982_(this.bee.f_19853_.m_6443_(LivingEntity.class, this.bee.m_20191_().m_82400_(p_28077_), p_148152_ -> true), targetConditions, (LivingEntity)this.bee, this.bee.m_20185_(), this.bee.m_20188_(), this.bee.m_20189_());
        if (livingEntity != null) {
            return Optional.of(livingEntity);
        }
        return Optional.empty();
    }
}

