/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.fluidtype;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.joml.Matrix4f;

public class MudFluidType
extends FluidType {
    public MudFluidType(FluidType.Properties properties) {
        super(properties);
    }

    public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
        boolean flag = entity.m_20184_().f_82480_ <= 0.0;
        double d8 = entity.m_20186_();
        entity.m_19920_(0.02f, movementVector);
        entity.m_6478_(MoverType.SELF, entity.m_20184_());
        if (entity.getFluidTypeHeight((FluidType)this) <= entity.m_20204_()) {
            entity.m_20256_(entity.m_20184_().m_82542_(0.75, (double)0.8f, 0.75));
            Vec3 vec33 = entity.m_20994_(gravity, flag, entity.m_20184_());
            entity.m_20256_(vec33);
        } else {
            entity.m_20256_(entity.m_20184_().m_82490_(0.75));
        }
        if (!entity.m_20068_()) {
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, -gravity / 4.0, 0.0));
        }
        Vec3 vec34 = entity.m_20184_();
        if (entity.f_19862_ && entity.m_20229_(vec34.f_82479_, vec34.f_82480_ + (double)0.6f - entity.m_20186_() + d8, vec34.f_82481_)) {
            entity.m_20334_(vec34.f_82479_, (double)0.3f, vec34.f_82481_);
        }
        return true;
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientFluidTypeExtensions(){
            private static final ResourceLocation TEXTURE_STILL = new ResourceLocation("earthmobsmod", "block/mud");
            private static final ResourceLocation TEXTURE_FLOW = new ResourceLocation("earthmobsmod", "block/flow_mud");
            private static final ResourceLocation TEXTURE_OVERLAY = new ResourceLocation("earthmobsmod", "textures/block/mud.png");

            public ResourceLocation getStillTexture() {
                return TEXTURE_STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return TEXTURE_FLOW;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return TEXTURE_OVERLAY;
            }

            public void renderOverlay(Minecraft mc, PoseStack stack) {
                ResourceLocation texture = this.getRenderOverlayTexture(mc);
                if (texture == null) {
                    return;
                }
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_69493_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
                BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
                BlockPos playerEyePos = new BlockPos(mc.f_91074_.m_20185_(), mc.f_91074_.m_20188_(), mc.f_91074_.m_20189_());
                float brightness = LightTexture.m_234316_((DimensionType)mc.f_91074_.f_19853_.m_6042_(), (int)mc.f_91074_.f_19853_.m_46803_(playerEyePos));
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                RenderSystem.m_157429_((float)brightness, (float)brightness, (float)brightness, (float)0.65f);
                float uOffset = -mc.f_91074_.m_146908_() / 64.0f;
                float vOffset = mc.f_91074_.m_146909_() / 64.0f;
                Matrix4f pose = stack.m_85850_().m_252922_();
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                buffer.m_252986_(pose, -1.0f, -1.0f, -0.5f).m_7421_(4.0f + uOffset, 4.0f + vOffset).m_5752_();
                buffer.m_252986_(pose, 1.0f, -1.0f, -0.5f).m_7421_(uOffset, 4.0f + vOffset).m_5752_();
                buffer.m_252986_(pose, 1.0f, 1.0f, -0.5f).m_7421_(uOffset, vOffset).m_5752_();
                buffer.m_252986_(pose, -1.0f, 1.0f, -0.5f).m_7421_(4.0f + uOffset, vOffset).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
                RenderSystem.m_69461_();
            }
        });
    }
}

