/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.registry;

import baguchan.earthmobsmod.block.CarvedMelonBlock;
import baguchan.earthmobsmod.registry.ModFluids;
import baguchan.earthmobsmod.registry.ModItems;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"earthmobsmod");
    public static final RegistryObject<LiquidBlock> MUD = ModBlocks.noItemRegister("mud", () -> new LiquidBlock(ModFluids.MUD, BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_60978_(100.0f).m_222994_()));
    public static final RegistryObject<Block> CARVED_MELON = ModBlocks.register("carved_melon", () -> new CarvedMelonBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76285_, (MaterialColor)MaterialColor.f_76417_).m_60978_(1.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<Block> CARVED_MELON_SHOOT = ModBlocks.register("carved_melon_shoot", () -> new CarvedMelonBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76285_, (MaterialColor)MaterialColor.f_76417_).m_60978_(1.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<FlowerBlock> BUTTERCUP = ModBlocks.register("buttercup", () -> new FlowerBlock(MobEffects.f_19617_, 30, BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76416_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_)));
    public static final RegistryObject<FlowerBlock> PINK_DAISY = ModBlocks.register("pink_daisy", () -> new FlowerBlock(MobEffects.f_19605_, 10, BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76416_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_)));

    private static <T extends Block> RegistryObject<T> baseRegister(String name, Supplier<? extends T> block, Function<RegistryObject<T>, Supplier<? extends Item>> item) {
        RegistryObject register = BLOCKS.register(name, block);
        ModItems.ITEMS.register(name, item.apply(register));
        return register;
    }

    private static <T extends Block> RegistryObject<T> noItemRegister(String name, Supplier<? extends T> block) {
        RegistryObject register = BLOCKS.register(name, block);
        return register;
    }

    private static <B extends Block> RegistryObject<B> register(String name, Supplier<? extends Block> block) {
        return ModBlocks.baseRegister(name, block, object -> ModBlocks.registerBlockItem(object));
    }

    private static <T extends Block> Supplier<BlockItem> registerBlockItem(RegistryObject<T> block) {
        return () -> new BlockItem(Objects.requireNonNull((Block)block.get()), new Item.Properties());
    }
}

