/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.telepathicgrunt.the_bumblezone.capabilities.BzCapabilities;
import com.telepathicgrunt.the_bumblezone.capabilities.EntityMisc;
import com.telepathicgrunt.the_bumblezone.commands.NonOpCommands;
import com.telepathicgrunt.the_bumblezone.items.EssenceOfTheBees;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;

public class OpCommands {
    private static MinecraftServer currentMinecraftServer = null;
    private static Set<String> cachedSuggestion = new HashSet<String>();

    public static void createCommand(RegisterCommandsEvent commandEvent) {
        CommandDispatcher commandDispatcher = commandEvent.getDispatcher();
        CommandBuildContext buildContext = commandEvent.getBuildContext();
        String commandWriteString = "bumblezone_modify_data";
        String commandReadString = "bumblezone_read_data";
        String dataArg = "data_to_modify";
        String newDataArg = "new_value";
        String entityArg = "entity_to_check";
        LiteralCommandNode source = commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)commandWriteString).requires(permission -> permission.m_6761_(2))).then(Commands.m_82129_((String)dataArg, (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> SharedSuggestionProvider.m_82970_(OpCommands.methodBooleanWriteSuggestions((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)sb)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)newDataArg, (ArgumentType)BoolArgumentType.bool()).executes(cs -> {
            OpCommands.runBooleanSetMethod((CommandSourceStack)cs.getSource(), (String)cs.getArgument(dataArg, String.class), EntityArgument.m_91477_((CommandContext)cs, (String)"targets"), (Boolean)cs.getArgument(newDataArg, Boolean.TYPE), (CommandContext<CommandSourceStack>)cs);
            return 1;
        })))));
        commandDispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)commandWriteString).redirect((CommandNode)source));
        LiteralCommandNode source2 = commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)commandReadString).requires(permission -> permission.m_6761_(2))).then(Commands.m_82129_((String)dataArg, (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> SharedSuggestionProvider.m_82970_(OpCommands.methodReadSuggestions((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)sb)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(cs -> {
            OpCommands.runReadMethod((CommandSourceStack)cs.getSource(), (String)cs.getArgument(dataArg, String.class), null, EntityArgument.m_91477_((CommandContext)cs, (String)"targets"), (CommandContext<CommandSourceStack>)cs);
            return 1;
        }))));
        commandDispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)commandReadString).redirect((CommandNode)source2));
        LiteralCommandNode source3 = commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)commandReadString).requires(permission -> permission.m_6761_(2))).then(Commands.m_82127_((String)DATA_READ_ARG.QUEENS_DESIRED_KILLED_ENTITY_COUNTER.name().toLowerCase(Locale.ROOT)).then(Commands.m_82129_((String)entityArg, (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)buildContext, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(cs -> {
            OpCommands.runReadMethod((CommandSourceStack)cs.getSource(), DATA_READ_ARG.QUEENS_DESIRED_KILLED_ENTITY_COUNTER.name(), ResourceArgument.m_247713_((CommandContext)cs, (String)entityArg).m_205785_().m_135782_(), EntityArgument.m_91477_((CommandContext)cs, (String)"targets"), (CommandContext<CommandSourceStack>)cs);
            return 1;
        })))));
        commandDispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)commandReadString).redirect((CommandNode)source3));
    }

    private static Set<String> methodBooleanWriteSuggestions(CommandContext<CommandSourceStack> cs) {
        if (currentMinecraftServer == ((CommandSourceStack)cs.getSource()).m_81377_()) {
            return cachedSuggestion;
        }
        HashSet<String> suggestedStrings = new HashSet<String>();
        Arrays.stream(DATA_BOOLEAN_WRITE_ARG.values()).forEach(e -> suggestedStrings.add(e.name().toLowerCase(Locale.ROOT)));
        currentMinecraftServer = ((CommandSourceStack)cs.getSource()).m_81377_();
        cachedSuggestion = suggestedStrings;
        return suggestedStrings;
    }

    private static Set<String> methodReadSuggestions(CommandContext<CommandSourceStack> cs) {
        if (currentMinecraftServer == ((CommandSourceStack)cs.getSource()).m_81377_()) {
            return cachedSuggestion;
        }
        HashSet<String> suggestedStrings = new HashSet<String>();
        Arrays.stream(DATA_READ_ARG.values()).forEach(e -> suggestedStrings.add(e.name().toLowerCase(Locale.ROOT)));
        currentMinecraftServer = ((CommandSourceStack)cs.getSource()).m_81377_();
        cachedSuggestion = suggestedStrings;
        return suggestedStrings;
    }

    public static void runBooleanSetMethod(CommandSourceStack commandSourceStack, String dataString, Collection<ServerPlayer> targets, boolean bool, CommandContext<CommandSourceStack> cs) {
        DATA_READ_ARG dataArg;
        try {
            dataArg = DATA_READ_ARG.valueOf(dataString.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            MutableComponent mutableComponent = Component.m_237115_((String)"command.the_bumblezone.invalid_data_arg");
            commandSourceStack.m_81352_((Component)mutableComponent);
            return;
        }
        if (DATA_READ_ARG.IS_BEE_ESSENCED.equals((Object)dataArg)) {
            for (ServerPlayer targetPlayer : targets) {
                EssenceOfTheBees.setEssence(targetPlayer, bool);
            }
            MutableComponent mutableComponent = Component.m_237115_((String)"command.the_bumblezone.data_change_success");
            commandSourceStack.m_81354_((Component)mutableComponent, true);
            return;
        }
    }

    public static void runReadMethod(CommandSourceStack commandSourceStack, String dataString, ResourceLocation killedEntityRL, Collection<ServerPlayer> targets, CommandContext<CommandSourceStack> cs) {
        NonOpCommands.DATA_ARG dataArg;
        try {
            dataArg = NonOpCommands.DATA_ARG.valueOf(dataString.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            MutableComponent mutableComponent = Component.m_237115_((String)"command.the_bumblezone.invalid_data_arg");
            commandSourceStack.m_81352_((Component)mutableComponent);
            return;
        }
        for (ServerPlayer targetPlayer : targets) {
            if (NonOpCommands.DATA_ARG.IS_BEE_ESSENCED.equals((Object)dataArg)) {
                boolean hasBeeEssence = EssenceOfTheBees.hasEssence(targetPlayer);
                MutableComponent mutableComponent = Component.m_237110_((String)(hasBeeEssence ? "command.the_bumblezone.have_bee_essence" : "command.the_bumblezone.does_not_have_bee_essence"), (Object[])new Object[]{targetPlayer.m_5446_()});
                commandSourceStack.m_81354_((Component)mutableComponent, false);
                return;
            }
            if (!EntityMisc.rootAdvancementDone(targetPlayer)) {
                commandSourceStack.m_81352_((Component)Component.m_237110_((String)"command.the_bumblezone.queens_desired_not_active", (Object[])new Object[]{targetPlayer.m_5446_()}));
                continue;
            }
            switch (dataArg) {
                case QUEENS_DESIRED_CRAFTED_BEEHIVE: {
                    targetPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> commandSourceStack.m_81354_((Component)Component.m_237110_((String)"command.the_bumblezone.queens_desired_crafted_beehive", (Object[])new Object[]{targetPlayer.m_5446_(), capability.craftedBeehives}), false));
                    break;
                }
                case QUEENS_DESIRED_BEES_BRED: {
                    targetPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> commandSourceStack.m_81354_((Component)Component.m_237110_((String)"command.the_bumblezone.queens_desired_bees_bred", (Object[])new Object[]{targetPlayer.m_5446_(), capability.beesBred}), false));
                    break;
                }
                case QUEENS_DESIRED_FLOWERS_SPAWNED: {
                    targetPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> commandSourceStack.m_81354_((Component)Component.m_237110_((String)"command.the_bumblezone.queens_desired_flowers_spawned", (Object[])new Object[]{targetPlayer.m_5446_(), capability.flowersSpawned}), false));
                    break;
                }
                case QUEENS_DESIRED_HONEY_BOTTLE_DRANK: {
                    targetPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> commandSourceStack.m_81354_((Component)Component.m_237110_((String)"command.the_bumblezone.queens_desired_honey_bottle_drank", (Object[])new Object[]{targetPlayer.m_5446_(), capability.honeyBottleDrank}), false));
                    break;
                }
                case QUEENS_DESIRED_BEE_STINGERS_FIRED: {
                    targetPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> commandSourceStack.m_81354_((Component)Component.m_237110_((String)"command.the_bumblezone.queens_desired_bee_stingers_fired", (Object[])new Object[]{targetPlayer.m_5446_(), capability.beeStingersFired}), false));
                    break;
                }
                case QUEENS_DESIRED_BEE_SAVED: {
                    targetPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> commandSourceStack.m_81354_((Component)Component.m_237110_((String)"command.the_bumblezone.queens_desired_bee_saved", (Object[])new Object[]{targetPlayer.m_5446_(), capability.beeSaved}), false));
                    break;
                }
                case QUEENS_DESIRED_POLLEN_PUFF_HITS: {
                    targetPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> commandSourceStack.m_81354_((Component)Component.m_237110_((String)"command.the_bumblezone.queens_desired_pollen_puff_hits", (Object[])new Object[]{targetPlayer.m_5446_(), capability.pollenPuffHits}), false));
                    break;
                }
                case QUEENS_DESIRED_HONEY_SLIME_BRED: {
                    targetPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> commandSourceStack.m_81354_((Component)Component.m_237110_((String)"command.the_bumblezone.queens_desired_honey_slime_bred", (Object[])new Object[]{targetPlayer.m_5446_(), capability.honeySlimeBred}), false));
                    break;
                }
                case QUEENS_DESIRED_BEES_FED: {
                    targetPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> commandSourceStack.m_81354_((Component)Component.m_237110_((String)"command.the_bumblezone.queens_desired_bees_fed", (Object[])new Object[]{targetPlayer.m_5446_(), capability.beesFed}), false));
                    break;
                }
                case QUEENS_DESIRED_QUEEN_BEE_TRADE: {
                    targetPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> commandSourceStack.m_81354_((Component)Component.m_237110_((String)"command.the_bumblezone.queens_desired_queen_bee_trade", (Object[])new Object[]{targetPlayer.m_5446_(), capability.queenBeeTrade}), false));
                    break;
                }
                case QUEENS_DESIRED_KILLED_ENTITY_COUNTER: {
                    if (killedEntityRL != null) {
                        targetPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> {
                            int killed = capability.mobsKilledTracker.getOrDefault(killedEntityRL, 0);
                            String translationKey = killedEntityRL.equals((Object)new ResourceLocation("minecraft", "ender_dragon")) ? "command.the_bumblezone.queens_desired_killed_entity_counter_ender_dragon" : (killedEntityRL.equals((Object)new ResourceLocation("minecraft", "wither")) ? "command.the_bumblezone.queens_desired_killed_entity_counter_wither" : "command.the_bumblezone.queens_desired_killed_entity_counter");
                            commandSourceStack.m_81354_((Component)Component.m_237110_((String)translationKey, (Object[])new Object[]{targetPlayer.m_5446_(), killed, Component.m_237115_((String)Util.m_137492_((String)"entity", (ResourceLocation)killedEntityRL))}), false);
                        });
                        break;
                    }
                    commandSourceStack.m_81354_((Component)Component.m_237115_((String)"command.the_bumblezone.invalid_entity_arg"), false);
                    return;
                }
            }
        }
    }

    static enum DATA_READ_ARG {
        IS_BEE_ESSENCED,
        QUEENS_DESIRED_CRAFTED_BEEHIVE,
        QUEENS_DESIRED_BEES_BRED,
        QUEENS_DESIRED_FLOWERS_SPAWNED,
        QUEENS_DESIRED_HONEY_BOTTLE_DRANK,
        QUEENS_DESIRED_BEE_STINGERS_FIRED,
        QUEENS_DESIRED_BEE_SAVED,
        QUEENS_DESIRED_POLLEN_PUFF_HITS,
        QUEENS_DESIRED_HONEY_SLIME_BRED,
        QUEENS_DESIRED_BEES_FED,
        QUEENS_DESIRED_QUEEN_BEE_TRADE,
        QUEENS_DESIRED_KILLED_ENTITY_COUNTER;

    }

    static enum DATA_BOOLEAN_WRITE_ARG {
        IS_BEE_ESSENCED;

    }
}

