/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.effects;

import com.telepathicgrunt.the_bumblezone.blocks.PileOfPollen;
import com.telepathicgrunt.the_bumblezone.client.rendering.HiddenEffectIconRenderer;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Bee;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class HiddenEffect
extends MobEffect {
    private static final TargetingConditions SEE_THROUGH_WALLS = TargetingConditions.m_148352_().m_148355_();

    public HiddenEffect(MobEffectCategory type, int potionColor) {
        super(type, potionColor);
    }

    public boolean m_8093_() {
        return false;
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration >= 1;
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        super.m_6742_(livingEntity, amplifier);
        MobEffectInstance effect = livingEntity.m_21124_((MobEffect)BzEffects.HIDDEN.get());
        if (effect != null && effect.m_19557_() <= 1) {
            PileOfPollen.reapplyHiddenEffectIfInsidePollenPile(livingEntity);
        }
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        if (amplifier >= 1) {
            SEE_THROUGH_WALLS.m_26883_((double)((Integer)BzBeeAggressionConfigs.aggressionTriggerRadius.get()).intValue() * 0.5);
            List beeList = entity.f_19853_.m_45971_(Bee.class, SEE_THROUGH_WALLS, entity, entity.m_20191_().m_82400_((double)((Integer)BzBeeAggressionConfigs.aggressionTriggerRadius.get()).intValue() * 0.5));
            for (Bee bee : beeList) {
                if (bee.m_5448_() != entity) continue;
                bee.m_6710_(null);
                bee.m_6925_(null);
                bee.m_7870_(0);
            }
        }
        super.m_6385_(entity, attributes, amplifier);
    }

    public static void hideEntity(LivingEvent.LivingVisibilityEvent event) {
        MobEffectInstance hiddenEffect = event.getEntity().m_21124_((MobEffect)BzEffects.HIDDEN.get());
        if (hiddenEffect != null) {
            event.modifyVisibility(0.0);
        }
    }

    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            consumer.accept(HiddenEffectIconRenderer.createIconRenderer());
        }
    }
}

