/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.capabilities.EntityMisc;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.effects.WrathOfTheHiveEffect;
import com.telepathicgrunt.the_bumblezone.entities.CreatingHoneySlime;
import com.telepathicgrunt.the_bumblezone.items.PollenPuff;
import com.telepathicgrunt.the_bumblezone.items.StinglessBeeHelmet;
import com.telepathicgrunt.the_bumblezone.mixin.entities.BeeEntityInvoker;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class BeeInteractivity {
    private static final ResourceLocation PRODUCTIVE_BEES_HONEY_TREAT = new ResourceLocation("productivebees", "honey_treat");

    public static void onEntityInteractEvent(PlayerInteractEvent.EntityInteract event) {
        Slime slimeEntity;
        Entity entity = event.getTarget();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        if (player == null || entity == null || event.isCanceled()) {
            return;
        }
        if (entity instanceof Bee) {
            Bee beeEntity = (Bee)entity;
            if (BeeInteractivity.beeFeeding(entity.f_19853_, player, hand, (Entity)beeEntity) == InteractionResult.SUCCESS) {
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            } else if (StinglessBeeHelmet.addBeePassenger(entity.f_19853_, player, hand, (Entity)beeEntity) == InteractionResult.SUCCESS) {
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            } else if (BeeInteractivity.beeUnpollinating(entity.f_19853_, player, hand, beeEntity) == InteractionResult.SUCCESS) {
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        } else if (entity instanceof Slime && CreatingHoneySlime.createHoneySlime(entity.f_19853_, player, hand, (Entity)(slimeEntity = (Slime)entity)) == InteractionResult.SUCCESS) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    public static InteractionResult beeFeeding(Level world, Player playerEntity, InteractionHand hand, Entity target) {
        if (target instanceof Bee) {
            boolean removedWrath;
            Bee beeEntity = (Bee)target;
            ItemStack itemstack = playerEntity.m_21120_(hand);
            ResourceLocation itemRL = ForgeRegistries.ITEMS.getKey((Object)itemstack.m_41720_());
            if (itemstack.m_150930_((Item)BzItems.BEE_STINGER.get())) {
                beeEntity.m_27857_();
                ((BeeEntityInvoker)beeEntity).callSetHasStung(false);
                if (!playerEntity.m_150110_().f_35937_) {
                    GeneralUtils.givePlayerItem(playerEntity, hand, ItemStack.f_41583_, false, true);
                }
                if (playerEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
                    EntityMisc.onBeesSaved((Player)serverPlayer);
                }
                return InteractionResult.SUCCESS;
            }
            if (!itemstack.m_204117_(BzTags.BEE_FEEDING_ITEMS)) {
                return InteractionResult.PASS;
            }
            if (world.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            ItemStack itemstackOriginal = itemstack.m_41777_();
            if (itemstackOriginal.m_41720_() == BzItems.BEE_BREAD.get() || ((Boolean)BzModCompatibilityConfigs.allowHoneyTreatCompat.get()).booleanValue() && itemRL.equals((Object)PRODUCTIVE_BEES_HONEY_TREAT)) {
                boolean removedWrath2 = BeeInteractivity.calmAndSpawnHearts(world, playerEntity, (LivingEntity)beeEntity, 0.3f, 3);
                if (removedWrath2 && playerEntity instanceof ServerPlayer) {
                    BzCriterias.FOOD_REMOVED_WRATH_OF_THE_HIVE_TRIGGER.trigger((ServerPlayer)playerEntity, itemstackOriginal);
                }
                playerEntity.m_21011_(hand, true);
                return InteractionResult.PASS;
            }
            if (itemstack.m_204117_(BzTags.HONEY_BUCKETS) || itemstack.m_204117_(BzTags.ROYAL_JELLY_BUCKETS) || itemstack.m_150930_((Item)BzItems.ROYAL_JELLY_BOTTLE.get())) {
                beeEntity.m_5634_(beeEntity.m_21233_() - beeEntity.m_21223_());
                boolean isRoyalFed = itemstack.m_150930_((Item)BzItems.ROYAL_JELLY_BOTTLE.get()) || itemstack.m_150930_((Item)BzItems.ROYAL_JELLY_BUCKET.get());
                boolean isRoyalFedBucket = itemstack.m_150930_((Item)BzItems.ROYAL_JELLY_BUCKET.get());
                removedWrath = BeeInteractivity.calmAndSpawnHearts(world, playerEntity, (LivingEntity)beeEntity, isRoyalFed ? 1.0f : 0.8f, isRoyalFed ? 15 : 5);
                if (beeEntity.m_6162_()) {
                    if (isRoyalFed || playerEntity.m_217043_().m_188499_()) {
                        beeEntity.m_6863_(false);
                        if (playerEntity instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
                            BzCriterias.HONEY_BUCKET_BEE_GROW_TRIGGER.trigger(serverPlayer);
                        }
                    }
                } else {
                    int nearbyAdultBees = 0;
                    for (Bee nearbyBee : world.m_6443_(Bee.class, beeEntity.m_20191_().m_82400_(4.0), beeEntity1 -> true)) {
                        nearbyBee.m_27595_(playerEntity);
                        if (nearbyBee.m_6162_()) continue;
                        ++nearbyAdultBees;
                    }
                    if (nearbyAdultBees >= 2 && playerEntity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
                        BzCriterias.HONEY_BUCKET_BEE_LOVE_TRIGGER.trigger(serverPlayer);
                    }
                }
                if (isRoyalFed) {
                    beeEntity.m_7292_(new MobEffectInstance((MobEffect)BzEffects.BEENERGIZED.get(), isRoyalFedBucket ? 90000 : 20000, 3, true, true, true));
                    if (playerEntity instanceof ServerPlayer) {
                        BzCriterias.BEENERGIZED_MAXED_TRIGGER.trigger((ServerPlayer)playerEntity);
                    }
                }
            } else if (itemRL.m_135815_().contains("honey")) {
                beeEntity.m_5634_(2.0f);
                removedWrath = BeeInteractivity.calmAndSpawnHearts(world, playerEntity, (LivingEntity)beeEntity, 0.3f, 3);
            } else {
                beeEntity.m_5634_(1.0f);
                removedWrath = BeeInteractivity.calmAndSpawnHearts(world, playerEntity, (LivingEntity)beeEntity, 0.1f, 3);
            }
            if (!playerEntity.m_7500_()) {
                GeneralUtils.givePlayerItem(playerEntity, hand, ItemStack.f_41583_, true, true);
            }
            if (playerEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
                EntityMisc.onBeesFed((Player)serverPlayer);
                if (removedWrath) {
                    BzCriterias.FOOD_REMOVED_WRATH_OF_THE_HIVE_TRIGGER.trigger(serverPlayer, itemstackOriginal);
                }
            }
            playerEntity.m_21011_(hand, true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult beeUnpollinating(Level world, Player playerEntity, InteractionHand hand, Bee beeEntity) {
        if (beeEntity.m_6095_().m_204039_(BzTags.POLLEN_PUFF_CAN_POLLINATE)) {
            BucketItem bucketItem;
            ItemStack itemstack = playerEntity.m_21120_(hand);
            Item item = itemstack.m_41720_();
            if (beeEntity.m_27856_() && (itemstack.m_41783_() != null && itemstack.m_41783_().m_128461_("Potion").contains("water") || item == Items.f_41903_ || item == BzItems.SUGAR_WATER_BOTTLE.get() || item instanceof BucketItem && (bucketItem = (BucketItem)item).getFluid().m_205067_(FluidTags.f_13131_))) {
                if (world.m_5776_()) {
                    return InteractionResult.SUCCESS;
                }
                PollenPuff.spawnItemstackEntity(world, beeEntity.m_217043_(), beeEntity.m_20183_(), new ItemStack((ItemLike)BzItems.POLLEN_PUFF.get(), 1));
                playerEntity.m_21011_(hand, true);
                ((BeeEntityInvoker)beeEntity).callSetHasNectar(false);
                if (playerEntity instanceof ServerPlayer) {
                    BzCriterias.BEE_DROP_POLLEN_PUFF_TRIGGER.trigger((ServerPlayer)playerEntity, itemstack);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static boolean calmAndSpawnHearts(Level world, Player playerEntity, LivingEntity beeEntity, float calmChance, int hearts) {
        RandomSource random = playerEntity.m_217043_();
        boolean calmed = random.m_188501_() < calmChance;
        boolean removedWrath = false;
        if (calmed) {
            if (playerEntity.m_21023_((MobEffect)BzEffects.WRATH_OF_THE_HIVE.get())) {
                playerEntity.m_21195_((MobEffect)BzEffects.WRATH_OF_THE_HIVE.get());
                WrathOfTheHiveEffect.calmTheBees(playerEntity.f_19853_, (LivingEntity)playerEntity);
                removedWrath = true;
            }
            playerEntity.m_7292_(new MobEffectInstance((MobEffect)BzEffects.PROTECTION_OF_THE_HIVE.get(), ((Integer)BzBeeAggressionConfigs.howLongProtectionOfTheHiveLasts.get()).intValue(), 2, false, false, true));
        }
        if (world instanceof ServerLevel) {
            Bee bee;
            ServerLevel serverLevel = (ServerLevel)world;
            if (beeEntity instanceof Bee ? !(bee = (Bee)beeEntity).m_21660_() || calmed : calmed) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, beeEntity.m_20185_(), beeEntity.m_20186_(), beeEntity.m_20189_(), hearts, (double)random.m_188501_() * 0.5 - 0.25, (double)(random.m_188501_() * 0.2f + 0.2f), (double)random.m_188501_() * 0.5 - 0.25, (double)random.m_188501_() * 0.4 + (double)0.2f);
            }
        }
        return removedWrath;
    }
}

