/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.capabilities.BzCapabilities;
import com.telepathicgrunt.the_bumblezone.capabilities.EntityPositionAndDimension;
import com.telepathicgrunt.the_bumblezone.configs.BzDimensionConfigs;
import com.telepathicgrunt.the_bumblezone.entities.EntityTeleportationBackend;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.world.dimension.BzWorldSavedData;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;

public class EntityTeleportationHookup {
    public static void entityTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity.f_19853_.m_46472_().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            if (livingEntity.m_20186_() < -2.0) {
                if (((Boolean)BzDimensionConfigs.enableExitTeleportation.get()).booleanValue()) {
                    if (livingEntity instanceof ServerPlayer) {
                        BzCriterias.TELEPORT_OUT_OF_BUMBLEZONE_TRIGGER.trigger((ServerPlayer)livingEntity);
                    }
                    if (livingEntity.m_20186_() < -4.0) {
                        livingEntity.m_6027_(livingEntity.m_20185_(), -4.0, livingEntity.m_20189_());
                        livingEntity.m_20248_(livingEntity.m_20185_(), -4.0, livingEntity.m_20189_());
                        livingEntity.m_20334_(0.0, 0.0, 0.0);
                        if (!livingEntity.f_19853_.m_5776_()) {
                            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 12, 100, false, false, true));
                        }
                    }
                    livingEntity.f_19789_ = 0.0f;
                    if (!livingEntity.f_19853_.m_5776_()) {
                        EntityTeleportationHookup.teleportOutOfBz(livingEntity);
                    }
                }
            } else if (livingEntity.m_20186_() > 255.0 && ((Boolean)BzDimensionConfigs.enableExitTeleportation.get()).booleanValue()) {
                if (livingEntity instanceof ServerPlayer) {
                    BzCriterias.TELEPORT_OUT_OF_BUMBLEZONE_TRIGGER.trigger((ServerPlayer)livingEntity);
                }
                if (livingEntity.m_20186_() > 257.0) {
                    livingEntity.m_6027_(livingEntity.m_20185_(), 257.0, livingEntity.m_20189_());
                    livingEntity.m_20248_(livingEntity.m_20185_(), 257.0, livingEntity.m_20189_());
                }
                if (!livingEntity.f_19853_.m_5776_()) {
                    EntityTeleportationHookup.teleportOutOfBz(livingEntity);
                }
            }
        }
    }

    public static void teleportOutOfBz(LivingEntity livingEntity) {
        if (!livingEntity.f_19853_.m_5776_()) {
            ServerLevel serverWorld;
            EntityTeleportationHookup.checkAndCorrectStoredDimension(livingEntity);
            MinecraftServer minecraftServer = livingEntity.m_20194_();
            ResourceKey worldKey = null;
            if (livingEntity.m_6688_() == null) {
                capOptional = livingEntity.getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY);
                if (capOptional.isPresent()) {
                    EntityPositionAndDimension capability = (EntityPositionAndDimension)capOptional.orElseThrow(RuntimeException::new);
                    worldKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)capability.getNonBZDim());
                }
            } else {
                Object capability = livingEntity.m_6688_();
                if (capability instanceof LivingEntity) {
                    LivingEntity livingEntity2 = (LivingEntity)capability;
                    EntityTeleportationHookup.checkAndCorrectStoredDimension(livingEntity2);
                }
                if ((capOptional = livingEntity.getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY)).isPresent()) {
                    capability = (EntityPositionAndDimension)capOptional.orElseThrow(RuntimeException::new);
                    worldKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)((EntityPositionAndDimension)capability).getNonBZDim());
                }
            }
            ServerLevel serverLevel = serverWorld = worldKey == null ? null : minecraftServer.m_129880_(worldKey);
            if (serverWorld == null) {
                serverWorld = minecraftServer.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation((String)BzDimensionConfigs.defaultDimension.get())));
            }
            BzWorldSavedData.queueEntityToTeleport((Entity)livingEntity, (ResourceKey<Level>)serverWorld.m_46472_());
        }
    }

    public static boolean runEnderpearlImpact(Vec3 hitPos, Entity thrower, Entity pearl) {
        Level world = thrower.f_19853_;
        if (((Boolean)BzDimensionConfigs.enableEntranceTeleportation.get()).booleanValue() && !world.m_5776_() && thrower instanceof ServerPlayer) {
            ServerPlayer playerEntity = (ServerPlayer)thrower;
            if (!(world.m_46472_().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID) || ((Boolean)BzDimensionConfigs.onlyOverworldHivesTeleports.get()).booleanValue() && !world.m_46472_().equals((Object)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation((String)BzDimensionConfigs.defaultDimension.get()))))) {
                BlockPos hivePos = EntityTeleportationHookup.getNearbyHivePos(hitPos, world);
                if (hivePos == null) {
                    hitPos = hitPos.m_82549_(pearl.m_20184_());
                    hivePos = EntityTeleportationHookup.getNearbyHivePos(hitPos, world);
                }
                if (hivePos == null) {
                    return false;
                }
                boolean validBelowBlock = false;
                Optional blockTag = BuiltInRegistries.f_256975_.m_203431_(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT);
                if (blockTag.isPresent() && GeneralUtils.getListOfNonDummyBlocks(blockTag).size() != 0) {
                    if (world.m_8055_(hivePos.m_7495_()).m_204336_(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT)) {
                        validBelowBlock = true;
                    } else if (((Boolean)BzDimensionConfigs.warnPlayersOfWrongBlockUnderHive.get()).booleanValue()) {
                        Bumblezone.LOGGER.log(org.apache.logging.log4j.Level.INFO, "Bumblezone: The attempt to teleport to Bumblezone failed due to not having a block from the following block tag below the hive: the_bumblezone:required_blocks_under_hive_to_teleport");
                        MutableComponent message = Component.m_237115_((String)"system.the_bumblezone.require_hive_blocks_failed");
                        playerEntity.m_5661_((Component)message, true);
                        return false;
                    }
                } else {
                    validBelowBlock = true;
                }
                if (validBelowBlock) {
                    BzCriterias.TELEPORT_TO_BUMBLEZONE_PEARL_TRIGGER.trigger(playerEntity);
                    BzWorldSavedData.queueEntityToTeleport((Entity)playerEntity, BzDimension.BZ_WORLD_KEY);
                    return true;
                }
            }
        }
        return false;
    }

    protected static boolean runEntityHitCheck(HitResult hitResult, Projectile pearlEntity) {
        Level world = pearlEntity.f_19853_;
        if (!world.m_5776_() && hitResult instanceof EntityHitResult) {
            Entity entity;
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            if (((Boolean)BzDimensionConfigs.enableEntranceTeleportation.get()).booleanValue() && (entity = pearlEntity.m_37282_()) instanceof ServerPlayer) {
                ServerPlayer playerEntity = (ServerPlayer)entity;
                if (!(world.m_46472_().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID) || ((Boolean)BzDimensionConfigs.onlyOverworldHivesTeleports.get()).booleanValue() && !world.m_46472_().equals((Object)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation((String)BzDimensionConfigs.defaultDimension.get()))))) {
                    Entity hitEntity = entityHitResult.m_82443_();
                    boolean passedCheck = false;
                    if (hitEntity.m_6095_().m_204039_(BzTags.ENDERPEARL_TARGET_ENTITY_HIT_ANYWHERE) || hitEntity.m_6095_().m_204039_(BzTags.ENDERPEARL_TARGET_ENTITY_HIT_HIGH) || hitEntity.m_6095_().m_204039_(BzTags.ENDERPEARL_TARGET_ENTITY_HIT_LOW)) {
                        Vec3 hitPos = pearlEntity.m_20182_();
                        AABB boundBox = entityHitResult.m_82443_().m_20191_();
                        double relativeHitY = hitPos.m_7098_() - boundBox.f_82289_;
                        double entityBoundHeight = boundBox.f_82292_ - boundBox.f_82289_;
                        double minYThreshold = -2.147483648E9;
                        double maxYThreshold = 2.147483647E9;
                        if (hitEntity.m_6095_().m_204039_(BzTags.ENDERPEARL_TARGET_ENTITY_HIT_HIGH)) {
                            minYThreshold = entityBoundHeight / 2.0;
                        }
                        if (hitEntity.m_6095_().m_204039_(BzTags.ENDERPEARL_TARGET_ENTITY_HIT_HIGH)) {
                            maxYThreshold = entityBoundHeight / 2.0;
                        }
                        if (minYThreshold != maxYThreshold && (relativeHitY > maxYThreshold || relativeHitY < minYThreshold)) {
                            return false;
                        }
                        passedCheck = true;
                    }
                    for (ItemStack stack : hitEntity.m_6167_()) {
                        if (stack == null || !stack.m_204117_(BzTags.ENDERPEARL_TARGET_HELD_ITEM)) continue;
                        passedCheck = true;
                        break;
                    }
                    for (ItemStack stack : hitEntity.m_6168_()) {
                        if (stack == null || !stack.m_204117_(BzTags.ENDERPEARL_TARGET_ARMOR)) continue;
                        Vec3 hitPos = pearlEntity.m_20182_();
                        AABB boundBox = entityHitResult.m_82443_().m_20191_();
                        double relativeHitY = hitPos.m_7098_() - boundBox.f_82289_;
                        double entityBoundHeight = boundBox.f_82292_ - boundBox.f_82289_;
                        double minYThreshold = -2.147483648E9;
                        double maxYThreshold = 2.147483647E9;
                        Item item = stack.m_41720_();
                        if (item instanceof ArmorItem) {
                            ArmorItem armorItem = (ArmorItem)item;
                            switch (armorItem.m_40402_()) {
                                case HEAD: {
                                    minYThreshold = entityBoundHeight * 0.66;
                                    break;
                                }
                                case CHEST: {
                                    minYThreshold = entityBoundHeight * 0.4;
                                    break;
                                }
                                case LEGS: {
                                    maxYThreshold = entityBoundHeight * 0.6;
                                    break;
                                }
                                case FEET: {
                                    maxYThreshold = entityBoundHeight * 0.33;
                                }
                            }
                        }
                        if (relativeHitY > maxYThreshold || relativeHitY < minYThreshold) continue;
                        passedCheck = true;
                        break;
                    }
                    if (!passedCheck) {
                        return false;
                    }
                    BlockPos hivePos = entityHitResult.m_82443_().m_20183_();
                    boolean validBelowBlock = false;
                    Optional blockTag = BuiltInRegistries.f_256975_.m_203431_(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT);
                    if (blockTag.isPresent() && GeneralUtils.getListOfNonDummyBlocks(blockTag).size() != 0) {
                        if (world.m_8055_(hivePos.m_7495_()).m_204336_(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT)) {
                            validBelowBlock = true;
                        } else if (((Boolean)BzDimensionConfigs.warnPlayersOfWrongBlockUnderHive.get()).booleanValue()) {
                            Bumblezone.LOGGER.log(org.apache.logging.log4j.Level.INFO, "Bumblezone: The attempt to teleport to Bumblezone failed due to not having a block from the following block tag below the hive: the_bumblezone:required_blocks_under_hive_to_teleport");
                            MutableComponent message = Component.m_237115_((String)"system.the_bumblezone.require_hive_blocks_failed");
                            playerEntity.m_5661_((Component)message, true);
                            return false;
                        }
                    } else {
                        validBelowBlock = true;
                    }
                    if (validBelowBlock) {
                        BzCriterias.TELEPORT_TO_BUMBLEZONE_PEARL_TRIGGER.trigger(playerEntity);
                        BzWorldSavedData.queueEntityToTeleport((Entity)playerEntity, BzDimension.BZ_WORLD_KEY);
                        pearlEntity.m_146870_();
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static BlockPos getNearbyHivePos(Vec3 hitBlockPos, Level world) {
        double checkRadius = 0.5;
        for (double offset = -checkRadius; offset <= checkRadius; offset += checkRadius) {
            for (double offset2 = -checkRadius; offset2 <= checkRadius; offset2 += checkRadius) {
                for (double offset3 = -checkRadius; offset3 <= checkRadius; offset3 += checkRadius) {
                    BlockPos offsettedHitPos = new BlockPos(hitBlockPos.m_82520_(offset, offset2, offset3));
                    BlockState block = world.m_8055_(offsettedHitPos);
                    if (!EntityTeleportationBackend.isValidBeeHive(block)) continue;
                    return offsettedHitPos;
                }
            }
        }
        return null;
    }

    public static void runPistonPushed(Direction direction, LivingEntity pushedEntity) {
        ServerLevel world = (ServerLevel)pushedEntity.f_19853_;
        if (((Boolean)BzDimensionConfigs.enableEntranceTeleportation.get()).booleanValue() && !world.m_46472_().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID) && (!((Boolean)BzDimensionConfigs.onlyOverworldHivesTeleports.get()).booleanValue() || world.m_46472_().equals((Object)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation((String)BzDimensionConfigs.defaultDimension.get()))))) {
            if (BzWorldSavedData.isEntityQueuedToTeleportAlready((Entity)pushedEntity)) {
                return;
            }
            BlockPos.MutableBlockPos entityPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pushedEntity.m_20183_());
            BlockPos[] blockPositions = new BlockPos[]{entityPos, entityPos.m_121945_(direction), entityPos.m_121945_(Direction.UP), entityPos.m_121945_(Direction.UP).m_121945_(direction)};
            ArrayList<BlockState> belowHiveBlocks = new ArrayList<BlockState>();
            boolean isPushedIntoBeehive = false;
            for (BlockPos pos : blockPositions) {
                if (!EntityTeleportationBackend.isValidBeeHive(world.m_8055_(pos))) continue;
                isPushedIntoBeehive = true;
                belowHiveBlocks.add(world.m_8055_(pos.m_7495_()));
            }
            if (isPushedIntoBeehive) {
                boolean validBelowBlock = false;
                Optional blockTag = BuiltInRegistries.f_256975_.m_203431_(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT);
                if (blockTag.isPresent() && GeneralUtils.getListOfNonDummyBlocks(blockTag).size() != 0) {
                    for (BlockState belowBlock : belowHiveBlocks) {
                        if (!belowBlock.m_204336_(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT)) continue;
                        validBelowBlock = true;
                    }
                    if (!validBelowBlock && ((Boolean)BzDimensionConfigs.warnPlayersOfWrongBlockUnderHive.get()).booleanValue()) {
                        if (pushedEntity instanceof Player) {
                            Player playerEntity = (Player)pushedEntity;
                            Bumblezone.LOGGER.log(org.apache.logging.log4j.Level.INFO, "Bumblezone: The attempt to teleport to Bumblezone failed due to not having a block from the following block tag below the hive: the_bumblezone:required_blocks_under_hive_to_teleport");
                            MutableComponent message = Component.m_237115_((String)"system.the_bumblezone.require_hive_blocks_failed");
                            playerEntity.m_5661_((Component)message, true);
                        }
                        return;
                    }
                } else {
                    validBelowBlock = true;
                }
                if (validBelowBlock) {
                    if (pushedEntity instanceof ServerPlayer) {
                        BzCriterias.TELEPORT_TO_BUMBLEZONE_PISTON_TRIGGER.trigger((ServerPlayer)pushedEntity);
                    }
                    BzWorldSavedData.queueEntityToTeleport((Entity)pushedEntity, BzDimension.BZ_WORLD_KEY);
                }
            }
        }
    }

    private static void checkAndCorrectStoredDimension(LivingEntity livingEntity) {
        livingEntity.getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY).ifPresent(capability -> {
            if (capability.getNonBZDim().equals((Object)Bumblezone.MOD_DIMENSION_ID) || ((Boolean)BzDimensionConfigs.forceExitToOverworld.get()).booleanValue()) {
                capability.setNonBZDim(new ResourceLocation((String)BzDimensionConfigs.defaultDimension.get()));
            }
        });
    }
}

