/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.mobs;

import com.telepathicgrunt.the_bumblezone.entities.controllers.HoneySlimeMoveHelperController;
import com.telepathicgrunt.the_bumblezone.entities.goals.HoneySlimeFaceRandomGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.HoneySlimeFacingRevengeGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.HoneySlimeFloatGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.HoneySlimeHopGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.HoneySlimeTemptGoal;
import com.telepathicgrunt.the_bumblezone.items.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.Vec3;

public class HoneySlimeEntity
extends Animal
implements NeutralMob,
Enemy {
    private static final EntityDataAccessor<Boolean> IN_HONEY = SynchedEntityData.m_135353_(HoneySlimeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> IN_HONEY_GROWTH_TIME = SynchedEntityData.m_135353_(HoneySlimeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANGRY_TIMER = SynchedEntityData.m_135353_(HoneySlimeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt MAX_ANGER_DURATION = TimeUtil.m_145020_((int)22, (int)36);
    private static final Ingredient LURING_BREEDING_ITEM = Ingredient.m_204132_(BzTags.HONEY_SLIME_DESIRED_ITEMS);
    private UUID target_UUID;
    private static final HashSet<Block> HONEY_BASED_BLOCKS = new HashSet();
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private boolean wasOnGround;

    public HoneySlimeEntity(Level worldIn) {
        super((EntityType)BzEntities.HONEY_SLIME.get(), worldIn);
    }

    public HoneySlimeEntity(EntityType<? extends HoneySlimeEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new HoneySlimeMoveHelperController(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new HoneySlimeFloatGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HoneySlimeFacingRevengeGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new HoneySlimeTemptGoal(this, 1.2, LURING_BREEDING_ITEM));
        this.f_21345_.m_25352_(4, (Goal)new HoneySlimeHopGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new HoneySlimeFaceRandomGoal(this));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        this.setupHoneySlime(this.m_6162_(), true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IN_HONEY, (Object)true);
        this.f_19804_.m_135372_(IN_HONEY_GROWTH_TIME, (Object)0);
        this.f_19804_.m_135372_(ANGRY_TIMER, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        this.m_6210_();
        this.m_146922_(this.f_20885_);
        this.m_5618_(this.f_20885_);
        if (this.m_20069_() && this.f_19796_.m_188503_(20) == 0) {
            this.m_5841_();
        }
        super.m_7350_(key);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("inHoney", this.isInHoney());
        compound.m_128405_("inHoneyGrowthTimer", this.getInHoneyGrowthTime());
        compound.m_128379_("wasOnGround", this.wasOnGround);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setInHoney(compound.m_128471_("inHoney"));
        this.setInHoneyGrowthTime(compound.m_128451_("inHoneyGrowthTimer"));
        this.wasOnGround = compound.m_128471_("wasOnGround");
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 2.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    public boolean m_5545_(LevelAccessor world, MobSpawnType spawnReason) {
        return true;
    }

    protected void setupHoneySlime(boolean isBaby, boolean resetHealth) {
        this.m_20090_();
        this.m_6210_();
        Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(isBaby ? 2.0 : 8.0);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_((double)((0.2f + 0.1f * (float)(isBaby ? 1 : 2)) * 2.0f));
        Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22100_(isBaby ? 1.0 : 3.0);
        if (resetHealth) {
            this.m_21153_(this.m_21233_());
        }
        this.f_21364_ = isBaby ? 1 : 2;
    }

    public boolean isInHoney() {
        return (Boolean)this.f_19804_.m_135370_(IN_HONEY);
    }

    public void setInHoney(boolean value) {
        this.f_19804_.m_135381_(IN_HONEY, (Object)value);
    }

    public int getInHoneyGrowthTime() {
        return (Integer)this.f_19804_.m_135370_(IN_HONEY_GROWTH_TIME);
    }

    public void setInHoneyGrowthTime(int value) {
        this.f_19804_.m_135381_(IN_HONEY_GROWTH_TIME, (Object)value);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        if (distance > 1.0f) {
            this.m_5496_(this.m_6162_() ? (SoundEvent)BzSounds.HONEY_SLIME_SQUISH_SMALL.get() : (SoundEvent)BzSounds.HONEY_SLIME_SQUISH.get(), 0.4f, 1.0f);
        }
        int fallDamage = this.m_5639_(distance, damageMultiplier);
        if (this.isInHoney()) {
            fallDamage = (int)((float)fallDamage * 0.35f - 3.0f);
        }
        if (fallDamage <= 0) {
            return false;
        }
        this.m_6469_(damageSource, fallDamage);
        this.m_21229_();
        return true;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!this.m_6162_() && this.isInHoney() && itemstack.m_41720_() == Items.f_42590_) {
            this.f_19853_.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11770_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!player.m_7500_()) {
                GeneralUtils.givePlayerItem(player, hand, new ItemStack((ItemLike)Items.f_42787_), false, true);
            }
            this.getHoneyFromSlime((LivingEntity)this);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!EssenceOfTheBees.hasEssence(serverPlayer)) {
                    this.m_6703_((LivingEntity)player);
                }
                BzCriterias.HONEY_SLIME_HARVEST_TRIGGER.trigger(serverPlayer);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private void getHoneyFromSlime(LivingEntity entity) {
        if (entity instanceof HoneySlimeEntity) {
            this.setInHoney(false);
            this.setInHoneyGrowthTime(-14400);
        }
    }

    public void m_8119_() {
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.m_8119_();
        if (this.f_19861_ && !this.wasOnGround) {
            int i = 2;
            if (this.spawnCustomParticles()) {
                i = 0;
            }
            for (int j = 0; j < i * 8; ++j) {
                float f = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                float f1 = this.f_19796_.m_188501_() * 0.5f + 0.5f;
                float f2 = Mth.m_14031_((float)f) * (float)i * 0.5f * f1;
                float f3 = Mth.m_14089_((float)f) * (float)i * 0.5f * f1;
                this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Blocks.f_50719_)), this.m_20185_() + (double)f2, this.m_20186_(), this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
            }
            this.m_5496_(this.getSquishSound(), this.m_6121_(), ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) / 0.8f);
            this.squishAmount = -0.5f;
        } else if (!this.f_19861_ && this.wasOnGround) {
            this.squishAmount = 1.0f;
        }
        this.wasOnGround = this.f_19861_;
        this.alterSquishAmount();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            if (!this.isInHoney()) {
                this.setInHoneyGrowthTime(this.getInHoneyGrowthTime() + 1);
                if (HONEY_BASED_BLOCKS.isEmpty()) {
                    HONEY_BASED_BLOCKS.addAll(Stream.of(Blocks.f_50719_, (Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get(), (Block)BzBlocks.HONEYCOMB_BROOD.get(), (Block)BzBlocks.STICKY_HONEY_REDSTONE.get(), (Block)BzBlocks.STICKY_HONEY_RESIDUE.get()).collect(Collectors.toCollection(HashSet::new)));
                }
                if (!this.f_19853_.m_5776_() && HONEY_BASED_BLOCKS.contains(this.f_19853_.m_8055_(this.m_20183_().m_7495_()).m_60734_()) && (double)this.f_19796_.m_188501_() < 0.001) {
                    this.setInHoneyGrowthTime(0);
                }
            }
            this.setInHoney(this.getInHoneyGrowthTime() >= 0);
        }
    }

    protected void m_8024_() {
        if (!this.f_19853_.m_5776_()) {
            this.m_21666_((ServerLevel)this.f_19853_, false);
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return LURING_BREEDING_ITEM.test(stack);
    }

    public AgeableMob m_142606_(ServerLevel worldIn, AgeableMob ageable) {
        HoneySlimeEntity childHoneySlimeEntity = (HoneySlimeEntity)((EntityType)BzEntities.HONEY_SLIME.get()).m_20615_((Level)worldIn);
        if (childHoneySlimeEntity != null) {
            childHoneySlimeEntity.setupHoneySlime(true, true);
        }
        return childHoneySlimeEntity;
    }

    protected void m_30232_() {
        super.m_30232_();
        if (!this.m_6162_()) {
            this.setupHoneySlime(false, true);
        }
    }

    protected void dealDamage(LivingEntity entityIn) {
        if (this.m_6084_()) {
            int i = 2;
            if (this.m_20280_((Entity)entityIn) < 0.6 * (double)i * 0.6 * (double)i && this.m_142582_((Entity)entityIn) && entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), this.getAttackStrength())) {
                this.m_5496_((SoundEvent)BzSounds.HONEY_SLIME_ATTACK.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                this.dealDamage(entityIn);
            }
        }
    }

    public boolean canDamagePlayer() {
        return !this.m_6162_() && this.m_6142_();
    }

    public void m_6123_(Player entityIn) {
        if (this.canDamagePlayer() && this.m_5448_() == entityIn) {
            this.dealDamage((LivingEntity)entityIn);
        }
    }

    public EntityType<? extends HoneySlimeEntity> m_6095_() {
        return super.m_6095_();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.625f * sizeIn.f_20378_;
    }

    public void m_6210_() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        super.m_6210_();
        this.m_20248_(x, y, z);
    }

    public boolean m_6573_(Player player) {
        return !this.m_21523_() && this.f_20888_ != player;
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    public int getJumpDelay() {
        return this.f_19796_.m_188503_(20) + 10;
    }

    protected float getAttackStrength() {
        return (float)Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22135_();
    }

    protected ResourceLocation m_7582_() {
        return this.m_6162_() ? BuiltInLootTables.f_78712_ : this.m_6095_().m_20677_();
    }

    public float m_6121_() {
        return 0.4f * (float)(this.m_6162_() ? 1 : 2);
    }

    public int m_8132_() {
        return 0;
    }

    public boolean makesSoundOnJump() {
        return !this.m_6162_();
    }

    protected void m_6135_() {
        Vec3 vec3d = this.m_20184_();
        if (this.m_21660_()) {
            this.m_20334_(vec3d.f_82479_ * 5.0, this.m_6118_() * 1.3f, vec3d.f_82481_ * 5.0);
        } else {
            this.m_20334_(vec3d.f_82479_, this.m_6118_(), vec3d.f_82481_);
        }
        this.f_19812_ = true;
    }

    protected boolean spawnCustomParticles() {
        return false;
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(ANGRY_TIMER);
    }

    public void m_7870_(int ticks) {
        this.f_19804_.m_135381_(ANGRY_TIMER, (Object)ticks);
    }

    public UUID m_6120_() {
        return this.target_UUID;
    }

    public void m_6925_(UUID uuid) {
        this.target_UUID = uuid;
    }

    public void m_6825_() {
        this.m_7870_(MAX_ANGER_DURATION.m_214085_(this.f_19796_));
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return this.m_6162_() ? (SoundEvent)BzSounds.HONEY_SLIME_HURT_SMALL.get() : (SoundEvent)BzSounds.HONEY_SLIME_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return this.m_6162_() ? (SoundEvent)BzSounds.HONEY_SLIME_DEATH_SMALL.get() : (SoundEvent)BzSounds.HONEY_SLIME_DEATH.get();
    }

    protected SoundEvent getSquishSound() {
        return this.m_6162_() ? (SoundEvent)BzSounds.HONEY_SLIME_SQUISH_SMALL.get() : (SoundEvent)BzSounds.HONEY_SLIME_SQUISH.get();
    }

    public SoundEvent getJumpSound() {
        return this.m_6162_() ? (SoundEvent)BzSounds.HONEY_SLIME_JUMP_SMALL.get() : (SoundEvent)BzSounds.HONEY_SLIME_JUMP.get();
    }
}

