/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.queentrades;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.QueenTradesCollectionObj;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.TradeEntryObj;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.TradeEntryReducedObj;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class QueensTradeManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();
    public static final QueensTradeManager QUEENS_TRADE_MANAGER = new QueensTradeManager();
    public Object2ObjectOpenHashMap<Item, WeightedRandomList<TradeEntryReducedObj>> tradeReduced = new Object2ObjectOpenHashMap();
    public Map<List<TradeEntryObj>, List<TradeEntryObj>> tradeRaw = new HashMap<List<TradeEntryObj>, List<TradeEntryObj>>();

    public QueensTradeManager() {
        super(GSON, "bz_bee_queen_trades");
    }

    protected void apply(Map<ResourceLocation, JsonElement> loader, ResourceManager manager, ProfilerFiller profiler) {
        this.tradeRaw.clear();
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                QueenTradesCollectionObj tradesCollection = (QueenTradesCollectionObj)GSON.fromJson(jsonElement, QueenTradesCollectionObj.class);
                if (tradesCollection.wants.isEmpty() || tradesCollection.possible_rewards.isEmpty()) {
                    return;
                }
                this.tradeRaw.put(tradesCollection.wants, tradesCollection.possible_rewards);
            }
            catch (Exception e) {
                Bumblezone.LOGGER.error("Bumblezone Error: Couldn't parse bee queen trades file {}", fileIdentifier, (Object)e);
            }
        });
    }

    public void resolveQueenTrades(TagsUpdatedEvent event) {
        if (this.tradeRaw.isEmpty()) {
            return;
        }
        Object2ObjectOpenHashMap reducedTradeMap = new Object2ObjectOpenHashMap();
        for (Map.Entry<List<TradeEntryObj>, List<TradeEntryObj>> entry : this.tradeRaw.entrySet()) {
            ArrayList wants = new ArrayList();
            ArrayList rewards = new ArrayList();
            entry.getKey().forEach(value -> {
                Set<Object> items = null;
                if (value.id.startsWith("#")) {
                    ResourceLocation tagRl = new ResourceLocation(value.id.substring(1));
                    TagKey itemTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagRl);
                    Optional taggedItems = BuiltInRegistries.f_257033_.m_203431_(itemTag);
                    if (taggedItems.isPresent()) {
                        items = ((HolderSet.Named)taggedItems.get()).m_203614_().map(Holder::m_203334_).collect(Collectors.toSet());
                    } else if (value.isRequired()) {
                        Bumblezone.LOGGER.error("Bumblezone Error: Couldn't find want item tag {} in bee queen trades file", (Object)value.id);
                    }
                } else {
                    Optional item = ForgeRegistries.ITEMS.getHolder(new ResourceLocation(value.id));
                    if (item.isPresent()) {
                        items = Set.of((Item)((Holder)item.get()).m_203334_());
                    } else if (value.isRequired()) {
                        Bumblezone.LOGGER.error("Bumblezone Error: Couldn't find want item {} in bee queen trades file", (Object)value.id);
                    }
                }
                if (items == null) {
                    return;
                }
                wants.addAll(items);
            });
            entry.getValue().forEach(value -> {
                if (value.id.startsWith("#")) {
                    ResourceLocation tagRl = new ResourceLocation(value.id.substring(1));
                    TagKey itemTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagRl);
                    Optional taggedItems = BuiltInRegistries.f_257033_.m_203431_(itemTag);
                    if (taggedItems.isPresent()) {
                        for (Holder itemHolder : (HolderSet.Named)taggedItems.get()) {
                            rewards.add(new TradeEntryReducedObj((Item)itemHolder.get(), value.getCount(), value.getXpReward(), value.getWeight()));
                        }
                    } else if (value.isRequired()) {
                        Bumblezone.LOGGER.error("Bumblezone Error: Couldn't find reward item tag {} in bee queen trades file", (Object)value.id);
                    }
                } else {
                    Optional item = ForgeRegistries.ITEMS.getHolder(new ResourceLocation(value.id));
                    if (item.isPresent()) {
                        rewards.add(new TradeEntryReducedObj((Item)((Holder)item.get()).m_203334_(), value.getCount(), value.getXpReward(), value.getWeight()));
                    } else if (value.isRequired()) {
                        Bumblezone.LOGGER.error("Bumblezone Error: Couldn't find reward item {} in bee queen trades file", (Object)value.id);
                    }
                }
            });
            if (wants.isEmpty() || rewards.isEmpty()) continue;
            for (Item item : wants) {
                WeightedRandomList existingRewards = (WeightedRandomList)reducedTradeMap.get((Object)item);
                if (existingRewards == null) {
                    reducedTradeMap.put((Object)item, (Object)WeightedRandomList.m_146328_(rewards));
                    continue;
                }
                ArrayList newWants = new ArrayList();
                newWants.addAll(existingRewards.m_146338_());
                newWants.addAll(rewards);
                reducedTradeMap.put((Object)item, (Object)WeightedRandomList.m_146328_(newWants));
            }
        }
        this.tradeReduced = reducedTradeMap;
        this.tradeRaw.clear();
    }
}

