/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.fluids;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;

public class SugarWaterFluidType
extends FluidType {
    public static final ResourceLocation FLUID_STILL_TEXTURE = new ResourceLocation("the_bumblezone", "block/sugar_water_still");
    public static final ResourceLocation FLUID_FLOWING_TEXTURE = new ResourceLocation("the_bumblezone", "block/sugar_water_flow");
    public static final ResourceLocation FLUID_OVERLAY_TEXTURE = new ResourceLocation("the_bumblezone", "block/sugar_water_overlay");
    private static final ResourceLocation TEXTURE_UNDERWATER = new ResourceLocation("the_bumblezone", "textures/misc/sugar_water_underwater.png");

    public SugarWaterFluidType() {
        super(FluidType.Properties.create().supportsBoating(true).canHydrate(true).canDrown(true).canExtinguish(true).canPushEntity(true).canSwim(true).pathType(BlockPathTypes.WATER).adjacentPathType(BlockPathTypes.WATER_BORDER).canConvertToSource(true).fallDistanceModifier(0.0f).motionScale(0.014).rarity(Rarity.COMMON).viscosity(1100).density(1100).temperature(300).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_));
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return FLUID_STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return FLUID_FLOWING_TEXTURE;
            }

            public ResourceLocation getOverlayTexture() {
                return FLUID_OVERLAY_TEXTURE;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return TEXTURE_UNDERWATER;
            }

            public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                return BiomeColors.m_108811_((BlockAndTintGetter)getter, (BlockPos)pos) | 0xFF000000;
            }
        });
    }
}

