/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.client.rendering.beearmor.BeeArmorModel;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public abstract class BeeArmor
extends ArmorItem {
    private final int variant;
    private final boolean transTexture;

    public BeeArmor(ArmorMaterial material, EquipmentSlot slot, Item.Properties properties, int variant, boolean transTexture) {
        super(material, slot, properties);
        this.variant = variant;
        this.transTexture = transTexture;
    }

    public int getVariant() {
        return this.variant;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        if (this.transTexture) {
            return "the_bumblezone:textures/models/armor/trans_bee_material_layer_" + this.variant + ".png";
        }
        return "the_bumblezone:textures/models/armor/bee_material_layer_" + this.variant + ".png";
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private BeeArmorModel model;
            private int variant;

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
                BeeArmor beeArmor;
                Item item;
                if (this.model == null || (item = itemStack.m_41720_()) instanceof BeeArmor && this.variant != (beeArmor = (BeeArmor)item).getVariant()) {
                    ModelPart layer = null;
                    Item item2 = itemStack.m_41720_();
                    if (item2 instanceof BeeArmor) {
                        BeeArmor beeArmor2 = (BeeArmor)item2;
                        int newVariant = beeArmor2.getVariant();
                        if (newVariant == 1) {
                            layer = Minecraft.m_91087_().m_167973_().m_171103_(BeeArmorModel.VARIANT_1_LAYER_LOCATION);
                        } else if (newVariant == 2) {
                            layer = Minecraft.m_91087_().m_167973_().m_171103_(BeeArmorModel.VARIANT_2_LAYER_LOCATION);
                        }
                        this.variant = newVariant;
                    }
                    if (layer == null) {
                        layer = Minecraft.m_91087_().m_167973_().m_171103_(BeeArmorModel.VARIANT_1_LAYER_LOCATION);
                    }
                    this.model = new BeeArmorModel(layer, armorSlot, entityLiving);
                }
                this.model.entityLiving = entityLiving;
                return this.model;
            }
        });
    }
}

