/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import com.telepathicgrunt.the_bumblezone.items.StinglessBeeHelmet;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class CarpenterBeeBoots
extends BeeArmor {
    public CarpenterBeeBoots(ArmorMaterial material, EquipmentSlot slot, Item.Properties properties, int variant) {
        super(material, slot, properties, variant, false);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_204117_(BzTags.BEE_ARMOR_REPAIR_ITEMS);
    }

    public void onArmorTick(ItemStack beeBoots, Level world, Player player) {
        int maxHangTime;
        RandomSource random = player.m_217043_();
        boolean isAllBeeArmorOn = StinglessBeeHelmet.isAllBeeArmorOn((Entity)player);
        CompoundTag tag = beeBoots.m_41784_();
        if (!world.m_5776_()) {
            int itemId = CarpenterBeeBoots.generateUniqueItemId(world, random, tag, tag.m_128451_("itemstackId"));
            int lastSentState = tag.m_128451_("lastSentState");
            double xInBlock = Math.abs(player.m_20182_().m_7096_()) % 1.0;
            double zInBlock = Math.abs(player.m_20182_().m_7094_()) % 1.0;
            if (player.m_6144_() && player.m_20154_().m_7098_() < -0.9 && xInBlock > 0.2 && xInBlock < 0.8 && zInBlock > 0.2 && zInBlock < 0.8) {
                belowBlockPos = new BlockPos(player.m_20182_().m_82520_(0.0, -0.1, 0.0));
                BlockState belowBlockState = world.m_8055_(belowBlockPos);
                if (belowBlockState.m_204336_(BzTags.CARPENTER_BEE_BOOTS_MINEABLES)) {
                    int miningStartTime = tag.m_128451_("miningStartTime");
                    if (miningStartTime == 0) {
                        miningStartTime = (int)world.m_46467_();
                        if (!world.m_5776_()) {
                            tag.m_128405_("miningStartTime", miningStartTime);
                        }
                    }
                    int timeDiff = (int)world.m_46467_() - miningStartTime;
                    float miningProgress = timeDiff + 1;
                    float blockDestroyTime = belowBlockState.m_60800_((BlockGetter)world, belowBlockPos);
                    float playerMiningSpeed = CarpenterBeeBoots.getPlayerDestroySpeed(player, beeBoots, isAllBeeArmorOn ? 0.5f : 0.3f);
                    int finalMiningProgress = (int)(miningProgress * playerMiningSpeed / blockDestroyTime);
                    if (!(finalMiningProgress == 0 && playerMiningSpeed < 0.001f || finalMiningProgress == lastSentState)) {
                        world.m_6801_(itemId, belowBlockPos, finalMiningProgress);
                        tag.m_128405_("lastSentState", finalMiningProgress);
                    }
                    if (finalMiningProgress >= 10) {
                        world.m_6801_(itemId, belowBlockPos, -1);
                        BlockState state = world.m_8055_(belowBlockPos);
                        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, belowBlockPos, state, player);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (event.isCanceled()) {
                            return;
                        }
                        boolean blockBroken = world.m_46953_(belowBlockPos, false, (Entity)player);
                        if (blockBroken) {
                            BlockEntity blockEntity = belowBlockState.m_155947_() ? world.m_7702_(belowBlockPos) : null;
                            belowBlockState.m_60734_().m_6240_(world, player, belowBlockPos, belowBlockState, blockEntity, beeBoots);
                            if ((double)random.m_188501_() < 0.045) {
                                beeBoots.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21166_(EquipmentSlot.FEET));
                            }
                            if (player instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)player;
                                serverPlayer.m_36220_((ResourceLocation)BzStats.CARPENTER_BEE_BOOTS_MINED_BLOCKS_RL.get());
                                if (serverPlayer.m_8951_().m_13015_(Stats.f_12988_.m_12899_((Object)((ResourceLocation)BzStats.CARPENTER_BEE_BOOTS_MINED_BLOCKS_RL.get()), StatFormatter.f_12873_)) >= 200) {
                                    BzCriterias.CARPENTER_BEE_BOOTS_MINED_BLOCKS_TRIGGER.trigger(serverPlayer);
                                }
                            }
                        }
                        tag.m_128405_("lastSentState", -1);
                        tag.m_128405_("miningStartTime", 0);
                    }
                } else {
                    world.m_6801_(itemId, belowBlockPos, -1);
                    tag.m_128405_("lastSentState", -1);
                    tag.m_128405_("miningStartTime", 0);
                }
            } else if (lastSentState != -1) {
                belowBlockPos = new BlockPos(player.m_20182_().m_82520_(0.0, -0.1, 0.0));
                world.m_6801_(itemId, belowBlockPos, -1);
                tag.m_128405_("lastSentState", -1);
                tag.m_128405_("miningStartTime", 0);
            }
        }
        int hangTime = tag.m_128451_("hangTime");
        if (!world.m_5776_() && hangTime > 0 && player.m_20096_()) {
            hangTime = 0;
            tag.m_128405_("hangTime", hangTime);
        }
        double playerDeltaY = player.m_20184_().m_7098_();
        int hangCooldownTimer = tag.m_128451_("hangCooldownTimer");
        int n = maxHangTime = isAllBeeArmorOn ? 100 : 35;
        if (!(player.m_150110_().f_35935_ || player.m_20159_() || player.m_6147_() || player.m_20096_() || player.m_20069_() || player.m_6144_() || !(playerDeltaY <= 0.0) || !(playerDeltaY >= (double)-1.2f) || hangCooldownTimer > 0)) {
            for (float xOffset = -0.45f; xOffset <= 0.45f; xOffset += 0.45f) {
                for (float zOffset = -0.45f; zOffset <= 0.45f; zOffset += 0.45f) {
                    BlockPos posToCheck;
                    BlockState sideBlockState;
                    if (xOffset == 0.0f || zOffset == 0.0f || !(sideBlockState = world.m_8055_(posToCheck = new BlockPos(player.m_20182_().m_82520_((double)xOffset, (double)0.057f, (double)zOffset)))).m_204336_(BzTags.CARPENTER_BEE_BOOTS_CLIMBABLES)) continue;
                    double newDeltaY = Math.min(playerDeltaY * 0.9 + 0.07, -0.0055);
                    player.m_20256_(new Vec3(player.m_20184_().m_7096_(), newDeltaY, player.m_20184_().m_7094_()));
                    if (newDeltaY >= (double)-0.0135f) {
                        player.m_6862_(false);
                        player.m_6853_(true);
                    }
                    if (newDeltaY >= (double)-0.4f) {
                        player.f_19789_ = 0.0f;
                    }
                    if (!world.m_5776_()) {
                        if (hangTime >= maxHangTime) {
                            tag.m_128405_("hangCooldownTimer", 10);
                            tag.m_128405_("hangTime", 0);
                        } else {
                            tag.m_128405_("hangTime", hangTime + 1);
                            if (player instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)player;
                                serverPlayer.m_36220_((ResourceLocation)BzStats.CARPENTER_BEE_BOOTS_WALL_HANG_TIME_RL.get());
                                if (serverPlayer.m_8951_().m_13015_(Stats.f_12988_.m_12899_((Object)((ResourceLocation)BzStats.CARPENTER_BEE_BOOTS_WALL_HANG_TIME_RL.get()), StatFormatter.f_12873_)) >= 4000) {
                                    BzCriterias.CARPENTER_BEE_BOOTS_WALL_HANGING_TRIGGER.trigger(serverPlayer);
                                }
                            }
                        }
                    }
                    if (!((double)random.m_188501_() < 0.001)) continue;
                    beeBoots.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21166_(EquipmentSlot.FEET));
                }
            }
        } else if (!world.m_5776_() && hangCooldownTimer > 0) {
            int newCoolDown = hangCooldownTimer - 1;
            tag.m_128405_("hangCooldownTimer", newCoolDown);
        }
    }

    public static float getPlayerDestroySpeed(Player player, ItemStack beeBoots, float currentSpeed) {
        int efficencyLevel = beeBoots.getEnchantmentLevel(Enchantments.f_44984_);
        if (efficencyLevel > 0) {
            currentSpeed += (float)efficencyLevel / 4.0f;
        }
        if (MobEffectUtil.m_19584_((LivingEntity)player)) {
            currentSpeed *= 1.0f + (float)(MobEffectUtil.m_19586_((LivingEntity)player) + 1) * 0.2f;
        }
        if (player.m_21023_((MobEffect)BzEffects.BEENERGIZED.get())) {
            currentSpeed *= 1.0f + (float)(player.m_21124_((MobEffect)BzEffects.BEENERGIZED.get()).m_19564_() + 1);
        }
        if (player.m_21023_(MobEffects.f_19599_)) {
            float miningDecrease = switch (player.m_21124_(MobEffects.f_19599_).m_19564_()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            currentSpeed *= miningDecrease;
        }
        if (player.m_204029_(FluidTags.f_13131_) && !EnchantmentHelper.m_44934_((LivingEntity)player)) {
            currentSpeed /= 5.0f;
        }
        if (!player.m_20096_()) {
            currentSpeed /= 5.0f;
        }
        return currentSpeed;
    }

    private static int generateUniqueItemId(Level world, RandomSource random, CompoundTag tag, int itemId) {
        if (itemId == 0 && !world.m_5776_()) {
            boolean anymatch;
            block0: do {
                anymatch = false;
                itemId = random.m_188503_(Integer.MAX_VALUE);
                for (Player worldPlayer : world.m_6907_()) {
                    if (worldPlayer.m_19879_() != itemId) continue;
                    anymatch = true;
                    continue block0;
                }
            } while (anymatch);
            tag.m_128405_("itemstackId", itemId);
        }
        return itemId;
    }

    public static ItemStack getEntityBeeBoots(Entity entity) {
        for (ItemStack armor : entity.m_6168_()) {
            if (!(armor.m_41720_() instanceof CarpenterBeeBoots)) continue;
            return armor;
        }
        return ItemStack.f_41583_;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.f_44672_ == EnchantmentCategory.DIGGER) {
            return true;
        }
        return enchantment.f_44672_.m_7454_(stack.m_41720_());
    }
}

