/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzLootFunctionTypes;
import com.telepathicgrunt.the_bumblezone.utils.ThreadExecutor;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class PrefillMap
extends LootItemConditionalFunction {
    final int scaleLevel;

    public PrefillMap(LootItemCondition[] lootItemConditions, int scaleLevel) {
        super(lootItemConditions);
        this.scaleLevel = scaleLevel;
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)BzLootFunctionTypes.PREFILL_MAP.get();
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81460_);
    }

    public ItemStack m_7372_(ItemStack itemStack, LootContext lootContext) {
        if (itemStack.m_150930_(Items.f_42676_)) {
            Vec3 vec3 = (Vec3)lootContext.m_78953_(LootContextParams.f_81460_);
            if (vec3 != null) {
                BlockPos blockPos = new BlockPos(vec3);
                ItemStack newFilledMap = MapItem.m_42886_((Level)lootContext.m_78952_(), (int)blockPos.m_123341_(), (int)blockPos.m_123343_(), (byte)((byte)this.scaleLevel), (boolean)true, (boolean)true);
                Integer mapId = MapItem.m_151131_((ItemStack)newFilledMap);
                MapItemSavedData data = MapItem.m_151128_((Integer)mapId, (Level)lootContext.m_78952_());
                if (data != null) {
                    ThreadExecutor.mapFilling(lootContext.m_78952_(), blockPos, data);
                    newFilledMap.m_41751_(newFilledMap.m_41784_().m_128391_(itemStack.m_41784_()));
                    return newFilledMap;
                }
            } else if (itemStack.m_41782_()) {
                itemStack.m_41751_(new CompoundTag());
            }
        }
        return itemStack;
    }

    public static void update(Level level, BlockPos blockPos, MapItemSavedData data) {
        if (level.m_46472_() == data.f_77887_) {
            boolean bumblezoneDim = level.m_46472_().equals(BzDimension.BZ_WORLD_KEY);
            boolean ceilingDim = level.m_6042_().f_63856_();
            int scale = 1 << data.f_77890_;
            int xStart = data.f_256718_;
            int zStart = data.f_256789_;
            int intervalSpacing = 2;
            int radiusToSkip = ceilingDim ? 64 : 128;
            for (int scanX = 0; scanX < 128; scanX += intervalSpacing) {
                double d0 = 0.0;
                for (int scanZ = 0; scanZ < 128; scanZ += intervalSpacing) {
                    double slopeState;
                    double d2;
                    int zDiff;
                    int blockPosX = (xStart / scale + scanX - 64) * scale;
                    int blockPosZ = (zStart / scale + scanZ - 64) * scale;
                    int xDiff = Math.abs(blockPos.m_123341_() - blockPosX);
                    if (xDiff * xDiff + (zDiff = Math.abs(blockPos.m_123343_() - blockPosZ)) * zDiff < radiusToSkip * radiusToSkip || scanX % 18 > 9 || scanZ % 18 > 9 || (scanX % 9 == 0 || scanX % 9 == 8) && (scanZ % 9 == 0 || scanZ % 9 == 8)) continue;
                    BlockPos currentPos = new BlockPos(blockPosX, 0, blockPosZ);
                    LinkedHashMultiset multiset = LinkedHashMultiset.create();
                    LevelChunk levelchunk = level.m_46745_(currentPos);
                    if (levelchunk.m_6430_()) continue;
                    ChunkPos chunkpos = levelchunk.m_7697_();
                    int k3 = 0;
                    double d1 = 0.0;
                    if (ceilingDim && !bumblezoneDim) {
                        int l3 = blockPosX + blockPosZ * 231871;
                        if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)Blocks.f_50493_.m_49966_().m_60780_((BlockGetter)level, BlockPos.f_121853_), 10);
                        } else {
                            multiset.add((Object)Blocks.f_50069_.m_49966_().m_60780_((BlockGetter)level, BlockPos.f_121853_), 100);
                        }
                        d1 = 100.0;
                    } else {
                        BlockState blockstate;
                        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                        BlockPos.MutableBlockPos mutableBlockPos1 = new BlockPos.MutableBlockPos();
                        int scanY = levelchunk.m_5885_(Heightmap.Types.WORLD_SURFACE, blockPosX, blockPosZ) + 1;
                        if (scanY >= 255 && bumblezoneDim) {
                            scanY = 110;
                        }
                        if (scanY <= level.m_141937_() + 1) {
                            blockstate = Blocks.f_50752_.m_49966_();
                        } else {
                            do {
                                mutableBlockPos.m_122178_(chunkpos.m_45604_() + blockPosX, --scanY, chunkpos.m_45605_() + blockPosZ);
                            } while ((blockstate = levelchunk.m_8055_((BlockPos)mutableBlockPos)).m_60780_((BlockGetter)level, (BlockPos)mutableBlockPos) == MaterialColor.f_76398_ && scanY > level.m_141937_());
                            if (scanY > level.m_141937_() && !blockstate.m_60819_().m_76178_()) {
                                BlockState blockstate1;
                                int secondScanY = scanY - 1;
                                mutableBlockPos1.m_122190_((Vec3i)mutableBlockPos);
                                do {
                                    mutableBlockPos1.m_142448_(secondScanY--);
                                    blockstate1 = levelchunk.m_8055_((BlockPos)mutableBlockPos1);
                                    ++k3;
                                } while (secondScanY > level.m_141937_() && !blockstate1.m_60819_().m_76178_());
                                blockstate = PrefillMap.getCorrectStateForFluidBlock(level, blockstate, (BlockPos)mutableBlockPos);
                            }
                        }
                        d1 += (double)scanY / (double)(scale * scale);
                        multiset.add((Object)blockstate.m_60780_((BlockGetter)level, (BlockPos)mutableBlockPos));
                    }
                    MaterialColor materialcolor = (MaterialColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MaterialColor.f_76398_);
                    MaterialColor.Brightness materialcolor$brightness = materialcolor == MaterialColor.f_76410_ ? ((d2 = (double)(k3 /= scale * scale) * 0.1) < 0.5 ? MaterialColor.Brightness.HIGH : (d2 > 0.9 ? MaterialColor.Brightness.LOW : MaterialColor.Brightness.NORMAL)) : ((slopeState = (d1 - d0) * 4.0 / (double)(scale + 4) - 0.2) > 0.6 ? MaterialColor.Brightness.HIGH : (slopeState < -0.6 ? MaterialColor.Brightness.LOW : MaterialColor.Brightness.NORMAL));
                    d0 = d1;
                    data.m_164792_(scanX, scanZ, materialcolor.m_192925_(materialcolor$brightness));
                }
            }
        }
    }

    private static BlockState getCorrectStateForFluidBlock(Level level, BlockState state, BlockPos pos) {
        FluidState fluidstate = state.m_60819_();
        return !fluidstate.m_76178_() && !state.m_60783_((BlockGetter)level, pos, Direction.UP) ? fluidstate.m_76188_() : state;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<PrefillMap> {
        public void serialize(JsonObject jsonObject, PrefillMap prefillMap, JsonSerializationContext context) {
            super.m_6170_(jsonObject, (LootItemConditionalFunction)prefillMap, context);
            if (prefillMap.scaleLevel != 0) {
                jsonObject.addProperty("scale", (Number)prefillMap.scaleLevel);
            }
        }

        public PrefillMap deserialize(JsonObject jsonObject, JsonDeserializationContext context, LootItemCondition[] lootItemConditions) {
            return new PrefillMap(lootItemConditions, GsonHelper.m_13824_((JsonObject)jsonObject, (String)"scale", (int)0));
        }
    }
}

