/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.telepathicgrunt.the_bumblezone.modinit.BzRecipes;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class ContainerCraftingRecipe
extends ShapelessRecipe {
    private final String group;
    private final ItemStack recipeOutput;
    private final NonNullList<Ingredient> recipeItems;
    public static final Map<Item, Item> HARDCODED_EDGECASES_WITHOUT_CONTAINERS_SET = Map.ofEntries(Map.entry(Items.f_151055_, Items.f_42446_), Map.entry(Items.f_151057_, Items.f_42446_), Map.entry(Items.f_42458_, Items.f_42446_), Map.entry(Items.f_42456_, Items.f_42446_), Map.entry(Items.f_42457_, Items.f_42446_), Map.entry(Items.f_42459_, Items.f_42446_), Map.entry(Items.f_42718_, Items.f_42399_), Map.entry(Items.f_42400_, Items.f_42399_), Map.entry(Items.f_42699_, Items.f_42399_), Map.entry(Items.f_42734_, Items.f_42399_), Map.entry(Items.f_42589_, Items.f_42590_), Map.entry(Items.f_42736_, Items.f_42590_), Map.entry(Items.f_42739_, Items.f_42590_), Map.entry(Items.f_42612_, Items.f_42590_));

    public ContainerCraftingRecipe(ResourceLocation idIn, String groupIn, CraftingBookCategory craftingBookCategory, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn) {
        super(idIn, groupIn, craftingBookCategory, recipeOutputIn, recipeItemsIn);
        this.group = groupIn;
        this.recipeOutput = recipeOutputIn;
        this.recipeItems = recipeItemsIn;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)BzRecipes.CONTAINER_CRAFTING_RECIPE.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remainingInv = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        int containerOutput = this.recipeOutput.hasCraftingRemainingItem() ? this.recipeOutput.m_41613_() : 0;
        for (int i = 0; i < remainingInv.size(); ++i) {
            ItemStack craftingInput = inv.m_8020_(i);
            ItemStack craftingContainer = craftingInput.getCraftingRemainingItem();
            ItemStack recipeContainer = this.recipeOutput.getCraftingRemainingItem();
            if (craftingContainer.m_41619_() && HARDCODED_EDGECASES_WITHOUT_CONTAINERS_SET.containsKey(craftingInput.m_41720_())) {
                craftingContainer = HARDCODED_EDGECASES_WITHOUT_CONTAINERS_SET.get(craftingInput.m_41720_()).m_7968_();
            }
            if (recipeContainer.m_41619_() && HARDCODED_EDGECASES_WITHOUT_CONTAINERS_SET.containsKey(this.recipeOutput.m_41720_())) {
                recipeContainer = HARDCODED_EDGECASES_WITHOUT_CONTAINERS_SET.get(this.recipeOutput.m_41720_()).m_7968_();
            }
            if (craftingContainer.m_41619_()) continue;
            if (containerOutput > 0 && (this.recipeOutput.m_41720_() == craftingContainer.m_41720_() || recipeContainer.m_41720_() == craftingInput.m_41720_() || recipeContainer.m_41720_() == craftingContainer.m_41720_())) {
                --containerOutput;
                continue;
            }
            remainingInv.set(i, (Object)craftingContainer);
        }
        return remainingInv;
    }

    public static class Serializer
    implements RecipeSerializer<ContainerCraftingRecipe> {
        public ContainerCraftingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String s = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory craftingBookCategory = Objects.requireNonNullElse((CraftingBookCategory)CraftingBookCategory.f_244644_.m_216455_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null)), CraftingBookCategory.MISC);
            NonNullList<Ingredient> DefaultedList = Serializer.getIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (DefaultedList.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new ContainerCraftingRecipe(recipeId, s, craftingBookCategory, itemstack, DefaultedList);
        }

        private static NonNullList<Ingredient> getIngredients(JsonArray jsonElements) {
            NonNullList defaultedList = NonNullList.m_122779_();
            for (int i = 0; i < jsonElements.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonElements.get(i));
                if (ingredient.m_43947_()) continue;
                defaultedList.add((Object)ingredient);
            }
            return defaultedList;
        }

        public ContainerCraftingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String s = buffer.m_130136_(Short.MAX_VALUE);
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            int i = buffer.m_130242_();
            NonNullList defaultedList = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < defaultedList.size(); ++j) {
                defaultedList.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack itemstack = buffer.m_130267_();
            return new ContainerCraftingRecipe(recipeId, s, craftingBookCategory, itemstack, (NonNullList<Ingredient>)defaultedList);
        }

        public void toNetwork(FriendlyByteBuf buffer, ContainerCraftingRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130068_((Enum)recipe.m_245232_());
            buffer.m_130130_(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.recipeOutput);
        }
    }
}

