/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.entities.EntityTeleportationHookup;
import com.telepathicgrunt.the_bumblezone.items.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzEnchantments;
import com.telepathicgrunt.the_bumblezone.world.dimension.BzWorldSavedData;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BumblezoneAPI {
    public static final ResourceLocation MOD_DIMENSION_ID = new ResourceLocation("the_bumblezone", "the_bumblezone");

    public static void teleportOutOfBz(LivingEntity livingEntity) {
        EntityTeleportationHookup.teleportOutOfBz(livingEntity);
    }

    public static boolean runEnderpearlImpact(Vec3 hitResult, Entity thrower, Projectile pearlEntity) {
        return EntityTeleportationHookup.runEnderpearlImpact(hitResult, thrower, (Entity)pearlEntity);
    }

    public static void runPistonPushed(Direction direction, LivingEntity livingEntity) {
        EntityTeleportationHookup.runPistonPushed(direction, livingEntity);
    }

    public static void triggerEnderPearlAdvancement(ServerPlayer serverPlayer) {
        BzCriterias.TELEPORT_TO_BUMBLEZONE_PEARL_TRIGGER.trigger(serverPlayer);
    }

    public static void triggerPistonAdvancement(ServerPlayer serverPlayer) {
        BzCriterias.TELEPORT_TO_BUMBLEZONE_PISTON_TRIGGER.trigger(serverPlayer);
    }

    public static void triggerExitingBumblezoneAdvancement(ServerPlayer serverPlayer) {
        BzCriterias.TELEPORT_OUT_OF_BUMBLEZONE_TRIGGER.trigger(serverPlayer);
    }

    public static void queueEntityForTeleportingToBumblezone(Entity entity) {
        BzWorldSavedData.queueEntityToTeleport(entity, BzDimension.BZ_WORLD_KEY);
    }

    public static void queueEntityForTeleportingOutOfBumblezone(Entity entity, ResourceKey<Level> worldToTeleportTo) {
        BzWorldSavedData.queueEntityToTeleport(entity, worldToTeleportTo);
    }

    public static boolean playerHasBeeEssence(ServerPlayer serverPlayer) {
        return EssenceOfTheBees.hasEssence(serverPlayer);
    }

    public static void triggerCombCutterExtraDropAdvancement(ServerPlayer serverPlayer) {
        BzCriterias.COMB_CUTTER_EXTRA_DROPS_TRIGGER.trigger(serverPlayer);
    }

    public static int getCombCutterLevelForItem(ItemStack toolUsed) {
        return EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)BzEnchantments.COMB_CUTTER.get()), (ItemStack)toolUsed);
    }

    public static int getCombCutterLevelForItem(ServerPlayer serverPlayer) {
        return EnchantmentHelper.m_44836_((Enchantment)((Enchantment)BzEnchantments.COMB_CUTTER.get()), (LivingEntity)serverPlayer);
    }
}

