/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;

public class ResourcefulBeesCompat {
    public static final TagKey<Block> SPAWNS_IN_BEE_DUNGEONS_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("the_bumblezone", "resourcefulbees/spawns_in_bee_dungeons"));
    public static final TagKey<Block> SPAWNS_IN_SPIDER_INFESTED_BEE_DUNGEONS_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("the_bumblezone", "resourcefulbees/spawns_in_spider_infested_bee_dungeons"));
    public static final TagKey<EntityType<?>> SPAWNABLE_FROM_BROOD_BLOCK_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("the_bumblezone", "resourcefulbees/spawnable_from_brood_block"));
    public static final TagKey<EntityType<?>> SPAWNABLE_FROM_CHUNK_CREATION_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("the_bumblezone", "resourcefulbees/spawnable_from_chunk_creation"));

    public static void setupCompat() {
        ModChecker.resourcefulBeesPresent = true;
    }

    public static boolean RBMobSpawnEvent(LivingSpawnEvent.CheckSpawn event, boolean isChild, MobSpawnType spawnReason) {
        Mob entity = event.getEntity();
        LevelAccessor world = event.getLevel();
        Registry entityTypes = world.m_8891_().m_175515_(Registries.f_256939_);
        Optional optionalNamed = entityTypes.m_203431_(spawnReason == MobSpawnType.CHUNK_GENERATION ? SPAWNABLE_FROM_CHUNK_CREATION_TAG : SPAWNABLE_FROM_BROOD_BLOCK_TAG);
        if (optionalNamed.isEmpty()) {
            return false;
        }
        HolderSet.Named holders = (HolderSet.Named)optionalNamed.get();
        if (holders.m_203632_() == 0) {
            return false;
        }
        EntityType rbBeeType = (EntityType)holders.m_203662_(entity.m_217043_().m_188503_(holders.m_203632_())).get();
        Entity rbBeeUnchecked = rbBeeType.m_20615_(entity.m_9236_());
        if (rbBeeUnchecked instanceof Bee) {
            Bee rbBee = (Bee)rbBeeUnchecked;
            BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)entity.m_20183_());
            rbBee.m_7678_((double)((float)blockpos.m_123341_() + 0.5f), (double)((float)blockpos.m_123342_() + 0.5f), (double)((float)blockpos.m_123343_() + 0.5f), rbBee.m_217043_().m_188501_() * 360.0f, 0.0f);
            rbBee.m_6863_(isChild);
            rbBee.m_6518_((ServerLevelAccessor)world, world.m_6436_(rbBee.m_20183_()), event.getSpawnReason(), null, null);
            world.m_7967_((Entity)rbBee);
            return true;
        }
        return false;
    }

    public static StructureTemplate.StructureBlockInfo RBGetSpiderHoneycomb(BlockPos worldPos, RandomSource random, LevelReader worldView) {
        return ResourcefulBeesCompat.getRandomCombFromTag(worldPos, random, worldView, SPAWNS_IN_SPIDER_INFESTED_BEE_DUNGEONS_TAG);
    }

    public static StructureTemplate.StructureBlockInfo RBGetRandomBeeHoneycomb(BlockPos worldPos, RandomSource random, LevelReader worldView) {
        return ResourcefulBeesCompat.getRandomCombFromTag(worldPos, random, worldView, SPAWNS_IN_BEE_DUNGEONS_TAG);
    }

    private static StructureTemplate.StructureBlockInfo getRandomCombFromTag(BlockPos worldPos, RandomSource random, LevelReader worldView, TagKey<Block> spawnsInBeeDungeonsTag) {
        if (worldView instanceof CommonLevelAccessor) {
            CommonLevelAccessor world = (CommonLevelAccessor)worldView;
            Registry blockRegistry = world.m_8891_().m_175515_(Registries.f_256747_);
            Optional optionalNamed = blockRegistry.m_203431_(spawnsInBeeDungeonsTag);
            if (optionalNamed.isEmpty()) {
                return null;
            }
            List<Block> holders = GeneralUtils.getListOfNonDummyBlocks(optionalNamed);
            if (holders.size() == 0) {
                return null;
            }
            Block rbComb = holders.get(random.m_188503_(random.m_188503_(holders.size()) + 1));
            return new StructureTemplate.StructureBlockInfo(worldPos, rbComb.m_49966_(), null);
        }
        return null;
    }
}

