/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.telepathicgrunt.the_bumblezone.packets.MessageHandler;
import com.telepathicgrunt.the_bumblezone.screens.CrystallineFlowerScreen;
import com.telepathicgrunt.the_bumblezone.screens.EnchantmentSkeleton;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record CrystallineFlowerEnchantmentPacket(List<EnchantmentSkeleton> enchantmentSkeletons) {
    public static Gson gson = new GsonBuilder().create();

    public static void sendToClient(ServerPlayer entity, List<EnchantmentSkeleton> enchantmentSkeletons) {
        MessageHandler.DEFAULT_CHANNEL.send(PacketDistributor.PLAYER.with(() -> entity), (Object)new CrystallineFlowerEnchantmentPacket(enchantmentSkeletons));
    }

    public static CrystallineFlowerEnchantmentPacket parse(FriendlyByteBuf buf) {
        ArrayList<EnchantmentSkeleton> enchantmentSkeletons = new ArrayList<EnchantmentSkeleton>();
        int elements = buf.readInt();
        for (int i = 0; i < elements; ++i) {
            String jsonData = buf.m_130277_();
            enchantmentSkeletons.add((EnchantmentSkeleton)gson.fromJson(jsonData, EnchantmentSkeleton.class));
        }
        return new CrystallineFlowerEnchantmentPacket(enchantmentSkeletons);
    }

    public static void compose(CrystallineFlowerEnchantmentPacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.enchantmentSkeletons().size());
        for (EnchantmentSkeleton enchantmentSkeleton : pkt.enchantmentSkeletons()) {
            buf.m_130070_(gson.toJson((Object)enchantmentSkeleton));
        }
    }

    public static class Handler {
        public static void handle(CrystallineFlowerEnchantmentPacket pkt, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                CrystallineFlowerScreen.enchantmentsAvailable = pkt.enchantmentSkeletons;
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

