/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.screens;

import com.telepathicgrunt.the_bumblezone.blocks.CrystallineFlower;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.CrystallineFlowerBlockEntity;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzMenuTypes;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.packets.CrystallineFlowerEnchantmentPacket;
import com.telepathicgrunt.the_bumblezone.screens.EnchantmentSkeleton;
import com.telepathicgrunt.the_bumblezone.utils.EnchantmentUtils;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;

public class CrystallineFlowerMenu
extends AbstractContainerMenu {
    public static final int CONSUME_SLOT = 0;
    private static final int BOOK_SLOT = 1;
    private static final int ENCHANTED_SLOT = 2;
    public static final int CONSUME_SLOT_X = 47;
    public static final int CONSUME_SLOT_Y = 80;
    private static final int BOOK_SLOT_X = 92;
    private static final int BOOK_SLOT_Y = 28;
    private static final int ENCHANTED_SLOT_X = 136;
    private static final int ENCHANTED_SLOT_Y = 28;
    private final ContainerLevelAccess access;
    private final Player player;
    public final CrystallineFlowerBlockEntity crystallineFlowerBlockEntity;
    final Slot consumeSlot;
    final Slot bookSlot;
    private final Slot enchantedSlot;
    final DataSlot selectedEnchantmentIndex = DataSlot.m_39401_();
    final DataSlot xpBarPercent = DataSlot.m_39401_();
    final DataSlot xpTier = DataSlot.m_39401_();
    final DataSlot tierCost = DataSlot.m_39401_();
    final DataSlot bottomBlockPosX = DataSlot.m_39401_();
    final DataSlot bottomBlockPosY = DataSlot.m_39401_();
    final DataSlot bottomBlockPosZ = DataSlot.m_39401_();
    final DataSlot playerHasXPForTier = DataSlot.m_39401_();
    final DataSlot consumeSlotFullyObstructed = DataSlot.m_39401_();
    final DataSlot tooManyEnchantmentsOnInput = DataSlot.m_39401_();
    private final Container inputContainer = new SimpleContainer(3){

        public void m_6596_() {
            super.m_6596_();
            CrystallineFlowerMenu.this.m_6199_((Container)this);
        }
    };
    long lastSoundTime;

    public CrystallineFlowerMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, ContainerLevelAccess.f_39287_, 0, 0, null);
    }

    public CrystallineFlowerMenu(int containerId, Inventory playerInventory, final ContainerLevelAccess access, int searchLevel, int searchTreasure, CrystallineFlowerBlockEntity crystallineFlowerBlockEntity) {
        super((MenuType)BzMenuTypes.CRYSTALLINE_FLOWER.get(), containerId);
        int i;
        this.access = access;
        this.player = playerInventory.f_35978_;
        this.crystallineFlowerBlockEntity = crystallineFlowerBlockEntity;
        this.consumeSlot = this.m_38897_(new Slot(this.inputContainer, 0, 47, 80){

            public boolean m_5857_(ItemStack itemStack) {
                EntityBlock entityBlock;
                BlockItem blockItem;
                if (!((Boolean)BzGeneralConfigs.crystallineFlowerConsumeItemUI.get()).booleanValue()) {
                    return false;
                }
                if (itemStack.m_204117_(BzTags.CANNOT_CONSUMED_ITEMS)) {
                    return false;
                }
                if (!itemStack.m_41720_().m_142095_()) {
                    return false;
                }
                Item item = itemStack.m_41720_();
                return !(item instanceof BlockItem) || !((item = (blockItem = (BlockItem)item).m_40614_()) instanceof EntityBlock) || !((entityBlock = (EntityBlock)item).m_142194_(BlockPos.f_121853_, blockItem.m_40614_().m_49966_()) instanceof Container);
            }

            public void m_6654_() {
                this.f_40218_.m_6596_();
                CrystallineFlowerMenu.this.consumeSlotFullyObstructed();
            }
        });
        this.bookSlot = this.m_38897_(new Slot(this.inputContainer, 1, 92, 28){

            public boolean m_5857_(ItemStack itemStack) {
                return itemStack.m_204117_(BzTags.CAN_BE_ENCHANTED_ITEMS);
            }

            public void m_6654_() {
                this.f_40218_.m_6596_();
                if (!CrystallineFlowerMenu.this.player.f_19853_.m_5776_()) {
                    CrystallineFlowerMenu.this.setupResultSlot();
                    CrystallineFlowerMenu.this.m_38946_();
                }
            }
        });
        this.enchantedSlot = this.m_38897_(new Slot(this.inputContainer, 2, 136, 28){

            public boolean m_5857_(ItemStack itemStack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack itemStack) {
                CrystallineFlowerMenu.this.selectedEnchantmentIndex.m_6422_(-1);
                CrystallineFlowerMenu.this.bookSlot.m_6201_(1);
                access.m_39292_((soundLevel, pos) -> {
                    long gameTime = soundLevel.m_46467_();
                    if (CrystallineFlowerMenu.this.lastSoundTime != gameTime) {
                        soundLevel.m_5594_(null, pos, (SoundEvent)BzSounds.CRYSTALLINE_FLOWER_USE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        CrystallineFlowerMenu.this.lastSoundTime = gameTime;
                    }
                });
                CrystallineFlowerMenu.this.drainFlowerXPLevel(CrystallineFlowerMenu.this.tierCost.m_6501_());
                ItemStack bookSlotItem = CrystallineFlowerMenu.this.bookSlot.m_7993_();
                if (bookSlotItem.m_41619_()) {
                    CrystallineFlowerMenu.this.selectedEnchantmentIndex.m_6422_(-1);
                }
                if (!player.f_19853_.m_5776_()) {
                    CrystallineFlowerMenu.this.setupResultSlot();
                    CrystallineFlowerMenu.this.m_38946_();
                }
                super.m_142406_(player, itemStack);
            }
        });
        int playerInvYOffset = 115;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, playerInvYOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, playerInvYOffset + 58));
        }
        this.selectedEnchantmentIndex.m_6422_(-1);
        this.xpBarPercent.m_6422_(0);
        this.xpTier.m_6422_(0);
        this.tierCost.m_6422_(0);
        this.playerHasXPForTier.m_6422_(0);
        this.consumeSlotFullyObstructed.m_6422_(0);
        this.tooManyEnchantmentsOnInput.m_6422_(0);
        this.bottomBlockPosX.m_6422_(0);
        this.bottomBlockPosY.m_6422_(0);
        this.bottomBlockPosZ.m_6422_(0);
        if (this.crystallineFlowerBlockEntity != null) {
            this.bottomBlockPosX.m_6422_(this.crystallineFlowerBlockEntity.m_58899_().m_123341_());
            this.bottomBlockPosY.m_6422_(this.crystallineFlowerBlockEntity.m_58899_().m_123342_());
            this.bottomBlockPosZ.m_6422_(this.crystallineFlowerBlockEntity.m_58899_().m_123343_());
        }
        this.syncXpTier();
        this.m_38895_(this.selectedEnchantmentIndex);
        this.m_38895_(this.xpBarPercent);
        this.m_38895_(this.xpTier);
        this.m_38895_(this.tierCost);
        this.m_38895_(this.playerHasXPForTier);
        this.m_38895_(this.consumeSlotFullyObstructed);
        this.m_38895_(this.tooManyEnchantmentsOnInput);
        this.m_38895_(this.bottomBlockPosX);
        this.m_38895_(this.bottomBlockPosY);
        this.m_38895_(this.bottomBlockPosZ);
    }

    private void syncXpTier() {
        if (this.crystallineFlowerBlockEntity != null) {
            int currentXP = this.crystallineFlowerBlockEntity.getCurrentXp();
            int maxXPForCurrentTier = this.crystallineFlowerBlockEntity.getMaxXpForTier(this.crystallineFlowerBlockEntity.getXpTier());
            this.xpBarPercent.m_6422_((int)((float)currentXP / (float)maxXPForCurrentTier * 100.0f));
            this.xpTier.m_6422_(this.crystallineFlowerBlockEntity.getXpTier());
            if (this.player.m_150110_().f_35937_) {
                this.playerHasXPForTier.m_6422_(Math.min(7 - this.crystallineFlowerBlockEntity.getXpTier(), 3));
            } else {
                int tierAbleToBeBought = 0;
                int totalXPRequires = 0;
                int playerXP = EnchantmentUtils.getPlayerXP(this.player);
                for (int i = 0; i < 3; ++i) {
                    if (this.crystallineFlowerBlockEntity.getXpTier() + i >= 7) continue;
                    totalXPRequires += this.crystallineFlowerBlockEntity.getMaxXpForTier(this.crystallineFlowerBlockEntity.getXpTier() + i);
                    if (i == 0) {
                        totalXPRequires -= currentXP;
                    }
                    if (totalXPRequires > playerXP) continue;
                    ++tierAbleToBeBought;
                }
                this.playerHasXPForTier.m_6422_(tierAbleToBeBought);
            }
            this.m_38946_();
        }
    }

    public void m_6199_(Container inventory) {
    }

    public boolean m_6366_(Player player, int id) {
        if (id >= 0) {
            this.selectedEnchantmentIndex.m_6422_(id);
            if (!player.f_19853_.m_5776_()) {
                this.setupResultSlot();
                this.m_38946_();
            }
            return true;
        }
        if (id == -2) {
            this.drainPlayerXPLevel(1);
            if (!player.f_19853_.m_5776_()) {
                this.setupResultSlot();
                this.m_38946_();
            }
            return true;
        }
        if (id == -3) {
            this.drainPlayerXPLevel(2);
            if (!player.f_19853_.m_5776_()) {
                this.setupResultSlot();
                this.m_38946_();
            }
            return true;
        }
        if (id == -4) {
            this.drainPlayerXPLevel(3);
            if (!player.f_19853_.m_5776_()) {
                this.setupResultSlot();
                this.m_38946_();
            }
            return true;
        }
        if (id == -5) {
            this.consumeItem();
            if (!player.f_19853_.m_5776_()) {
                this.setupResultSlot();
                this.m_38946_();
            }
            return true;
        }
        return false;
    }

    private void consumeItem() {
        if (this.consumeSlot.m_6657_() && this.crystallineFlowerBlockEntity != null && !this.crystallineFlowerBlockEntity.isMaxTier()) {
            Player player;
            int tiersToMax = 7 - this.crystallineFlowerBlockEntity.getXpTier();
            int topBlock = CrystallineFlower.flowerHeightAbove((LevelReader)this.player.f_19853_, this.crystallineFlowerBlockEntity.m_58899_());
            List<Boolean> obstructedAbove = CrystallineFlower.getObstructions(tiersToMax, this.player.f_19853_, this.crystallineFlowerBlockEntity.m_58899_().m_6630_(topBlock + 1));
            int xpPerCount = CrystallineFlower.getXPPerItem(this.consumeSlot.m_7993_());
            int itemCount = this.consumeSlot.m_7993_().m_41613_();
            int xpForStack = itemCount * xpPerCount;
            int xpToHighestAvailableTier = CrystallineFlower.getXpToHighestAvailableTier(this.crystallineFlowerBlockEntity, tiersToMax, obstructedAbove);
            int xpGranted = Math.min(xpToHighestAvailableTier, xpForStack);
            int consumedItemCount = (int)Math.ceil((float)xpGranted / (float)xpPerCount);
            if (consumedItemCount == 0) {
                return;
            }
            this.crystallineFlowerBlockEntity.addXpAndTier(xpGranted);
            this.consumeSlot.m_6201_(consumedItemCount);
            this.consumeSlotFullyObstructed();
            if (tiersToMax > 0 && this.crystallineFlowerBlockEntity.isMaxTier() && (player = this.player) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BzCriterias.GROW_CRYSTALLINE_FLOWER_TRIGGER.trigger(serverPlayer);
            }
            this.syncXpTier();
        }
    }

    public void consumeSlotFullyObstructed() {
        boolean fullyObstructed = false;
        if (this.consumeSlot.m_6657_() && this.crystallineFlowerBlockEntity != null) {
            if (!this.crystallineFlowerBlockEntity.isMaxTier()) {
                int topBlock = CrystallineFlower.flowerHeightAbove((LevelReader)this.player.f_19853_, this.crystallineFlowerBlockEntity.m_58899_());
                List<Boolean> obstructedAbove = CrystallineFlower.getObstructions(1, this.player.f_19853_, this.crystallineFlowerBlockEntity.m_58899_().m_6630_(topBlock + 1));
                if (!obstructedAbove.isEmpty() && obstructedAbove.get(0).booleanValue()) {
                    int xpPerCount = CrystallineFlower.getXPPerItem(this.consumeSlot.m_7993_());
                    int xpToMaxTier = this.crystallineFlowerBlockEntity.getXpForNextTiers(1) - 1;
                    int itemsConsumable = xpToMaxTier / xpPerCount;
                    fullyObstructed = itemsConsumable == 0;
                }
            } else {
                fullyObstructed = true;
            }
            if (fullyObstructed) {
                this.consumeSlotFullyObstructed.m_6422_(1);
            } else {
                this.consumeSlotFullyObstructed.m_6422_(0);
            }
            this.m_38946_();
        }
    }

    private void drainPlayerXPLevel(int desiredTierUpgrade) {
        if (this.crystallineFlowerBlockEntity != null && !this.crystallineFlowerBlockEntity.isMaxTier()) {
            Player player;
            int xpObtained;
            boolean isSpotObstructed;
            List<Boolean> obstructions = CrystallineFlower.getObstructions(desiredTierUpgrade, this.crystallineFlowerBlockEntity.m_58904_(), this.crystallineFlowerBlockEntity.m_58899_().m_6630_(this.crystallineFlowerBlockEntity.getXpTier()));
            int freeTierSpot = 0;
            Iterator<Boolean> iterator = obstructions.iterator();
            while (iterator.hasNext() && !(isSpotObstructed = iterator.next().booleanValue())) {
                ++freeTierSpot;
            }
            int xpRequested = this.crystallineFlowerBlockEntity.getXpForNextTiers(freeTierSpot);
            if (!this.player.m_150110_().f_35937_) {
                xpObtained = Math.min(EnchantmentUtils.getPlayerXP(this.player), xpRequested);
                this.player.m_6756_(-xpRequested);
            } else {
                xpObtained = xpRequested;
            }
            this.crystallineFlowerBlockEntity.addXpAndTier(xpObtained);
            this.consumeSlotFullyObstructed();
            this.syncXpTier();
            if (desiredTierUpgrade > 0 && this.crystallineFlowerBlockEntity.isMaxTier() && (player = this.player) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BzCriterias.GROW_CRYSTALLINE_FLOWER_TRIGGER.trigger(serverPlayer);
            }
        }
    }

    private void drainFlowerXPLevel(int levelToConsume) {
        if (this.crystallineFlowerBlockEntity != null && !this.crystallineFlowerBlockEntity.isMinTier()) {
            Player player;
            this.crystallineFlowerBlockEntity.decreaseTier(levelToConsume);
            this.consumeSlotFullyObstructed();
            this.syncXpTier();
            if (levelToConsume >= 5 && (player = this.player) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BzCriterias.ENCHANT_CRYSTALLINE_FLOWER_TRIGGER.trigger(serverPlayer);
            }
        } else if (this.xpTier.m_6501_() > 1) {
            this.xpTier.m_6422_(Math.max(1, this.xpTier.m_6501_() - levelToConsume));
        }
    }

    protected void m_150411_(Player player, Container container) {
        this.enchantedSlot.f_40218_.m_8016_(this.enchantedSlot.f_40219_);
        super.m_150411_(player, container);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.access.m_39292_((level, blockPos) -> this.m_150411_(player, this.inputContainer));
    }

    public boolean m_6875_(Player player) {
        return CrystallineFlowerMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BzBlocks.CRYSTALLINE_FLOWER.get()));
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemStack = itemstack1.m_41777_();
            if (index == this.enchantedSlot.f_40219_) {
                if (!this.m_38903_(itemstack1, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemStack);
            } else if (index != this.consumeSlot.f_40219_ && index != this.bookSlot.f_40219_) {
                if (!itemStack.m_204117_(BzTags.CAN_BE_ENCHANTED_ITEMS) && !this.m_38903_(itemstack1, this.consumeSlot.f_40219_, this.consumeSlot.f_40219_ + 1, false)) {
                    return ItemStack.f_41583_;
                }
                if (itemStack.m_204117_(BzTags.CAN_BE_ENCHANTED_ITEMS) && !this.m_38903_(itemstack1, this.bookSlot.f_40219_, this.bookSlot.f_40219_ + 1, false)) {
                    return ItemStack.f_41583_;
                }
                if (index >= 3 && index < 30 && !this.m_38903_(itemstack1, 30, 39, false)) {
                    return ItemStack.f_41583_;
                }
                if (index >= 30 && index < 39 && !this.m_38903_(itemstack1, 3, 30, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.m_38903_(itemstack1, 3, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemStack;
    }

    private void setupResultSlot() {
        ItemStack bookSlotItem = this.bookSlot.m_7993_();
        if (bookSlotItem.m_41619_() || this.xpTier.m_6501_() <= 1) {
            this.tooManyEnchantmentsOnInput.m_6422_(0);
            this.selectedEnchantmentIndex.m_6422_(-1);
            if (this.enchantedSlot.m_6657_()) {
                this.enchantedSlot.m_5852_(ItemStack.f_41583_);
            }
            return;
        }
        int existingEnchantments = EnchantmentHelper.m_44831_((ItemStack)bookSlotItem).size();
        if (existingEnchantments >= 3) {
            this.tooManyEnchantmentsOnInput.m_6422_(1);
            this.selectedEnchantmentIndex.m_6422_(-1);
            if (this.enchantedSlot.m_6657_()) {
                this.enchantedSlot.m_5852_(ItemStack.f_41583_);
            }
            return;
        }
        this.tooManyEnchantmentsOnInput.m_6422_(0);
        ItemStack toEnchant = this.bookSlot.m_7993_();
        if (!toEnchant.m_41619_()) {
            ItemStack tempCopy = toEnchant.m_41777_();
            tempCopy.m_41764_(1);
            int level = this.xpTier.m_6501_() * (Integer)BzGeneralConfigs.crystallineFlowerEnchantingPowerAllowedPerTier.get();
            List<EnchantmentInstance> availableEnchantments = EnchantmentUtils.allAllowedEnchantsWithoutMaxLimit(level, tempCopy, this.xpTier.m_6501_());
            if (availableEnchantments.size() == 0) {
                if (this.enchantedSlot.m_6657_()) {
                    this.enchantedSlot.m_5852_(ItemStack.f_41583_);
                }
                this.selectedEnchantmentIndex.m_6422_(-1);
            }
            if (this.selectedEnchantmentIndex.m_6501_() != -1) {
                if (this.selectedEnchantmentIndex.m_6501_() != -1 && availableEnchantments.size() > this.selectedEnchantmentIndex.m_6501_()) {
                    EnchantmentInstance enchantmentForItem = availableEnchantments.get(this.selectedEnchantmentIndex.m_6501_());
                    if (tempCopy.m_150930_(Items.f_42517_)) {
                        ItemStack enchantedBook = Items.f_42690_.m_7968_();
                        enchantedBook.m_41764_(1);
                        CompoundTag compoundtag = tempCopy.m_41783_();
                        if (compoundtag != null) {
                            enchantedBook.m_41751_(compoundtag.m_6426_());
                        }
                        tempCopy = enchantedBook;
                    }
                    if (tempCopy.m_150930_(Items.f_42517_) || tempCopy.m_150930_(Items.f_42690_)) {
                        EnchantedBookItem.m_41153_((ItemStack)tempCopy, (EnchantmentInstance)enchantmentForItem);
                    } else {
                        tempCopy.m_41663_(enchantmentForItem.f_44947_, enchantmentForItem.f_44948_);
                    }
                    if (!ItemStack.m_41728_((ItemStack)tempCopy, (ItemStack)this.enchantedSlot.m_7993_())) {
                        this.enchantedSlot.m_5852_(tempCopy);
                        this.tierCost.m_6422_(EnchantmentUtils.getEnchantmentTierCost(enchantmentForItem));
                    }
                }
                return;
            }
            Player enchantedBook = this.player;
            if (enchantedBook instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)enchantedBook;
                List<EnchantmentSkeleton> availableEnchantmentsSkeletons = availableEnchantments.stream().map(e -> {
                    ResourceLocation resourceLocation = BuiltInRegistries.f_256876_.m_7981_((Object)e.f_44947_);
                    return new EnchantmentSkeleton(resourceLocation.m_135815_(), resourceLocation.m_135827_(), e.f_44948_, e.f_44947_.m_6183_(2), e.f_44948_ == e.f_44947_.m_6586_(), e.f_44947_.m_6589_(), e.f_44947_.m_6591_());
                }).toList();
                CrystallineFlowerEnchantmentPacket.sendToClient(serverPlayer, availableEnchantmentsSkeletons);
            }
        }
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return super.m_5882_(stack, slot);
    }
}

