/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.features.decorators;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.mixin.world.WorldGenRegionAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzPlacements;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class HoneycombHolePlacer
extends PlacementModifier {
    private static final HoneycombHolePlacer INSTANCE = new HoneycombHolePlacer();
    public static final Codec<HoneycombHolePlacer> CODEC = Codec.unit(() -> INSTANCE);

    public static HoneycombHolePlacer honeycombHolePlacer() {
        return INSTANCE;
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)BzPlacements.HONEYCOMB_HOLE_PLACER.get();
    }

    public Stream<BlockPos> m_213676_(PlacementContext placementContext, RandomSource random, BlockPos blockPos) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(blockPos.m_123341_() - 4, 236, blockPos.m_123343_() + 4);
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        boolean alternate = false;
        List structureStarts = new ArrayList();
        List structureStartsPiecewiseCheck = new ArrayList();
        WorldGenLevel worldGenLevel = placementContext.m_191831_();
        if (worldGenLevel instanceof WorldGenRegion) {
            WorldGenRegion worldGenRegion = (WorldGenRegion)worldGenLevel;
            Registry structureRegistry = worldGenRegion.m_8891_().m_175515_(Registries.f_256944_);
            StructureManager structureManager = ((WorldGenRegionAccessor)worldGenRegion).getStructureManager();
            ChunkPos chunkPos = new ChunkPos(blockPos);
            structureStarts = structureManager.m_220477_(chunkPos, struct -> structureRegistry.m_246971_((ResourceKey)structureRegistry.m_7854_(struct).get()).m_203656_(BzTags.NO_HONEYCOMB_HOLES));
            structureStartsPiecewiseCheck = structureManager.m_220477_(chunkPos, struct -> structureRegistry.m_246971_((ResourceKey)structureRegistry.m_7854_(struct).get()).m_203656_(BzTags.NO_HONEYCOMB_HOLES_PIECEWISE));
        }
        for (int repeat = 0; repeat < 2; ++repeat) {
            for (int count = 0; count < 23; ++count) {
                if (alternate) {
                    mutableBlockPos.m_122184_(0, -8, -8);
                } else {
                    mutableBlockPos.m_122184_(0, -8, 8);
                }
                alternate = !alternate;
                boolean validSpot = true;
                for (StructureStart structureStart : structureStarts) {
                    if (!structureStart.m_73603_() || !structureStart.m_73601_().m_191961_(8).m_71051_((Vec3i)mutableBlockPos)) continue;
                    validSpot = false;
                    break;
                }
                block3: for (StructureStart structureStart : structureStartsPiecewiseCheck) {
                    for (StructurePiece structurePiece : structureStart.m_73602_()) {
                        if (!structurePiece.m_73547_().m_191961_(8).m_71051_((Vec3i)mutableBlockPos)) continue;
                        validSpot = false;
                        continue block3;
                    }
                }
                if (!validSpot || !this.isPlaceValid(placementContext, (BlockPos)mutableBlockPos)) continue;
                blockPosList.add(mutableBlockPos.m_7949_());
            }
            mutableBlockPos.m_122178_(blockPos.m_123341_() + 4, 236, blockPos.m_123343_() + 12);
        }
        return blockPosList.stream();
    }

    private boolean isPlaceValid(PlacementContext world, BlockPos pos) {
        boolean completelySolidSlice = false;
        boolean airInSlice = false;
        for (int x = -3; x <= 3; ++x) {
            SliceState state = this.StateOfThisSlice(world, pos.m_122025_(x));
            if (state == SliceState.SOLID) {
                completelySolidSlice = true;
                continue;
            }
            if (state != SliceState.AIR) continue;
            airInSlice = true;
        }
        return completelySolidSlice && airInSlice;
    }

    private SliceState StateOfThisSlice(PlacementContext world, BlockPos pos) {
        for (double z = -4.5; z <= 4.5; z += 1.0) {
            for (double y = -3.5; y <= 3.5; y += 1.0) {
                BlockState blockState;
                double distanceSq = z * z + y * y;
                if (!(distanceSq > 5.0) || !(distanceSq < 18.0) || (blockState = world.m_191828_(pos.m_7637_(0.0, y + 1.0, z))).m_60815_()) continue;
                if (blockState.m_60734_() == Blocks.f_50016_) {
                    return SliceState.AIR;
                }
                return SliceState.NEITHER;
            }
        }
        return SliceState.SOLID;
    }

    private static enum SliceState {
        NEITHER,
        AIR,
        SOLID;

    }
}

